/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class FinalEditAction
extends ProcessingAction {
    private static final String SUBMIT_APPROVE = "submit_approve";

    @Override
    public void activate(Context c, XmlWorkflowItem wf) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException {
        return this.processMainPage(c, wfi, request);
    }

    public ActionResult processMainPage(Context c, XmlWorkflowItem wfi, HttpServletRequest request) throws SQLException, AuthorizeException {
        if (super.isOptionInParam(request)) {
            switch (Util.getSubmitButton(request, "submit_cancel")) {
                case "submit_approve": {
                    this.addApprovedProvenance(c, wfi);
                    return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
                }
            }
            return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
    }

    @Override
    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add(SUBMIT_APPROVE);
        options.add("submit_edit_metadata");
        return options;
    }

    private void addApprovedProvenance(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException {
        String now = DCDate.getCurrent().toString();
        String usersName = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().getEPersonName(c.getCurrentUser());
        String provDescription = this.getProvenanceStartId() + " Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        this.itemService.addMetadata(c, wfi.getItem(), MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription);
        this.itemService.update(c, wfi.getItem());
    }
}

