/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sherpa.v2.SHERPAPublisherResponse;
import org.dspace.app.sherpa.v2.SHERPAResponse;
import org.dspace.app.sherpa.v2.SHERPAUtils;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class SHERPAService {
    private CloseableHttpClient client = null;
    private int maxNumberOfTries;
    private long sleepBetweenTimeouts;
    private int timeout = 5000;
    private String endpoint = null;
    private String apiKey = null;
    private static final Logger log = LogManager.getLogger(SHERPAService.class);
    @Autowired
    ConfigurationService configurationService;

    public SHERPAService() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        this.client = builder.disableAutomaticRetries().setMaxConnTotal(5).build();
    }

    @PostConstruct
    private void init() {
        this.endpoint = this.configurationService.getProperty("sherpa.romeo.url", "https://v2.sherpa.ac.uk/cgi/retrieve");
        this.apiKey = this.configurationService.getProperty("sherpa.romeo.apikey");
    }

    public SHERPAResponse searchByJournalISSN(String query) {
        return this.performRequest("publication", "issn", "equals", query, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SHERPAPublisherResponse performPublisherRequest(String type, String field, String predicate, String value, int start, int limit) {
        if (null == this.apiKey) {
            log.error("SHERPA ROMeO API Key missing: please register for an API key and set sherpa.romeo.apikey");
            return new SHERPAPublisherResponse("SHERPA/RoMEO configuration invalid or missing");
        }
        HttpGet method = null;
        SHERPAPublisherResponse sherpaResponse = null;
        int numberOfTries = 0;
        while (numberOfTries < this.maxNumberOfTries && sherpaResponse == null) {
            log.debug(String.format("Trying to contact SHERPA/RoMEO - attempt %d of %d; timeout is %d; sleep between timeouts is %d", ++numberOfTries, this.maxNumberOfTries, this.timeout, this.sleepBetweenTimeouts));
            try {
                HttpEntity responseBody;
                Thread.sleep(this.sleepBetweenTimeouts);
                method = this.constructHttpGet(type, field, predicate, value, start, limit);
                CloseableHttpResponse response = this.client.execute((HttpUriRequest)method);
                int statusCode = response.getStatusLine().getStatusCode();
                log.debug(response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase());
                if (statusCode != 200) {
                    sherpaResponse = new SHERPAPublisherResponse("SHERPA/RoMEO return not OK status: " + statusCode);
                    String errorBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    log.error("Error from SHERPA HTTP request: " + errorBody);
                }
                if (null != (responseBody = response.getEntity())) {
                    log.debug("Non-null SHERPA resonse received for query of " + value);
                    InputStream content = null;
                    try {
                        content = responseBody.getContent();
                        sherpaResponse = new SHERPAPublisherResponse(content, SHERPAPublisherResponse.SHERPAFormat.JSON);
                        continue;
                    }
                    catch (IOException e) {
                        log.error("Encountered exception while contacting SHERPA/RoMEO: " + e.getMessage(), (Throwable)e);
                        continue;
                    }
                    finally {
                        if (content != null) {
                            content.close();
                        }
                        continue;
                    }
                }
                log.debug("Empty SHERPA response body for query on " + value);
                sherpaResponse = new SHERPAPublisherResponse("SHERPA/RoMEO returned no response");
            }
            catch (URISyntaxException e) {
                String errorMessage = "Error building SHERPA v2 API URI: " + e.getMessage();
                log.error(errorMessage, (Throwable)e);
                sherpaResponse = new SHERPAPublisherResponse(errorMessage);
            }
            catch (IOException e) {
                String errorMessage = "Encountered exception while contacting SHERPA/RoMEO: " + e.getMessage();
                log.error(errorMessage, (Throwable)e);
                sherpaResponse = new SHERPAPublisherResponse(errorMessage);
            }
            catch (InterruptedException e) {
                String errorMessage = "Encountered exception while sleeping thread: " + e.getMessage();
                log.error(errorMessage, (Throwable)e);
                sherpaResponse = new SHERPAPublisherResponse(errorMessage);
            }
            finally {
                if (method == null) continue;
                method.releaseConnection();
            }
        }
        if (sherpaResponse == null) {
            log.debug("SHERPA response is still null");
            sherpaResponse = new SHERPAPublisherResponse("Error processing the SHERPA/RoMEO answer");
        }
        return sherpaResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SHERPAResponse performRequest(String type, String field, String predicate, String value, int start, int limit) {
        if (null == this.apiKey) {
            log.error("SHERPA ROMeO API Key missing: please register for an API key and set sherpa.romeo.apikey");
            return new SHERPAResponse("SHERPA/RoMEO configuration invalid or missing");
        }
        HttpGet method = null;
        SHERPAResponse sherpaResponse = null;
        int numberOfTries = 0;
        while (numberOfTries < this.maxNumberOfTries && sherpaResponse == null) {
            log.debug(String.format("Trying to contact SHERPA/RoMEO - attempt %d of %d; timeout is %d; sleep between timeouts is %d", ++numberOfTries, this.maxNumberOfTries, this.timeout, this.sleepBetweenTimeouts));
            try {
                HttpEntity responseBody;
                Thread.sleep(this.sleepBetweenTimeouts);
                method = this.constructHttpGet(type, field, predicate, value, start, limit);
                CloseableHttpResponse response = this.client.execute((HttpUriRequest)method);
                int statusCode = response.getStatusLine().getStatusCode();
                log.debug(response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase());
                if (statusCode != 200) {
                    sherpaResponse = new SHERPAResponse("SHERPA/RoMEO return not OK status: " + statusCode);
                    String errorBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    log.error("Error from SHERPA HTTP request: " + errorBody);
                }
                if (null != (responseBody = response.getEntity())) {
                    log.debug("Non-null SHERPA resonse received for query of " + value);
                    InputStream content = null;
                    try {
                        content = responseBody.getContent();
                        sherpaResponse = new SHERPAResponse(content, SHERPAResponse.SHERPAFormat.JSON);
                        continue;
                    }
                    catch (IOException e) {
                        log.error("Encountered exception while contacting SHERPA/RoMEO: " + e.getMessage(), (Throwable)e);
                        continue;
                    }
                    finally {
                        if (content != null) {
                            content.close();
                        }
                        continue;
                    }
                }
                log.debug("Empty SHERPA response body for query on " + value);
                sherpaResponse = new SHERPAResponse("SHERPA/RoMEO returned no response");
            }
            catch (URISyntaxException e) {
                String errorMessage = "Error building SHERPA v2 API URI: " + e.getMessage();
                log.error(errorMessage, (Throwable)e);
                sherpaResponse = new SHERPAResponse(errorMessage);
            }
            catch (IOException e) {
                String errorMessage = "Encountered exception while contacting SHERPA/RoMEO: " + e.getMessage();
                log.error(errorMessage, (Throwable)e);
                sherpaResponse = new SHERPAResponse(errorMessage);
            }
            catch (InterruptedException e) {
                String errorMessage = "Encountered exception while sleeping thread: " + e.getMessage();
                log.error(errorMessage, (Throwable)e);
                sherpaResponse = new SHERPAResponse(errorMessage);
            }
            finally {
                if (method == null) continue;
                method.releaseConnection();
            }
        }
        if (sherpaResponse == null) {
            log.debug("SHERPA response is still null");
            sherpaResponse = new SHERPAResponse("Error processing the SHERPA/RoMEO answer");
        }
        return sherpaResponse;
    }

    public HttpGet constructHttpGet(String type, String field, String predicate, String value) throws URISyntaxException {
        return this.constructHttpGet(type, field, predicate, value, 0, 1);
    }

    public HttpGet constructHttpGet(String type, String field, String predicate, String value, int start, int limit) throws URISyntaxException {
        if (null == type) {
            type = "publication";
        }
        field = SHERPAUtils.sanitiseQuery(field);
        predicate = SHERPAUtils.sanitiseQuery(predicate);
        value = SHERPAUtils.sanitiseQuery(value);
        type = SHERPAUtils.sanitiseQuery(type);
        URIBuilder uriBuilder = new URIBuilder(this.endpoint);
        uriBuilder.addParameter("item-type", type);
        uriBuilder.addParameter("filter", "[[\"" + field + "\",\"" + predicate + "\",\"" + value + "\"]]");
        uriBuilder.addParameter("format", "Json");
        if (start >= 0) {
            uriBuilder.addParameter("offset", String.valueOf(start));
        }
        if (limit > 0) {
            uriBuilder.addParameter("limit", String.valueOf(limit));
        }
        if (StringUtils.isNotBlank((CharSequence)this.apiKey)) {
            uriBuilder.addParameter("api-key", this.apiKey);
        }
        log.debug("SHERPA API URL: " + uriBuilder.toString());
        HttpGet method = new HttpGet(uriBuilder.build());
        int timeout = 5000;
        method.setConfig(RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build());
        return method;
    }

    public URI prepareQuery(String query, String endpoint, String apiKey) throws URISyntaxException {
        query = SHERPAUtils.sanitiseQuery(query);
        URIBuilder uriBuilder = new URIBuilder(endpoint);
        uriBuilder.addParameter("item-type", "publication");
        if (null == query) {
            log.warn("No ISSN supplied as query string for SHERPA service search");
        }
        uriBuilder.addParameter("filter", "[[\"issn\",\"equals\",\"" + query + "\"]]");
        uriBuilder.addParameter("format", "Json");
        if (StringUtils.isNotBlank((CharSequence)apiKey)) {
            uriBuilder.addParameter("api-key", apiKey);
        }
        log.debug("Would search SHERPA endpoint with " + uriBuilder.toString());
        return uriBuilder.build();
    }

    public void setMaxNumberOfTries(int maxNumberOfTries) {
        this.maxNumberOfTries = maxNumberOfTries;
    }

    public void setSleepBetweenTimeouts(long sleepBetweenTimeouts) {
        this.sleepBetweenTimeouts = sleepBetweenTimeouts;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

