/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.sherpa.SHERPAService;
import org.dspace.app.sherpa.v2.SHERPAResponse;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.utils.DSpace;

public class SHERPARoMEOJournalTitle
implements ChoiceAuthority {
    private String pluginInstanceName;

    @Override
    public Choices getMatches(String text, int start, int limit, String locale) {
        Choices result;
        if (text == null || text.trim().length() == 0) {
            return new Choices(true);
        }
        SHERPAService sherpaService = (SHERPAService)new DSpace().getSingletonService(SHERPAService.class);
        SHERPAResponse sherpaResponse = sherpaService.performRequest("publication", "title", "contains word", text, 0, 0);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getJournals())) {
            int total;
            List<Choice> list = sherpaResponse.getJournals().stream().skip(start).limit(limit).map(sherpaJournal -> new Choice(sherpaJournal.getIssns().get(0), sherpaJournal.getTitles().get(0), sherpaJournal.getTitles().get(0))).collect(Collectors.toList());
            result = new Choices(list.toArray(new Choice[list.size()]), start, total, 600, (total = sherpaResponse.getJournals().size()) > start + limit);
        } else {
            result = new Choices(false);
        }
        return result;
    }

    @Override
    public Choices getBestMatch(String text, String locale) {
        return this.getMatches(text, 0, 1, locale);
    }

    @Override
    public String getLabel(String key, String locale) {
        SHERPAService sherpaService = (SHERPAService)new DSpace().getSingletonService(SHERPAService.class);
        SHERPAResponse sherpaResponse = sherpaService.performRequest("publication", "issn", "equals", key, 0, 1);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getJournals())) {
            return sherpaResponse.getJournals().get(0).getTitles().get(0);
        }
        return null;
    }

    @Override
    public void setPluginInstanceName(String name) {
        this.pluginInstanceName = name;
    }

    @Override
    public String getPluginInstanceName() {
        return this.pluginInstanceName;
    }
}

