/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.Item_;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.dao.ItemDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ItemDAOImpl
extends AbstractHibernateDSODAO<Item>
implements ItemDAO {
    private static final Logger log = LogManager.getLogger(ItemDAOImpl.class);

    protected ItemDAOImpl() {
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived) throws SQLException {
        Query query = this.createQuery(context, "FROM Item WHERE inArchive=:in_archive ORDER BY id");
        query.setParameter("in_archive", (Object)archived);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived, int limit, int offset) throws SQLException {
        Query query = this.createQuery(context, "FROM Item WHERE inArchive=:in_archive ORDER BY id");
        query.setParameter("in_archive", (Object)archived);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived, boolean withdrawn) throws SQLException {
        Query query = this.createQuery(context, "FROM Item WHERE inArchive=:in_archive or withdrawn=:withdrawn ORDER BY id");
        query.setParameter("in_archive", (Object)archived);
        query.setParameter("withdrawn", (Object)withdrawn);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived, boolean withdrawn, boolean discoverable, Date lastModified) throws SQLException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("SELECT i FROM Item i");
        queryStr.append(" WHERE (inArchive = :in_archive OR withdrawn = :withdrawn)");
        queryStr.append(" AND discoverable = :discoverable");
        if (lastModified != null) {
            queryStr.append(" AND last_modified > :last_modified");
        }
        queryStr.append(" ORDER BY i.id");
        Query query = this.createQuery(context, queryStr.toString());
        query.setParameter("in_archive", (Object)archived);
        query.setParameter("withdrawn", (Object)withdrawn);
        query.setParameter("discoverable", (Object)discoverable);
        if (lastModified != null) {
            query.setParameter("last_modified", lastModified, TemporalType.TIMESTAMP);
        }
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson) throws SQLException {
        Query query = this.createQuery(context, "FROM Item WHERE inArchive=:in_archive and submitter=:submitter ORDER BY id");
        query.setParameter("in_archive", (Object)true);
        query.setParameter("submitter", (Object)eperson);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson, boolean retrieveAllItems) throws SQLException {
        if (!retrieveAllItems) {
            return this.findBySubmitter(context, eperson);
        }
        Query query = this.createQuery(context, "FROM Item WHERE submitter=:submitter ORDER BY id");
        query.setParameter("submitter", (Object)eperson);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson, MetadataField metadataField, int limit) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT item FROM Item as item ");
        this.addMetadataLeftJoin(query, Item.class.getSimpleName().toLowerCase(), Collections.singletonList(metadataField));
        query.append(" WHERE item.inArchive = :in_archive");
        query.append(" AND item.submitter =:submitter");
        this.addMetadataSortQuery(query, Collections.singletonList(metadataField), null, Collections.singletonList("desc"));
        Query hibernateQuery = this.createQuery(context, query.toString());
        hibernateQuery.setParameter(metadataField.toString(), (Object)metadataField.getID());
        hibernateQuery.setParameter("in_archive", (Object)true);
        hibernateQuery.setParameter("submitter", (Object)eperson);
        hibernateQuery.setMaxResults(limit);
        return this.iterate(hibernateQuery);
    }

    @Override
    public Iterator<Item> findByMetadataField(Context context, MetadataField metadataField, String value, boolean inArchive) throws SQLException {
        Object hqlQueryString = "SELECT item FROM Item as item join item.metadata metadatavalue WHERE item.inArchive=:in_archive AND metadatavalue.metadataField = :metadata_field";
        if (value != null) {
            hqlQueryString = (String)hqlQueryString + " AND STR(metadatavalue.value) = :text_value";
        }
        Query query = this.createQuery(context, (String)hqlQueryString + " ORDER BY item.id");
        query.setParameter("in_archive", (Object)inArchive);
        query.setParameter("metadata_field", (Object)metadataField);
        if (value != null) {
            query.setParameter("text_value", (Object)value);
        }
        return this.iterate(query);
    }

    @Override
    @Deprecated
    public Iterator<Item> findByMetadataQuery(Context context, List<List<MetadataField>> listFieldList, List<String> query_op, List<String> query_val, List<UUID> collectionUuids, String regexClause, int offset, int limit) throws SQLException {
        Criteria criteria = this.getHibernateSession(context).createCriteria(Item.class, "item");
        criteria.setFirstResult(offset);
        criteria.setMaxResults(limit);
        if (!collectionUuids.isEmpty()) {
            DetachedCriteria dcollCriteria = DetachedCriteria.forClass(Collection.class, (String)"coll");
            dcollCriteria.setProjection((Projection)Projections.property((String)"coll.id"));
            dcollCriteria.add((Criterion)Restrictions.eqProperty((String)"coll.id", (String)"item.owningCollection"));
            dcollCriteria.add(Restrictions.in((String)"coll.id", collectionUuids));
            criteria.add(Subqueries.exists((DetachedCriteria)dcollCriteria));
        }
        int index = Math.min(listFieldList.size(), Math.min(query_op.size(), query_val.size()));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < index; ++i) {
            OP op = OP.valueOf(query_op.get(i));
            if (op == null) {
                log.warn("Skipping Invalid Operator: " + query_op.get(i));
                continue;
            }
            if ((op == OP.matches || op == OP.doesnt_match) && regexClause.isEmpty()) {
                log.warn("Skipping Unsupported Regex Operator: " + query_op.get(i));
                continue;
            }
            DetachedCriteria subcriteria = DetachedCriteria.forClass(MetadataValue.class, (String)"mv");
            subcriteria.add((Criterion)Property.forName((String)"mv.dSpaceObject").eqProperty("item.id"));
            subcriteria.setProjection((Projection)Projections.property((String)"mv.dSpaceObject"));
            if (!listFieldList.get(i).isEmpty()) {
                subcriteria.add(Restrictions.in((String)"metadataField", (java.util.Collection)listFieldList.get(i)));
            }
            subcriteria.add(op.buildPredicate(query_val.get(i), regexClause));
            if (op == OP.exists || op == OP.equals || op == OP.like || op == OP.contains || op == OP.matches) {
                criteria.add(Subqueries.exists((DetachedCriteria)subcriteria));
                continue;
            }
            criteria.add(Subqueries.notExists((DetachedCriteria)subcriteria));
        }
        criteria.addOrder(org.hibernate.criterion.Order.asc((String)"item.id"));
        log.debug(String.format("Running custom query with %d filters", index));
        return criteria.list().iterator();
    }

    @Override
    public Iterator<Item> findByAuthorityValue(Context context, MetadataField metadataField, String authority, boolean inArchive) throws SQLException {
        Query query = this.createQuery(context, "SELECT item FROM Item as item join item.metadata metadatavalue WHERE item.inArchive=:in_archive AND metadatavalue.metadataField = :metadata_field AND metadatavalue.authority = :authority ORDER BY item.id");
        query.setParameter("in_archive", (Object)inArchive);
        query.setParameter("metadata_field", (Object)metadataField);
        query.setParameter("authority", (Object)authority);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findArchivedByCollection(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        Query query = this.createQuery(context, "select i from Item i join i.collections c WHERE :collection IN c AND i.inArchive=:in_archive ORDER BY i.id");
        query.setParameter("collection", (Object)collection);
        query.setParameter("in_archive", (Object)true);
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findArchivedByCollectionExcludingOwning(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Item> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Item.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)itemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.notEqual((Expression)itemRoot.get(Item_.owningCollection), (Object)collection), criteriaBuilder.isMember((Object)collection, itemRoot.get(Item_.collections)), criteriaBuilder.isTrue((Expression)itemRoot.get(Item_.inArchive))}));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)itemRoot.get(Item_.id))});
        criteriaQuery.groupBy(new Expression[]{itemRoot.get(Item_.id)});
        return this.list(context, criteriaQuery, false, Item.class, limit, offset).iterator();
    }

    @Override
    public int countArchivedByCollectionExcludingOwning(Context context, Collection collection) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Item> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Item.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)itemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.notEqual((Expression)itemRoot.get(Item_.owningCollection), (Object)collection), criteriaBuilder.isMember((Object)collection, itemRoot.get(Item_.collections)), criteriaBuilder.isTrue((Expression)itemRoot.get(Item_.inArchive))}));
        return this.count(context, criteriaQuery, criteriaBuilder, itemRoot);
    }

    @Override
    public Iterator<Item> findAllByCollection(Context context, Collection collection) throws SQLException {
        Query query = this.createQuery(context, "select i from Item i join i.collections c WHERE :collection IN c ORDER BY i.id");
        query.setParameter("collection", (Object)collection);
        return this.iterate(query);
    }

    @Override
    public Iterator<Item> findAllByCollection(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        Query query = this.createQuery(context, "select i from Item i join i.collections c WHERE :collection IN c ORDER BY i.id");
        query.setParameter("collection", (Object)collection);
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        return this.iterate(query);
    }

    @Override
    public int countItems(Context context, Collection collection, boolean includeArchived, boolean includeWithdrawn) throws SQLException {
        Query query = this.createQuery(context, "select count(i) from Item i join i.collections c WHERE :collection IN c AND i.inArchive=:in_archive AND i.withdrawn=:withdrawn");
        query.setParameter("collection", (Object)collection);
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        return this.count(query);
    }

    @Override
    public int countItems(Context context, List<Collection> collections, boolean includeArchived, boolean includeWithdrawn) throws SQLException {
        if (collections.size() == 0) {
            return 0;
        }
        Query query = this.createQuery(context, "select count(distinct i) from Item i join i.collections collection WHERE collection IN (:collections) AND i.inArchive=:in_archive AND i.withdrawn=:withdrawn");
        query.setParameter("collections", collections);
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        return this.count(query);
    }

    @Override
    public Iterator<Item> findByLastModifiedSince(Context context, Date since) throws SQLException {
        Query query = this.createQuery(context, "SELECT i FROM Item i WHERE last_modified > :last_modified ORDER BY id");
        query.setParameter("last_modified", since, TemporalType.TIMESTAMP);
        return this.iterate(query);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Item"));
    }

    @Override
    public int countItems(Context context, boolean includeArchived, boolean includeWithdrawn) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM Item i WHERE i.inArchive=:in_archive AND i.withdrawn=:withdrawn");
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        return this.count(query);
    }

    @Override
    public int countItems(Context context, EPerson submitter, boolean includeArchived, boolean includeWithdrawn) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM Item i join i.submitter submitter WHERE i.inArchive=:in_archive AND i.withdrawn=:withdrawn AND submitter = :submitter");
        query.setParameter("submitter", (Object)submitter);
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        return this.count(query);
    }

    static enum OP {
        equals{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return Property.forName((String)"mv.value").eq((Object)val);
            }
        }
        ,
        not_equals{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return equals.buildPredicate(val, regexClause);
            }
        }
        ,
        like{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return Property.forName((String)"mv.value").like((Object)val);
            }
        }
        ,
        not_like{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return like.buildPredicate(val, regexClause);
            }
        }
        ,
        contains{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return Property.forName((String)"mv.value").like((Object)("%" + val + "%"));
            }
        }
        ,
        doesnt_contain{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return contains.buildPredicate(val, regexClause);
            }
        }
        ,
        exists{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return Property.forName((String)"mv.value").isNotNull();
            }
        }
        ,
        doesnt_exist{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return exists.buildPredicate(val, regexClause);
            }
        }
        ,
        matches{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return Restrictions.sqlRestriction((String)regexClause, (Object)val, (Type)StandardBasicTypes.STRING);
            }
        }
        ,
        doesnt_match{

            @Override
            public Criterion buildPredicate(String val, String regexClause) {
                return matches.buildPredicate(val, regexClause);
            }
        };


        public abstract Criterion buildPredicate(String var1, String var2);
    }
}

