/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.mail.MessagingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.itemimport.BatchUpload;
import org.dspace.app.itemimport.service.ItemImportService;
import org.dspace.app.util.LocalSchemaFilenameFilter;
import org.dspace.app.util.RelationshipUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.workflow.WorkflowService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ItemImportServiceImpl
implements ItemImportService,
InitializingBean {
    private final Logger log = LogManager.getLogger(ItemImportServiceImpl.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected BitstreamFormatService bitstreamFormatService;
    @Autowired(required=true)
    protected BundleService bundleService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected EPersonService ePersonService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected InstallItemService installItemService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected MetadataFieldService metadataFieldService;
    @Autowired(required=true)
    protected MetadataSchemaService metadataSchemaService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected WorkflowService workflowService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected RelationshipService relationshipService;
    @Autowired(required=true)
    protected RelationshipTypeService relationshipTypeService;
    @Autowired(required=true)
    protected MetadataValueService metadataValueService;
    protected String tempWorkDir;
    protected boolean isTest = false;
    protected boolean isResume = false;
    protected boolean useWorkflow = false;
    protected boolean useWorkflowSendEmail = false;
    protected boolean isQuiet = false;
    Map<String, Item> itemFolderMap = null;
    protected FilenameFilter metadataFileFilter = new LocalSchemaFilenameFilter();
    protected FilenameFilter directoryFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String n) {
            File item = new File(dir.getAbsolutePath() + File.separatorChar + n);
            return item.isDirectory();
        }
    };

    public void afterPropertiesSet() throws Exception {
        this.tempWorkDir = this.configurationService.getProperty("org.dspace.app.batchitemimport.work.dir");
        File tempWorkDirFile = new File(this.tempWorkDir);
        if (!tempWorkDirFile.exists()) {
            boolean success = tempWorkDirFile.mkdir();
            if (success) {
                this.log.info("Created org.dspace.app.batchitemimport.work.dir of: " + this.tempWorkDir);
            } else {
                this.log.error("Cannot create batch import directory! " + this.tempWorkDir);
            }
        }
    }

    protected ItemImportServiceImpl() {
    }

    @Override
    public void addItemsAtomic(Context c, List<Collection> mycollections, String sourceDir, String mapFile, boolean template) throws Exception {
        try {
            this.addItems(c, mycollections, sourceDir, mapFile, template);
        }
        catch (Exception addException) {
            this.log.error("AddItems encountered an error, will try to revert. Error: " + addException.getMessage());
            this.deleteItems(c, mapFile);
            this.log.info("Attempted to delete partial (errored) import");
            throw addException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItems(Context c, List<Collection> mycollections, String sourceDir, String mapFile, boolean template) throws Exception {
        File outFile = null;
        PrintWriter mapOut = null;
        try {
            File d;
            Map<Object, Object> skipItems = new HashMap();
            this.itemFolderMap = new HashMap<String, Item>();
            System.out.println("Adding items from directory: " + sourceDir);
            this.log.debug("Adding items from directory: " + sourceDir);
            System.out.println("Generating mapfile: " + mapFile);
            this.log.debug("Generating mapfile: " + mapFile);
            boolean directoryFileCollections = false;
            if (mycollections == null) {
                directoryFileCollections = true;
            }
            if (!this.isTest) {
                if (this.isResume) {
                    skipItems = this.readMapFile(mapFile);
                }
                if ((mapOut = new PrintWriter(new FileWriter(outFile = new File(mapFile), this.isResume))) == null) {
                    throw new Exception("can't open mapfile: " + mapFile);
                }
            }
            if ((d = new File(sourceDir)) == null || !d.isDirectory()) {
                throw new Exception("Error, cannot open source directory " + sourceDir);
            }
            String[] dircontents = d.list(this.directoryFilter);
            Arrays.sort(dircontents, ComparatorUtils.naturalComparator());
            for (int i = 0; i < dircontents.length; ++i) {
                List<Collection> clist;
                block15: {
                    if (skipItems.containsKey(dircontents[i])) {
                        System.out.println("Skipping import of " + dircontents[i]);
                        String skippedHandle = (String)skipItems.get(dircontents[i]);
                        Item skippedItem = (Item)this.handleService.resolveToObject(c, skippedHandle);
                        this.itemFolderMap.put(dircontents[i], skippedItem);
                        continue;
                    }
                    if (directoryFileCollections) {
                        String path = sourceDir + File.separatorChar + dircontents[i];
                        try {
                            List<Collection> cols = this.processCollectionFile(c, path, "collections");
                            if (cols == null) {
                                System.out.println("No collections specified for item " + dircontents[i] + ". Skipping.");
                                continue;
                            }
                            clist = cols;
                            break block15;
                        }
                        catch (IllegalArgumentException e) {
                            System.out.println(e.getMessage() + " Skipping.");
                            continue;
                        }
                    }
                    clist = mycollections;
                }
                Item item = this.addItem(c, clist, sourceDir, dircontents[i], mapOut, template);
                this.itemFolderMap.put(dircontents[i], item);
                c.uncacheEntity(item);
                System.out.println(i + " " + dircontents[i]);
            }
            this.addRelationships(c, sourceDir);
        }
        finally {
            if (mapOut != null) {
                mapOut.flush();
                mapOut.close();
            }
        }
    }

    protected void addRelationships(Context c, String sourceDir) throws Exception {
        for (Map.Entry<String, Item> itemEntry : this.itemFolderMap.entrySet()) {
            String folderName = itemEntry.getKey();
            String path = sourceDir + File.separatorChar + folderName;
            Item item = itemEntry.getValue();
            Map<String, List<String>> relationships = this.processRelationshipFile(path, "relationships");
            if (relationships.isEmpty()) continue;
            for (Map.Entry<String, List<String>> relEntry : relationships.entrySet()) {
                String relationshipType = relEntry.getKey();
                List<String> identifierList = relEntry.getValue();
                for (String itemIdentifier : identifierList) {
                    if (this.isTest) {
                        System.out.println("\tAdding relationship (type: " + relationshipType + ") from " + folderName + " to " + itemIdentifier);
                        continue;
                    }
                    Item relationItem = this.resolveRelatedItem(c, itemIdentifier);
                    if (null == relationItem) {
                        throw new Exception("Could not find item for " + itemIdentifier);
                    }
                    String itemEntityType = this.getEntityType(item);
                    String relatedEntityType = this.getEntityType(relationItem);
                    List<RelationshipType> relTypes = this.relationshipTypeService.findByLeftwardOrRightwardTypeName(c, relationshipType);
                    RelationshipType foundRelationshipType = RelationshipUtils.matchRelationshipType(relTypes, relatedEntityType, itemEntityType, relationshipType);
                    if (foundRelationshipType == null) {
                        throw new Exception("No Relationship type found for:\nTarget type: " + relatedEntityType + "\nOrigin referer type: " + itemEntityType + "\nwith typeName: " + relationshipType);
                    }
                    boolean left = false;
                    if (foundRelationshipType.getLeftwardType().equalsIgnoreCase(relationshipType)) {
                        left = true;
                    }
                    Item leftItem = null;
                    Item rightItem = null;
                    if (left) {
                        leftItem = item;
                        rightItem = relationItem;
                    } else {
                        leftItem = relationItem;
                        rightItem = item;
                    }
                    Relationship persistedRelationship = this.relationshipService.create(c, leftItem, rightItem, foundRelationshipType, -1, -1);
                    System.out.println("\tAdded relationship (type: " + relationshipType + ") from " + leftItem.getHandle() + " to " + rightItem.getHandle());
                }
            }
        }
    }

    protected String getEntityType(Item item) throws Exception {
        return this.itemService.getMetadata(item, "dspace", "entity", "type", "*").get(0).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, List<String>> processRelationshipFile(String path, String filename) throws Exception {
        File file = new File(path + File.separatorChar + filename);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (file.exists()) {
            System.out.println("\tProcessing relationships file: " + filename);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ("".equals(line = line.trim())) continue;
                    String relationshipType = null;
                    String itemIdentifier = null;
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.hasMoreTokens()) {
                        relationshipType = st.nextToken();
                        if (relationshipType.split("\\.").length > 1) {
                            relationshipType = relationshipType.split("\\.")[1];
                        }
                    } else {
                        throw new Exception("Bad mapfile line:\n" + line);
                    }
                    if (!st.hasMoreTokens()) {
                        throw new Exception("Bad mapfile line:\n" + line);
                    }
                    itemIdentifier = st.nextToken("").trim();
                    if (!result.containsKey(relationshipType)) {
                        result.put(relationshipType, new ArrayList());
                    }
                    ((List)result.get(relationshipType)).add(itemIdentifier);
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("\tNo relationships file found.");
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        System.out.println("Non-critical problem releasing resources.");
                    }
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Item resolveRelatedItem(Context c, String itemIdentifier) throws Exception {
        if (itemIdentifier.contains(":")) {
            if (itemIdentifier.startsWith("folderName:") || itemIdentifier.startsWith("rowName:")) {
                int i = itemIdentifier.indexOf(":");
                String folderName = itemIdentifier.substring(i + 1);
                if (!this.itemFolderMap.containsKey(folderName)) return null;
                return this.itemFolderMap.get(folderName);
            }
            int i = itemIdentifier.indexOf(":");
            String metaKey = itemIdentifier.substring(0, i);
            String metaValue = itemIdentifier.substring(i + 1);
            return this.findItemByMetaValue(c, metaKey, metaValue);
        }
        if (itemIdentifier.indexOf(47) == -1) return (Item)this.itemService.findByIdOrLegacyId(c, itemIdentifier);
        return (Item)this.handleService.resolveToObject(c, itemIdentifier);
    }

    protected Item findItemByMetaValue(Context c, String metaKey, String metaValue) throws Exception {
        Item item = null;
        String[] mf = metaKey.split("\\.");
        if (mf.length < 2) {
            throw new Exception("Bad metadata field in reference: '" + metaKey + "' (expected syntax is schema.element[.qualifier])");
        }
        String schema = mf[0];
        String element = mf[1];
        String qualifier = mf.length == 2 ? null : mf[2];
        try {
            MetadataField mfo = this.metadataFieldService.findByElement(c, schema, element, qualifier);
            Iterator<MetadataValue> mdv = this.metadataValueService.findByFieldAndValue(c, mfo, metaValue);
            if (mdv.hasNext()) {
                MetadataValue mdvVal = mdv.next();
                UUID uuid = mdvVal.getDSpaceObject().getID();
                if (mdv.hasNext()) {
                    throw new Exception("Ambiguous reference; multiple matches in db: " + metaKey);
                }
                item = (Item)this.itemService.find(c, uuid);
            }
        }
        catch (SQLException e) {
            throw new Exception("Error looking up item by metadata reference: " + metaKey, e);
        }
        if (item == null) {
            throw new Exception("Item not found by metadata reference: " + metaKey);
        }
        return item;
    }

    @Override
    public void replaceItems(Context c, List<Collection> mycollections, String sourceDir, String mapFile, boolean template) throws Exception {
        File d = new File(sourceDir);
        if (d == null || !d.isDirectory()) {
            throw new Exception("Error, cannot open source directory " + sourceDir);
        }
        Map<String, String> myHash = this.readMapFile(mapFile);
        for (Map.Entry<String, String> mapEntry : myHash.entrySet()) {
            String newItemName = mapEntry.getKey();
            String oldHandle = mapEntry.getValue();
            Item oldItem = null;
            if (oldHandle.indexOf(47) != -1) {
                System.out.println("\tReplacing:  " + oldHandle);
                oldItem = (Item)this.handleService.resolveToObject(c, oldHandle);
            } else {
                oldItem = (Item)this.itemService.findByIdOrLegacyId(c, oldHandle);
            }
            File handleFile = new File(sourceDir + File.separatorChar + newItemName + File.separatorChar + "handle");
            PrintWriter handleOut = new PrintWriter(new FileWriter(handleFile, true));
            if (handleOut == null) {
                throw new Exception("can't open handle file: " + handleFile.getCanonicalPath());
            }
            handleOut.println(oldHandle);
            handleOut.close();
            this.deleteItem(c, oldItem);
            Item newItem = this.addItem(c, mycollections, sourceDir, newItemName, null, template);
            c.uncacheEntity(oldItem);
            c.uncacheEntity(newItem);
        }
    }

    @Override
    public void deleteItems(Context c, String mapFile) throws Exception {
        System.out.println("Deleting items listed in mapfile: " + mapFile);
        Map<String, String> myhash = this.readMapFile(mapFile);
        Iterator<String> i = myhash.keySet().iterator();
        while (i.hasNext()) {
            String itemID = myhash.get(i.next());
            if (itemID.indexOf(47) != -1) {
                String myhandle = itemID;
                System.out.println("Deleting item " + myhandle);
                this.deleteItem(c, myhandle);
                continue;
            }
            Item myitem = (Item)this.itemService.findByIdOrLegacyId(c, itemID);
            System.out.println("Deleting item " + itemID);
            this.deleteItem(c, myitem);
            c.uncacheEntity(myitem);
        }
    }

    protected Item addItem(Context c, List<Collection> mycollections, String path, String itemname, PrintWriter mapOut, boolean template) throws Exception {
        String mapOutputString = null;
        System.out.println("Adding item from directory " + itemname);
        this.log.debug("adding item from directory " + itemname);
        Item myitem = null;
        WorkspaceItem wi = null;
        ReloadableEntity wfi = null;
        if (!this.isTest) {
            wi = this.workspaceItemService.create(c, mycollections.iterator().next(), template);
            myitem = wi.getItem();
        }
        this.loadMetadata(c, myitem, path + File.separatorChar + itemname + File.separatorChar);
        List<String> options = this.processContentsFile(c, myitem, path + File.separatorChar + itemname, "contents");
        if (this.useWorkflow) {
            if (!this.isTest) {
                wfi = this.useWorkflowSendEmail ? (ReloadableEntity)this.workflowService.start(c, wi) : (ReloadableEntity)this.workflowService.startWithoutNotify(c, wi);
                mapOutputString = itemname + " " + myitem.getID();
            }
        } else {
            String myhandle = this.processHandleFile(c, myitem, path + File.separatorChar + itemname, "handle");
            if (!this.isTest) {
                try {
                    this.installItemService.installItem(c, wi, myhandle);
                }
                catch (Exception e) {
                    this.workspaceItemService.deleteAll(c, wi);
                    this.log.error("Exception after install item, try to revert...", (Throwable)e);
                    throw e;
                }
                myhandle = this.handleService.findHandle(c, myitem);
                mapOutputString = itemname + " " + myhandle;
            }
            if (options.size() > 0) {
                System.out.println("Processing options");
                this.processOptions(c, myitem, options);
            }
        }
        if (mycollections.size() > 1) {
            for (int i = 1; i < mycollections.size(); ++i) {
                if (this.isTest) continue;
                this.collectionService.addItem(c, mycollections.get(i), myitem);
            }
        }
        if (mapOut != null) {
            mapOut.println(mapOutputString);
        }
        c.uncacheEntity(wi);
        c.uncacheEntity(wfi);
        return myitem;
    }

    protected void deleteItem(Context c, Item myitem) throws Exception {
        if (!this.isTest) {
            ArrayList<Collection> removeList = new ArrayList<Collection>();
            List<Collection> collections = myitem.getCollections();
            for (Collection collection : collections) {
                removeList.add(collection);
            }
            for (Collection collection : removeList) {
                this.collectionService.removeItem(c, collection, myitem);
            }
        }
    }

    protected void deleteItem(Context c, String myhandle) throws Exception {
        Item myitem = (Item)this.handleService.resolveToObject(c, myhandle);
        if (myitem == null) {
            System.out.println("Error - cannot locate item - already deleted?");
        } else {
            this.deleteItem(c, myitem);
            c.uncacheEntity(myitem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> readMapFile(String filename) throws Exception {
        HashMap<String, String> myHash = new HashMap<String, String>();
        try (BufferedReader is = null;){
            String line;
            is = new BufferedReader(new FileReader(filename));
            while ((line = is.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) {
                    throw new Exception("Bad mapfile line:\n" + line);
                }
                String myFile = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new Exception("Bad mapfile line:\n" + line);
                }
                String myHandle = st.nextToken();
                myHash.put(myFile, myHandle);
            }
        }
        return myHash;
    }

    protected void loadMetadata(Context c, Item myitem, String path) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException, XPathExpressionException {
        this.loadDublinCore(c, myitem, path + "dublin_core.xml");
        File folder = new File(path);
        File[] file = folder.listFiles(this.metadataFileFilter);
        for (int i = 0; i < file.length; ++i) {
            this.loadDublinCore(c, myitem, file[i].getAbsolutePath());
        }
    }

    protected void loadDublinCore(Context c, Item myitem, String filename) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException, XPathExpressionException {
        Document document = this.loadXML(filename);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList metadata = (NodeList)xPath.compile("/dublin_core").evaluate(document, XPathConstants.NODESET);
        Node schemaAttr = metadata.item(0).getAttributes().getNamedItem("schema");
        String schema = schemaAttr == null ? MetadataSchemaEnum.DC.getName() : schemaAttr.getNodeValue();
        NodeList dcNodes = (NodeList)xPath.compile("/dublin_core/dcvalue").evaluate(document, XPathConstants.NODESET);
        if (!this.isQuiet) {
            System.out.println("\tLoading dublin core from " + filename);
        }
        for (int i = 0; i < dcNodes.getLength(); ++i) {
            Node n = dcNodes.item(i);
            this.addDCValue(c, myitem, schema, n);
        }
    }

    protected void addDCValue(Context c, Item i, String schema, Node n) throws TransformerException, SQLException, AuthorizeException {
        String value = this.getStringValue(n);
        value = value == null ? "" : value.trim();
        String element = this.getAttributeValue(n, "element");
        String qualifier = this.getAttributeValue(n, "qualifier");
        String language = this.getAttributeValue(n, "language");
        if (language != null) {
            language = language.trim();
        }
        if (!this.isQuiet) {
            System.out.println("\tSchema: " + schema + " Element: " + element + " Qualifier: " + qualifier + " Value: " + value);
        }
        if ("none".equals(qualifier) || "".equals(qualifier)) {
            qualifier = null;
        }
        if (!this.isTest && !value.equals("")) {
            this.itemService.addMetadata(c, i, schema, element, qualifier, language, value);
        } else {
            MetadataSchema foundSchema = this.metadataSchemaService.find(c, schema);
            if (foundSchema == null) {
                System.out.println("ERROR: schema '" + schema + "' was not found in the registry.");
                return;
            }
            MetadataField foundField = this.metadataFieldService.findByElement(c, foundSchema, element, qualifier);
            if (foundField == null) {
                System.out.println("ERROR: Metadata field: '" + schema + "." + element + "." + qualifier + "' was not found in the registry.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Collection> processCollectionFile(Context c, String path, String filename) throws IOException, SQLException {
        File file = new File(path + File.separatorChar + filename);
        ArrayList<Collection> collections = new ArrayList<Collection>();
        ArrayList<Collection> result = null;
        System.out.println("Processing collections file: " + filename);
        if (file.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = br.readLine()) != null) {
                    DSpaceObject obj = null;
                    if (line.indexOf(47) != -1) {
                        obj = this.handleService.resolveToObject(c, line);
                        if (obj == null || obj.getType() != 3) {
                            obj = null;
                        }
                    } else {
                        obj = this.collectionService.find(c, UUID.fromString(line));
                    }
                    if (obj == null) {
                        throw new IllegalArgumentException("Cannot resolve " + line + " to a collection.");
                    }
                    collections.add((Collection)obj);
                }
                result = collections;
            }
            catch (FileNotFoundException e) {
                System.out.println("No collections file found.");
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        System.out.println("Non-critical problem releasing resources.");
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processHandleFile(Context c, Item i, String path, String filename) {
        File file = new File(path + File.separatorChar + filename);
        String result = null;
        System.out.println("Processing handle file: " + filename);
        if (file.exists()) {
            BufferedReader is = null;
            try {
                is = new BufferedReader(new FileReader(file));
                result = is.readLine();
                System.out.println("read handle: '" + result + "'");
            }
            catch (FileNotFoundException e) {
                System.out.println("It appears there is no handle file -- generating one");
            }
            catch (IOException e) {
                System.out.println("It appears there is no handle file -- generating one");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        System.err.println("Non-critical problem releasing resources.");
                    }
                }
            }
        } else {
            System.out.println("It appears there is no handle file -- generating one");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> processContentsFile(Context c, Item i, String path, String filename) throws SQLException, IOException, AuthorizeException {
        File contentsFile = new File(path + File.separatorChar + filename);
        String line = "";
        ArrayList<String> options = new ArrayList<String>();
        System.out.println("\tProcessing contents file: " + contentsFile);
        if (contentsFile.exists()) {
            try (BufferedReader is = null;){
                is = new BufferedReader(new FileReader(contentsFile));
                while ((line = is.readLine()) != null) {
                    if ("".equals(line.trim())) continue;
                    if (line.trim().startsWith("-r ")) {
                        String sRegistrationLine = line.trim();
                        int iAssetstore = -1;
                        String sFilePath = null;
                        String sBundle = null;
                        StringTokenizer tokenizer = new StringTokenizer(sRegistrationLine);
                        while (tokenizer.hasMoreTokens()) {
                            String sToken = tokenizer.nextToken();
                            if ("-r".equals(sToken)) continue;
                            if ("-s".equals(sToken) && tokenizer.hasMoreTokens()) {
                                try {
                                    iAssetstore = Integer.parseInt(tokenizer.nextToken());
                                }
                                catch (NumberFormatException numberFormatException) {}
                                continue;
                            }
                            if ("-f".equals(sToken) && tokenizer.hasMoreTokens()) {
                                sFilePath = tokenizer.nextToken();
                                continue;
                            }
                            if (!sToken.startsWith("bundle:")) continue;
                            sBundle = sToken.substring(7);
                        }
                        if (iAssetstore == -1 || sFilePath == null) {
                            System.out.println("\tERROR: invalid contents file line");
                            System.out.println("\t\tSkipping line: " + sRegistrationLine);
                            continue;
                        }
                        boolean descriptionExists = false;
                        String descriptionMarker = "\tdescription:";
                        int dMarkerIndex = line.indexOf(descriptionMarker);
                        int dEndIndex = 0;
                        if (dMarkerIndex > 0) {
                            dEndIndex = line.indexOf("\t", dMarkerIndex + 1);
                            if (dEndIndex == -1) {
                                dEndIndex = line.length();
                            }
                            descriptionExists = true;
                        }
                        String sDescription = "";
                        if (descriptionExists) {
                            sDescription = line.substring(dMarkerIndex, dEndIndex);
                            sDescription = sDescription.replaceFirst("description:", "");
                        }
                        this.registerBitstream(c, i, iAssetstore, sFilePath, sBundle, sDescription);
                        System.out.println("\tRegistering Bitstream: " + sFilePath + "\tAssetstore: " + iAssetstore + "\tBundle: " + sBundle + "\tDescription: " + sDescription);
                        continue;
                    }
                    int bitstreamEndIndex = line.indexOf(9);
                    if (bitstreamEndIndex == -1) {
                        this.processContentFileEntry(c, i, path, line, null, false);
                        System.out.println("\tBitstream: " + line);
                        continue;
                    }
                    String bitstreamName = line.substring(0, bitstreamEndIndex);
                    boolean bundleExists = false;
                    boolean permissionsExist = false;
                    boolean descriptionExists = false;
                    boolean labelExists = false;
                    boolean heightExists = false;
                    boolean widthExists = false;
                    boolean tocExists = false;
                    String labelMarker = "\tiiif-label";
                    int lMarkerIndex = line.indexOf(labelMarker);
                    int lEndIndex = 0;
                    if (lMarkerIndex > 0) {
                        lEndIndex = line.indexOf("\t", lMarkerIndex + 1);
                        if (lEndIndex == -1) {
                            lEndIndex = line.length();
                        }
                        labelExists = true;
                    }
                    String heightMarker = "\tiiif-height";
                    int hMarkerIndex = line.indexOf(heightMarker);
                    int hEndIndex = 0;
                    if (hMarkerIndex > 0) {
                        hEndIndex = line.indexOf("\t", hMarkerIndex + 1);
                        if (hEndIndex == -1) {
                            hEndIndex = line.length();
                        }
                        heightExists = true;
                    }
                    String widthMarker = "\tiiif-width";
                    int wMarkerIndex = line.indexOf(widthMarker);
                    int wEndIndex = 0;
                    if (wMarkerIndex > 0) {
                        wEndIndex = line.indexOf("\t", wMarkerIndex + 1);
                        if (wEndIndex == -1) {
                            wEndIndex = line.length();
                        }
                        widthExists = true;
                    }
                    String tocMarker = "\tiiif-toc";
                    int tMarkerIndex = line.indexOf(tocMarker);
                    int tEndIndex = 0;
                    if (tMarkerIndex > 0) {
                        tEndIndex = line.indexOf("\t", tMarkerIndex + 1);
                        if (tEndIndex == -1) {
                            tEndIndex = line.length();
                        }
                        tocExists = true;
                    }
                    String bundleMarker = "\tbundle:";
                    int bMarkerIndex = line.indexOf(bundleMarker);
                    int bEndIndex = 0;
                    if (bMarkerIndex > 0) {
                        bEndIndex = line.indexOf("\t", bMarkerIndex + 1);
                        if (bEndIndex == -1) {
                            bEndIndex = line.length();
                        }
                        bundleExists = true;
                    }
                    String permissionsMarker = "\tpermissions:";
                    int pMarkerIndex = line.indexOf(permissionsMarker);
                    int pEndIndex = 0;
                    if (pMarkerIndex > 0) {
                        pEndIndex = line.indexOf("\t", pMarkerIndex + 1);
                        if (pEndIndex == -1) {
                            pEndIndex = line.length();
                        }
                        permissionsExist = true;
                    }
                    String descriptionMarker = "\tdescription:";
                    int dMarkerIndex = line.indexOf(descriptionMarker);
                    int dEndIndex = 0;
                    if (dMarkerIndex > 0) {
                        dEndIndex = line.indexOf("\t", dMarkerIndex + 1);
                        if (dEndIndex == -1) {
                            dEndIndex = line.length();
                        }
                        descriptionExists = true;
                    }
                    String primaryBitstreamMarker = "\tprimary:true";
                    boolean primary = false;
                    String primaryStr = "";
                    if (line.contains(primaryBitstreamMarker)) {
                        primary = true;
                        primaryStr = "\t **Setting as primary bitstream**";
                    }
                    if (bundleExists) {
                        String bundleName = line.substring(bMarkerIndex + bundleMarker.length(), bEndIndex).trim();
                        this.processContentFileEntry(c, i, path, bitstreamName, bundleName, primary);
                        System.out.println("\tBitstream: " + bitstreamName + "\tBundle: " + bundleName + primaryStr);
                    } else {
                        this.processContentFileEntry(c, i, path, bitstreamName, null, primary);
                        System.out.println("\tBitstream: " + bitstreamName + primaryStr);
                    }
                    if (!permissionsExist && !descriptionExists && !labelExists && !heightExists && !widthExists && !tocExists) continue;
                    System.out.println("Gathering options.");
                    Object extraInfo = bitstreamName;
                    if (permissionsExist) {
                        extraInfo = (String)extraInfo + line.substring(pMarkerIndex, pEndIndex);
                    }
                    if (descriptionExists) {
                        extraInfo = (String)extraInfo + line.substring(dMarkerIndex, dEndIndex);
                    }
                    if (labelExists) {
                        extraInfo = (String)extraInfo + line.substring(lMarkerIndex, lEndIndex);
                    }
                    if (heightExists) {
                        extraInfo = (String)extraInfo + line.substring(hMarkerIndex, hEndIndex);
                    }
                    if (widthExists) {
                        extraInfo = (String)extraInfo + line.substring(wMarkerIndex, wEndIndex);
                    }
                    if (tocExists) {
                        extraInfo = (String)extraInfo + line.substring(tMarkerIndex, tEndIndex);
                    }
                    options.add((String)extraInfo);
                }
            }
        } else {
            String[] dirListing;
            File dir = new File(path);
            for (String fileName : dirListing = dir.list()) {
                if ("dublin_core.xml".equals(fileName) || fileName.equals("handle") || this.metadataFileFilter.accept(dir, fileName)) continue;
                throw new FileNotFoundException("No contents file found");
            }
            System.out.println("No contents file found - but only metadata files found. Assuming metadata only.");
        }
        return options;
    }

    protected void processContentFileEntry(Context c, Item i, String path, String fileName, String bundleName, boolean primary) throws SQLException, IOException, AuthorizeException {
        String fullpath = path + File.separatorChar + fileName;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fullpath));
        Bitstream bs = null;
        String newBundleName = bundleName;
        if (bundleName == null) {
            newBundleName = "license.txt".equals(fileName) ? "LICENSE" : "ORIGINAL";
        }
        if (!this.isTest) {
            List<Bundle> bundles = this.itemService.getBundles(i, newBundleName);
            Bundle targetBundle = null;
            targetBundle = bundles.size() < 1 ? this.bundleService.create(c, i, newBundleName) : bundles.iterator().next();
            bs = this.bitstreamService.create(c, targetBundle, bis);
            bs.setName(c, fileName);
            BitstreamFormat bf = this.bitstreamFormatService.guessFormat(c, bs);
            this.bitstreamService.setFormat(c, bs, bf);
            if (primary) {
                targetBundle.setPrimaryBitstreamID(bs);
                this.bundleService.update(c, targetBundle);
            }
            this.bitstreamService.update(c, bs);
        }
        bis.close();
    }

    protected void registerBitstream(Context c, Item i, int assetstore, String bitstreamPath, String bundleName, String description) throws SQLException, IOException, AuthorizeException {
        Bitstream bs = null;
        String newBundleName = bundleName;
        if (StringUtils.isBlank((CharSequence)bundleName)) {
            newBundleName = bitstreamPath.endsWith("license.txt") ? "LICENSE" : "ORIGINAL";
        }
        if (!this.isTest) {
            List<Bundle> bundles = this.itemService.getBundles(i, newBundleName);
            Bundle targetBundle = null;
            targetBundle = bundles.size() < 1 ? this.bundleService.create(c, i, newBundleName) : bundles.iterator().next();
            bs = this.bitstreamService.register(c, targetBundle, assetstore, bitstreamPath);
            int iLastSlash = bitstreamPath.lastIndexOf(47);
            bs.setName(c, bitstreamPath.substring(iLastSlash + 1));
            BitstreamFormat bf = this.bitstreamFormatService.guessFormat(c, bs);
            this.bitstreamService.setFormat(c, bs, bf);
            bs.setDescription(c, description);
            this.bitstreamService.update(c, bs);
        }
    }

    protected void processOptions(Context c, Item myItem, List<String> options) throws SQLException, AuthorizeException {
        System.out.println("Processing options.");
        for (String line : options) {
            MetadataField metadataField;
            System.out.println("\tprocessing " + line);
            boolean permissionsExist = false;
            boolean descriptionExists = false;
            boolean labelExists = false;
            boolean heightExists = false;
            boolean widthExists = false;
            boolean tocExists = false;
            String permissionsMarker = "\tpermissions:";
            int pMarkerIndex = line.indexOf(permissionsMarker);
            int pEndIndex = 0;
            if (pMarkerIndex > 0) {
                pEndIndex = line.indexOf("\t", pMarkerIndex + 1);
                if (pEndIndex == -1) {
                    pEndIndex = line.length();
                }
                permissionsExist = true;
            }
            String descriptionMarker = "\tdescription:";
            int dMarkerIndex = line.indexOf(descriptionMarker);
            int dEndIndex = 0;
            if (dMarkerIndex > 0) {
                dEndIndex = line.indexOf("\t", dMarkerIndex + 1);
                if (dEndIndex == -1) {
                    dEndIndex = line.length();
                }
                descriptionExists = true;
            }
            String labelMarker = "\tiiif-label:";
            int lMarkerIndex = line.indexOf(labelMarker);
            int lEndIndex = 0;
            if (lMarkerIndex > 0) {
                lEndIndex = line.indexOf("\t", lMarkerIndex + 1);
                if (lEndIndex == -1) {
                    lEndIndex = line.length();
                }
                labelExists = true;
            }
            String heightMarker = "\tiiif-height:";
            int hMarkerIndex = line.indexOf(heightMarker);
            int hEndIndex = 0;
            if (hMarkerIndex > 0) {
                hEndIndex = line.indexOf("\t", hMarkerIndex + 1);
                if (hEndIndex == -1) {
                    hEndIndex = line.length();
                }
                heightExists = true;
            }
            String widthMarker = "\tiiif-width:";
            int wMarkerIndex = line.indexOf(widthMarker);
            int wEndIndex = 0;
            if (wMarkerIndex > 0) {
                wEndIndex = line.indexOf("\t", wMarkerIndex + 1);
                if (wEndIndex == -1) {
                    wEndIndex = line.length();
                }
                widthExists = true;
            }
            String tocMarker = "\tiiif-toc:";
            int tMarkerIndex = line.indexOf(tocMarker);
            int tEndIndex = 0;
            if (tMarkerIndex > 0) {
                tEndIndex = line.indexOf("\t", tMarkerIndex + 1);
                if (tEndIndex == -1) {
                    tEndIndex = line.length();
                }
                tocExists = true;
            }
            int bsEndIndex = line.indexOf("\t");
            String bitstreamName = line.substring(0, bsEndIndex);
            int actionID = -1;
            String groupName = "";
            Group myGroup = null;
            if (permissionsExist) {
                String thisPermission = line.substring(pMarkerIndex + permissionsMarker.length(), pEndIndex);
                int pTypeIndex = thisPermission.indexOf(45);
                int groupIndex = thisPermission.indexOf(39, pTypeIndex);
                int groupEndIndex = thisPermission.indexOf(39, groupIndex + 1);
                if (groupIndex == -1) {
                    groupIndex = thisPermission.indexOf(32, pTypeIndex);
                    groupEndIndex = thisPermission.length();
                }
                groupName = thisPermission.substring(groupIndex + 1, groupEndIndex);
                if (thisPermission.toLowerCase().charAt(pTypeIndex + 1) == 'r') {
                    actionID = 0;
                } else if (thisPermission.toLowerCase().charAt(pTypeIndex + 1) == 'w') {
                    actionID = 1;
                }
                try {
                    myGroup = this.groupService.findByName(c, groupName);
                }
                catch (SQLException sqle) {
                    System.out.println("SQL Exception finding group name: " + groupName);
                }
            }
            String thisDescription = "";
            if (descriptionExists) {
                thisDescription = line.substring(dMarkerIndex + descriptionMarker.length(), dEndIndex).trim();
            }
            String thisLabel = "";
            if (labelExists) {
                thisLabel = line.substring(lMarkerIndex + labelMarker.length(), lEndIndex).trim();
            }
            String thisHeight = "";
            if (heightExists) {
                thisHeight = line.substring(hMarkerIndex + heightMarker.length(), hEndIndex).trim();
            }
            String thisWidth = "";
            if (widthExists) {
                thisWidth = line.substring(wMarkerIndex + widthMarker.length(), wEndIndex).trim();
            }
            String thisToc = "";
            if (tocExists) {
                thisToc = line.substring(tMarkerIndex + tocMarker.length(), tEndIndex).trim();
            }
            Bitstream bs = null;
            boolean notfound = true;
            boolean updateRequired = false;
            if (!this.isTest) {
                List<Bitstream> bitstreams = this.itemService.getNonInternalBitstreams(c, myItem);
                for (int j = 0; j < bitstreams.size() && notfound; ++j) {
                    if (!bitstreams.get(j).getName().equals(bitstreamName)) continue;
                    bs = bitstreams.get(j);
                    notfound = false;
                }
            }
            if (notfound && !this.isTest) {
                System.out.println("\tdefault permissions set for " + bitstreamName);
                continue;
            }
            if (this.isTest) continue;
            if (permissionsExist) {
                if (myGroup == null) {
                    System.out.println("\t" + groupName + " not found, permissions set to default");
                } else if (actionID == -1) {
                    System.out.println("\tinvalid permissions flag, permissions set to default");
                } else {
                    System.out.println("\tSetting special permissions for " + bitstreamName);
                    this.setPermission(c, myGroup, actionID, bs);
                }
            }
            if (descriptionExists) {
                System.out.println("\tSetting description for " + bitstreamName);
                bs.setDescription(c, thisDescription);
                updateRequired = true;
            }
            if (labelExists) {
                metadataField = this.metadataFieldService.findByElement(c, "iiif", "label", null);
                System.out.println("\tSetting label to " + thisLabel + " in element " + metadataField.getElement() + " on " + bitstreamName);
                this.bitstreamService.addMetadata(c, bs, metadataField, null, thisLabel);
                updateRequired = true;
            }
            if (heightExists) {
                metadataField = this.metadataFieldService.findByElement(c, "iiif", "image", "height");
                System.out.println("\tSetting height to " + thisHeight + " in element " + metadataField.getElement() + " on " + bitstreamName);
                this.bitstreamService.addMetadata(c, bs, metadataField, null, thisHeight);
                updateRequired = true;
            }
            if (widthExists) {
                metadataField = this.metadataFieldService.findByElement(c, "iiif", "image", "width");
                System.out.println("\tSetting width to " + thisWidth + " in element " + metadataField.getElement() + " on " + bitstreamName);
                this.bitstreamService.addMetadata(c, bs, metadataField, null, thisWidth);
                updateRequired = true;
            }
            if (tocExists) {
                metadataField = this.metadataFieldService.findByElement(c, "iiif", "toc", null);
                System.out.println("\tSetting toc to " + thisToc + " in element " + metadataField.getElement() + " on " + bitstreamName);
                this.bitstreamService.addMetadata(c, bs, metadataField, null, thisToc);
                updateRequired = true;
            }
            if (!updateRequired) continue;
            this.bitstreamService.update(c, bs);
        }
    }

    protected void setPermission(Context c, Group g, int actionID, Bitstream bs) throws SQLException, AuthorizeException {
        if (!this.isTest) {
            this.authorizeService.removeAllPolicies(c, bs);
            ResourcePolicy rp = (ResourcePolicy)this.resourcePolicyService.create(c);
            rp.setdSpaceObject(bs);
            rp.setAction(actionID);
            rp.setGroup(g);
            this.resourcePolicyService.update(c, rp);
        } else if (actionID == 0) {
            System.out.println("\t\tpermissions: READ for " + g.getName());
        } else if (actionID == 1) {
            System.out.println("\t\tpermissions: WRITE for " + g.getName());
        }
    }

    private String getAttributeValue(Node n, String name) {
        NamedNodeMap nm = n.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            Node node = nm.item(i);
            if (!name.equals(node.getNodeName())) continue;
            return node.getNodeValue();
        }
        return "";
    }

    protected String getStringValue(Node node) {
        Node first;
        String value = node.getNodeValue();
        if (node.hasChildNodes() && (first = node.getFirstChild()).getNodeType() == 3) {
            return first.getNodeValue();
        }
        return value;
    }

    protected Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(new File(filename));
    }

    protected boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                if (files[i].delete()) continue;
                this.log.error("Unable to delete file: " + files[i].getName());
            }
        }
        boolean pathDeleted = path.delete();
        return pathDeleted;
    }

    @Override
    public String unzip(File zipfile) throws IOException {
        return this.unzip(zipfile, null);
    }

    @Override
    public String unzip(File zipfile, String destDir) throws IOException {
        File tempdir;
        String destinationDir;
        if (!zipfile.canRead()) {
            this.log.error("Zip file '" + zipfile.getAbsolutePath() + "' does not exist, or is not readable.");
        }
        if ((destinationDir = destDir) == null) {
            destinationDir = this.tempWorkDir;
        }
        if (!(tempdir = new File(destinationDir)).isDirectory()) {
            this.log.error("'" + this.configurationService.getProperty("org.dspace.app.itemexport.work.dir") + "' as defined by the key 'org.dspace.app.itemexport.work.dir' in dspace.cfg is not a valid directory");
        }
        if (!tempdir.exists() && !tempdir.mkdirs()) {
            this.log.error("Unable to create temporary directory: " + tempdir.getAbsolutePath());
        }
        String sourcedir = destinationDir + System.getProperty("file.separator") + zipfile.getName();
        String zipDir = destinationDir + System.getProperty("file.separator") + zipfile.getName() + System.getProperty("file.separator");
        String sourceDirForZip = sourcedir;
        ZipFile zf = new ZipFile(zipfile);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                if (new File(zipDir + entry.getName()).mkdirs()) continue;
                this.log.error("Unable to create contents directory: " + zipDir + entry.getName());
                continue;
            }
            String entryName = entry.getName();
            File outFile = new File(zipDir + entryName);
            if (!outFile.toPath().normalize().startsWith(zipDir)) {
                throw new IOException("Bad zip entry: '" + entryName + "' in file '" + zipfile.getAbsolutePath() + "'! Cannot process this file.");
            }
            System.out.println("Extracting file: " + entryName);
            this.log.info("Extracting file: " + entryName);
            int index = entryName.lastIndexOf(47);
            if (index == -1) {
                index = entryName.lastIndexOf(92);
            }
            if (index > 0) {
                String[] entryChunks;
                File dir = new File(zipDir + entryName.substring(0, index));
                if (!dir.exists() && !dir.mkdirs()) {
                    this.log.error("Unable to create directory: " + dir.getAbsolutePath());
                }
                if ((entryChunks = entryName.split("/|\\\\")).length > 2 && StringUtils.equals((CharSequence)sourceDirForZip, (CharSequence)sourcedir)) {
                    sourceDirForZip = sourcedir + "/" + entryChunks[0];
                }
            }
            byte[] buffer = new byte[1024];
            InputStream in = zf.getInputStream(entry);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            in.close();
            out.close();
        }
        zf.close();
        if (!StringUtils.equals((CharSequence)sourceDirForZip, (CharSequence)sourcedir)) {
            sourcedir = sourceDirForZip;
            System.out.println("Set sourceDir using path inside of Zip: " + sourcedir);
            this.log.info("Set sourceDir using path inside of Zip: " + sourcedir);
        }
        return sourcedir;
    }

    @Override
    public String unzip(String sourcedir, String zipfilename) throws IOException {
        File zipfile = new File(sourcedir + File.separator + zipfilename);
        return this.unzip(zipfile);
    }

    protected String generateRandomFilename(boolean hidden) {
        Object filename = String.format("%s", RandomStringUtils.randomAlphanumeric((int)8));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
        String datePart = sdf.format(new Date());
        filename = datePart + "_" + (String)filename;
        return filename;
    }

    @Override
    public void processUIImport(String filepath, Collection owningCollection, String[] otherCollections, String resumeDir, String inputType, Context context, final boolean template) throws Exception {
        final EPerson oldEPerson = context.getCurrentUser();
        final String[] theOtherCollections = otherCollections;
        final Collection theOwningCollection = owningCollection;
        final String theFilePath = filepath;
        final String theInputType = inputType;
        final String theResumeDir = resumeDir;
        boolean useTemplateItem = template;
        Thread go = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Context context = null;
                String importDir = null;
                EPerson eperson = null;
                try {
                    boolean success;
                    File importDirFile;
                    context = new Context();
                    eperson = (EPerson)ItemImportServiceImpl.this.ePersonService.find(context, oldEPerson.getID());
                    context.setCurrentUser(eperson);
                    context.turnOffAuthorisationSystem();
                    boolean isResume = theResumeDir != null;
                    ArrayList<Collection> collectionList = new ArrayList<Collection>();
                    if (theOtherCollections != null) {
                        for (String colID : theOtherCollections) {
                            Collection col;
                            UUID colId = UUID.fromString(colID);
                            if (theOwningCollection.getID().equals(colId) || (col = (Collection)ItemImportServiceImpl.this.collectionService.find(context, colId)) == null) continue;
                            collectionList.add(col);
                        }
                    }
                    if (!(importDirFile = new File(importDir = ItemImportServiceImpl.this.configurationService.getProperty("org.dspace.app.batchitemimport.work.dir") + File.separator + "batchuploads" + File.separator + context.getCurrentUser().getID() + File.separator + (Serializable)(isResume ? theResumeDir : Long.valueOf(new GregorianCalendar().getTimeInMillis())))).exists() && !(success = importDirFile.mkdirs())) {
                        ItemImportServiceImpl.this.log.info("Cannot create batch import directory!");
                        throw new Exception("Cannot create batch import directory!");
                    }
                    String dataPath = null;
                    String dataDir = null;
                    if (theInputType.equals("saf")) {
                        dataPath = importDirFile + File.separator + "data.zip";
                        dataDir = importDirFile + File.separator + "data_unzipped2" + File.separator;
                    } else if (theInputType.equals("safupload")) {
                        FileUtils.copyFileToDirectory((File)new File(theFilePath), (File)importDirFile);
                        dataPath = importDirFile + File.separator + new File(theFilePath).getName();
                        dataDir = importDirFile + File.separator + "data_unzipped2" + File.separator;
                    } else {
                        dataPath = importDirFile + File.separator + new File(theFilePath).getName();
                        dataDir = importDirFile + File.separator + "data" + File.separator;
                    }
                    if (isResume) {
                        if (!theInputType.equals("safupload")) {
                            new File(dataPath).delete();
                        }
                        new File(importDirFile + File.separator + "error.txt").delete();
                        FileDeleteStrategy.FORCE.delete(new File(dataDir));
                        FileDeleteStrategy.FORCE.delete(new File(importDirFile + File.separator + "data_unzipped" + File.separator));
                    }
                    String sourcePath = null;
                    if (theInputType.equals("saf")) {
                        int length;
                        FileOutputStream os = new FileOutputStream(dataPath);
                        byte[] b = new byte[2048];
                        InputStream is = new URL(theFilePath).openStream();
                        while ((length = is.read(b)) != -1) {
                            ((OutputStream)os).write(b, 0, length);
                        }
                        is.close();
                        ((OutputStream)os).close();
                        sourcePath = ItemImportServiceImpl.this.unzip(new File(dataPath), dataDir);
                        FileUtils.moveDirectory((File)new File(sourcePath), (File)new File(importDirFile + File.separator + "data_unzipped" + File.separator));
                        FileDeleteStrategy.FORCE.delete(new File(dataDir));
                        dataDir = importDirFile + File.separator + "data_unzipped" + File.separator;
                    } else if (theInputType.equals("safupload")) {
                        sourcePath = ItemImportServiceImpl.this.unzip(new File(dataPath), dataDir);
                        FileUtils.moveDirectory((File)new File(sourcePath), (File)new File(importDirFile + File.separator + "data_unzipped" + File.separator));
                        FileDeleteStrategy.FORCE.delete(new File(dataDir));
                        dataDir = importDirFile + File.separator + "data_unzipped" + File.separator;
                    }
                    String mapFilePath = importDirFile + File.separator + "mapfile";
                    ArrayList<Collection> finalCollections = null;
                    if (theOwningCollection != null) {
                        finalCollections = new ArrayList<Collection>();
                        finalCollections.add(theOwningCollection);
                        finalCollections.addAll(collectionList);
                    }
                    ItemImportServiceImpl.this.setResume(isResume);
                    if (theInputType.equals("saf") || theInputType.equals("safupload")) {
                        ItemImportServiceImpl.this.addItems(context, finalCollections, dataDir, mapFilePath, template);
                    }
                    ItemImportServiceImpl.this.emailSuccessMessage(context, eperson, mapFilePath);
                    context.complete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String exceptionString = ExceptionUtils.getStackTrace((Throwable)e);
                    try {
                        File importDirFile = new File(importDir + File.separator + "error.txt");
                        PrintWriter errorWriter = new PrintWriter(importDirFile);
                        errorWriter.print(exceptionString);
                        errorWriter.close();
                        ItemImportServiceImpl.this.emailErrorMessage(eperson, exceptionString);
                        throw new Exception(e.getMessage());
                    }
                    catch (Exception exception) {
                    }
                }
                finally {
                    try {
                        context.complete();
                    }
                    catch (SQLException sqle) {
                        context.abort();
                    }
                }
            }
        };
        go.isDaemon();
        go.start();
    }

    @Override
    public void emailSuccessMessage(Context context, EPerson eperson, String fileName) throws MessagingException {
        try {
            Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "bte_batch_import_success"));
            email.addRecipient(eperson.getEmail());
            email.addArgument(fileName);
            email.send();
        }
        catch (Exception e) {
            this.log.warn(LogHelper.getHeader(context, "emailSuccessMessage", "cannot notify user of import"), (Throwable)e);
        }
    }

    @Override
    public void emailErrorMessage(EPerson eperson, String error) throws MessagingException {
        this.log.warn("An error occurred during item import, the user will be notified. " + error);
        try {
            Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "bte_batch_import_error"));
            email.addRecipient(eperson.getEmail());
            email.addArgument(error);
            email.addArgument(this.configurationService.getProperty("dspace.ui.url") + "/feedback");
            email.send();
        }
        catch (Exception e) {
            this.log.warn("error during item import error notification", (Throwable)e);
        }
    }

    @Override
    public List<BatchUpload> getImportsAvailable(EPerson eperson) throws Exception {
        File uploadDir = new File(this.getImportUploadableDirectory(eperson));
        if (!uploadDir.exists() || !uploadDir.isDirectory()) {
            return null;
        }
        TreeMap<String, BatchUpload> fileNames = new TreeMap<String, BatchUpload>();
        for (String fileName : uploadDir.list()) {
            File file = new File(uploadDir + File.separator + fileName);
            if (!file.isDirectory()) continue;
            BatchUpload upload = new BatchUpload(file);
            fileNames.put(upload.getDir().getName(), upload);
        }
        if (fileNames.size() > 0) {
            return new ArrayList<BatchUpload>(fileNames.values());
        }
        return null;
    }

    @Override
    public String getImportUploadableDirectory(EPerson ePerson) throws Exception {
        String uploadDir = this.configurationService.getProperty("org.dspace.app.batchitemimport.work.dir");
        if (uploadDir == null) {
            throw new Exception("A dspace.cfg entry for 'org.dspace.app.batchitemimport.work.dir' does not exist.");
        }
        String uploadDirBasePath = uploadDir + File.separator + "batchuploads" + File.separator;
        File uploadDirectory = new File(uploadDirBasePath + ePerson.getLegacyId());
        if (!uploadDirectory.exists()) {
            uploadDirectory = new File(uploadDirBasePath + ePerson.getID());
        }
        return uploadDirectory.getAbsolutePath();
    }

    @Override
    public void deleteBatchUpload(Context c, String uploadId) throws Exception {
        String uploadDir = null;
        String mapFilePath = null;
        uploadDir = this.getImportUploadableDirectory(c.getCurrentUser()) + File.separator + uploadId;
        mapFilePath = uploadDir + File.separator + "mapfile";
        this.deleteItems(c, mapFilePath);
        FileDeleteStrategy.FORCE.delete(new File(uploadDir));
    }

    @Override
    public String getTempWorkDir() {
        return this.tempWorkDir;
    }

    @Override
    public File getTempWorkDirFile() throws IOException {
        File tempDirFile = new File(this.getTempWorkDir());
        if (!tempDirFile.exists()) {
            boolean success = tempDirFile.mkdirs();
            if (!success) {
                throw new IOException("Work directory " + tempDirFile.getAbsolutePath() + " could not be created.");
            }
            this.log.debug("Created directory " + tempDirFile.getAbsolutePath());
        } else {
            this.log.debug("Work directory exists:  " + tempDirFile.getAbsolutePath());
        }
        return tempDirFile;
    }

    @Override
    public void cleanupZipTemp() {
        System.out.println("Deleting temporary zip directory: " + this.tempWorkDir);
        this.log.debug("Deleting temporary zip directory: " + this.tempWorkDir);
        this.deleteDirectory(new File(this.tempWorkDir));
    }

    @Override
    public void setTest(boolean isTest) {
        this.isTest = isTest;
    }

    @Override
    public void setResume(boolean isResume) {
        this.isResume = isResume;
    }

    @Override
    public void setUseWorkflow(boolean useWorkflow) {
        this.useWorkflow = useWorkflow;
    }

    @Override
    public void setUseWorkflowSendEmail(boolean useWorkflowSendEmail) {
        this.useWorkflowSendEmail = useWorkflowSendEmail;
    }

    @Override
    public void setQuiet(boolean isQuiet) {
        this.isQuiet = isQuiet;
    }
}

