/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.OrcidAuthenticationBean;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.kernel.ServiceManager;
import org.dspace.utils.DSpace;

public class OrcidAuthentication
implements AuthenticationMethod {
    private final ServiceManager serviceManager = new DSpace().getServiceManager();

    public static boolean isEnabled() {
        String pluginName = new OrcidAuthentication().getName();
        Iterator<AuthenticationMethod> authenticationMethodIterator = AuthenticateServiceFactory.getInstance().getAuthenticationService().authenticationMethodIterator();
        while (authenticationMethodIterator.hasNext()) {
            if (!pluginName.equals(authenticationMethodIterator.next().getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return this.getOrcidAuthentication().canSelfRegister(context, request, username);
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        this.getOrcidAuthentication().initEPerson(context, request, eperson);
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return this.getOrcidAuthentication().allowSetPassword(context, request, username);
    }

    @Override
    public boolean isImplicit() {
        return this.getOrcidAuthentication().isImplicit();
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        return this.getOrcidAuthentication().getSpecialGroups(context, request);
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        return this.getOrcidAuthentication().authenticate(context, username, password, realm, request);
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return this.getOrcidAuthentication().loginPageURL(context, request, response);
    }

    @Override
    public String getName() {
        return this.getOrcidAuthentication().getName();
    }

    private OrcidAuthenticationBean getOrcidAuthentication() {
        return (OrcidAuthenticationBean)this.serviceManager.getServiceByName("orcidAuthentication", OrcidAuthenticationBean.class);
    }

    @Override
    public boolean isUsed(Context context, HttpServletRequest request) {
        return this.getOrcidAuthentication().isUsed(context, request);
    }
}

