/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.comparator.NameAscendingComparator;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="collection")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, include="non-lazy")
public class Collection
extends DSpaceObject
implements DSpaceObjectLegacySupport {
    @Column(name="collection_id", insertable=false, updatable=false)
    private Integer legacyId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="logo_bitstream_id")
    private Bitstream logo;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="template_item_id")
    private Item template;
    @OneToOne
    @JoinColumn(name="submitter")
    private Group submitters;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="admin")
    private Group admins;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinTable(name="community2collection", joinColumns={@JoinColumn(name="collection_id")}, inverseJoinColumns={@JoinColumn(name="community_id")})
    private final Set<Community> communities = new HashSet<Community>();
    @Transient
    private transient CollectionService collectionService;

    protected Collection() {
    }

    protected Collection(UUID uuid) {
        this.predefinedUUID = uuid;
    }

    @Override
    public String getName() {
        String value = this.getCollectionService().getMetadataFirstValue(this, MetadataSchemaEnum.DC.getName(), "title", null, "*");
        return value == null ? "" : value;
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    protected void setLogo(Bitstream logo) {
        this.logo = logo;
        this.setModified();
    }

    public Group getSubmitters() {
        return this.submitters;
    }

    void setSubmitters(Group submitters) {
        this.submitters = submitters;
        this.setModified();
    }

    public Group getAdministrators() {
        return this.admins;
    }

    void setAdmins(Group admins) {
        this.admins = admins;
        this.setModified();
    }

    public Group getWorkflowStep1(Context context) {
        return this.getCollectionService().getWorkflowGroup(context, this, 1);
    }

    public Group getWorkflowStep2(Context context) {
        return this.getCollectionService().getWorkflowGroup(context, this, 2);
    }

    public Group getWorkflowStep3(Context context) {
        return this.getCollectionService().getWorkflowGroup(context, this, 3);
    }

    @Nonnull
    public String getLicenseCollection() {
        String license = this.getCollectionService().getMetadataFirstValue(this, CollectionService.MD_LICENSE, "*");
        if (null == license) {
            return "";
        }
        return license;
    }

    public void setLicense(Context context, String license) throws SQLException {
        this.getCollectionService().setMetadataSingleValue(context, this, DSpaceObjectService.MD_LICENSE, "*", license);
    }

    public Item getTemplateItem() throws SQLException {
        return this.template;
    }

    void setTemplateItem(Item template) {
        this.template = template;
        this.setModified();
    }

    public List<Community> getCommunities() throws SQLException {
        Community[] output = this.communities.toArray(new Community[0]);
        Arrays.sort(output, new NameAscendingComparator());
        return Arrays.asList(output);
    }

    void addCommunity(Community community) {
        this.communities.add(community);
        this.setModified();
    }

    void removeCommunity(Community community) {
        this.communities.remove(community);
        this.setModified();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)other);
        if (this.getClass() != objClass) {
            return false;
        }
        Collection otherCollection = (Collection)other;
        return this.getID().equals(otherCollection.getID());
    }

    public int hashCode() {
        int hash = 5;
        hash += 71 * hash + this.getType();
        hash += 71 * hash + this.getID().hashCode();
        return hash;
    }

    @Override
    public int getType() {
        return 3;
    }

    public void setWorkflowGroup(Context context, int step, Group g) throws SQLException, AuthorizeException {
        this.getCollectionService().setWorkflowGroup(context, this, step, g);
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    private CollectionService getCollectionService() {
        if (this.collectionService == null) {
            this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
        }
        return this.collectionService;
    }
}

