/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataService;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.dao.pojo.ItemUuidAndRelationshipId;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.virtual.VirtualMetadataConfiguration;
import org.dspace.content.virtual.VirtualMetadataPopulator;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class RelationshipMetadataServiceImpl
implements RelationshipMetadataService {
    private static final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected RelationshipService relationshipService;
    @Autowired(required=true)
    protected RelationshipTypeService relationshipTypeService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected VirtualMetadataPopulator virtualMetadataPopulator;
    @Autowired(required=true)
    protected MetadataFieldService metadataFieldService;

    @Override
    public List<RelationshipMetadataValue> getRelationshipMetadata(Item item, boolean enableVirtualMetadata) {
        Context context = new Context();
        LinkedList<RelationshipMetadataValue> fullMetadataValueList = new LinkedList<RelationshipMetadataValue>();
        try {
            EntityType entityType = this.itemService.getEntityType(context, item);
            if (entityType != null) {
                fullMetadataValueList.addAll(this.findLatestForDiscoveryMetadataValues(context, item, entityType));
                List<Relationship> relationships = this.relationshipService.findByItem(context, item, -1, -1, true);
                for (Relationship relationship : relationships) {
                    fullMetadataValueList.addAll(this.findRelationshipMetadataValueForItemRelationship(context, item, entityType.getLabel(), relationship, enableVirtualMetadata));
                }
            }
        }
        catch (SQLException e) {
            log.error("Lookup for Relationships for item with uuid: " + item.getID() + " caused DSpace to crash", (Throwable)e);
        }
        return fullMetadataValueList;
    }

    protected List<RelationshipMetadataValue> findLatestForDiscoveryMetadataValues(Context context, Item item, EntityType itemEntityType) throws SQLException {
        String schema = MetadataSchemaEnum.RELATION.getName();
        String qualifier = "latestForDiscovery";
        LinkedList<RelationshipMetadataValue> mdvs = new LinkedList<RelationshipMetadataValue>();
        List<RelationshipType> relationshipTypes = this.relationshipTypeService.findByEntityType(context, itemEntityType);
        for (RelationshipType relationshipType : relationshipTypes) {
            List<ItemUuidAndRelationshipId> data;
            String element;
            if (relationshipType.getTilted() != RelationshipType.Tilted.RIGHT && relationshipType.getLeftType().equals(itemEntityType)) {
                element = relationshipType.getLeftwardType();
                data = this.relationshipService.findByLatestItemAndRelationshipType(context, item, relationshipType, true);
                mdvs.addAll(this.constructLatestForDiscoveryMetadataValues(context, schema, element, "latestForDiscovery", data));
            }
            if (relationshipType.getTilted() == RelationshipType.Tilted.LEFT || !relationshipType.getRightType().equals(itemEntityType)) continue;
            element = relationshipType.getRightwardType();
            data = this.relationshipService.findByLatestItemAndRelationshipType(context, item, relationshipType, false);
            mdvs.addAll(this.constructLatestForDiscoveryMetadataValues(context, schema, element, "latestForDiscovery", data));
        }
        return mdvs;
    }

    protected List<RelationshipMetadataValue> constructLatestForDiscoveryMetadataValues(Context context, String schema, String element, String qualifier, List<ItemUuidAndRelationshipId> data) {
        String mdf = new MetadataFieldName(schema, element, qualifier).toString();
        return data.stream().map(datum -> {
            RelationshipMetadataValue mdv = this.constructMetadataValue(context, mdf);
            if (mdv == null) {
                return null;
            }
            mdv.setAuthority("virtual::" + datum.getRelationshipId());
            mdv.setValue(datum.getItemUuid().toString());
            mdv.setPlace(-1);
            mdv.setUseForPlace(false);
            return mdv;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Deprecated
    public String getEntityTypeStringFromMetadata(Item item) {
        return this.itemService.getEntityTypeLabel(item);
    }

    @Override
    public List<RelationshipMetadataValue> findRelationshipMetadataValueForItemRelationship(Context context, Item item, String entityType, Relationship relationship, boolean enableVirtualMetadata) throws SQLException {
        RelationshipMetadataValue relationMetadataFromOtherItem;
        boolean isLeftwards;
        String relationName;
        Item otherItem;
        HashMap<String, VirtualMetadataConfiguration> hashMaps;
        LinkedList<RelationshipMetadataValue> resultingMetadataValueList = new LinkedList<RelationshipMetadataValue>();
        RelationshipType relationshipType = relationship.getRelationshipType();
        int place = 0;
        if (StringUtils.equals((CharSequence)relationshipType.getLeftType().getLabel(), (CharSequence)entityType) && item.getID().equals(relationship.getLeftItem().getID())) {
            hashMaps = this.virtualMetadataPopulator.getMap().get(relationshipType.getLeftwardType());
            otherItem = relationship.getRightItem();
            relationName = relationship.getRelationshipType().getLeftwardType();
            place = relationship.getLeftPlace();
            isLeftwards = false;
        } else if (StringUtils.equals((CharSequence)relationshipType.getRightType().getLabel(), (CharSequence)entityType) && item.getID().equals(relationship.getRightItem().getID())) {
            hashMaps = this.virtualMetadataPopulator.getMap().get(relationshipType.getRightwardType());
            otherItem = relationship.getLeftItem();
            relationName = relationship.getRelationshipType().getRightwardType();
            place = relationship.getRightPlace();
            isLeftwards = true;
        } else {
            return resultingMetadataValueList;
        }
        if (hashMaps != null && enableVirtualMetadata) {
            resultingMetadataValueList.addAll(this.findVirtualMetadataFromConfiguration(context, item, hashMaps, otherItem, relationName, relationship, place, isLeftwards));
        }
        if ((relationMetadataFromOtherItem = this.getRelationMetadataFromOtherItem(context, otherItem, relationName, relationship.getID(), place)) != null) {
            resultingMetadataValueList.add(relationMetadataFromOtherItem);
        }
        return resultingMetadataValueList;
    }

    private List<RelationshipMetadataValue> findVirtualMetadataFromConfiguration(Context context, Item item, HashMap<String, VirtualMetadataConfiguration> hashMaps, Item otherItem, String relationName, Relationship relationship, int place, boolean isLeftwards) throws SQLException {
        LinkedList<RelationshipMetadataValue> resultingMetadataValueList = new LinkedList<RelationshipMetadataValue>();
        for (Map.Entry<String, VirtualMetadataConfiguration> entry : hashMaps.entrySet()) {
            String key = entry.getKey();
            VirtualMetadataConfiguration virtualBean = entry.getValue();
            if (virtualBean.getPopulateWithNameVariant()) {
                String wardLabel;
                String string = wardLabel = isLeftwards ? relationship.getLeftwardValue() : relationship.getRightwardValue();
                if (wardLabel != null) {
                    resultingMetadataValueList.add(this.constructRelationshipMetadataValue(context, item, relationship.getID(), place, key, virtualBean, wardLabel));
                    continue;
                }
                resultingMetadataValueList.addAll(this.findRelationshipMetadataValueFromBean(context, item, otherItem, relationship, place, key, virtualBean));
                continue;
            }
            resultingMetadataValueList.addAll(this.findRelationshipMetadataValueFromBean(context, item, otherItem, relationship, place, key, virtualBean));
        }
        return resultingMetadataValueList;
    }

    private List<RelationshipMetadataValue> findRelationshipMetadataValueFromBean(Context context, Item item, Item otherItem, Relationship relationship, int place, String key, VirtualMetadataConfiguration virtualBean) throws SQLException {
        LinkedList<RelationshipMetadataValue> resultingMetadataValueList = new LinkedList<RelationshipMetadataValue>();
        for (String value : virtualBean.getValues(context, otherItem)) {
            RelationshipMetadataValue relationshipMetadataValue = this.constructRelationshipMetadataValue(context, item, relationship.getID(), place, key, virtualBean, value);
            if (relationshipMetadataValue == null) continue;
            resultingMetadataValueList.add(relationshipMetadataValue);
        }
        return resultingMetadataValueList;
    }

    private RelationshipMetadataValue constructRelationshipMetadataValue(Context context, Item item, Integer relationshipId, int place, String key, VirtualMetadataConfiguration virtualBean, String value) {
        RelationshipMetadataValue metadataValue = this.constructMetadataValue(context, key);
        if (metadataValue != null) {
            metadataValue = this.constructResultingMetadataValue(item, value, metadataValue, relationshipId);
            metadataValue.setUseForPlace(virtualBean.getUseForPlace());
            metadataValue.setPlace(place);
            if (StringUtils.isNotBlank((CharSequence)metadataValue.getValue())) {
                return metadataValue;
            }
        }
        return null;
    }

    private RelationshipMetadataValue constructMetadataValue(Context context, String key) {
        String[] splittedKey = key.split("\\.");
        RelationshipMetadataValue metadataValue = new RelationshipMetadataValue();
        String metadataSchema = splittedKey.length > 0 ? splittedKey[0] : null;
        String metadataElement = splittedKey.length > 1 ? splittedKey[1] : null;
        String metadataQualifier = splittedKey.length > 2 ? splittedKey[2] : null;
        MetadataField metadataField = null;
        try {
            metadataField = this.metadataFieldService.findByElement(context, metadataSchema, metadataElement, metadataQualifier);
        }
        catch (SQLException e) {
            log.error("Could not find element with MetadataSchema: " + metadataSchema + ", MetadataElement: " + metadataElement + " and MetadataQualifier: " + metadataQualifier, (Throwable)e);
            return null;
        }
        if (metadataField == null) {
            log.error("A MetadataValue was attempted to construct with MetadataField for parameters: metadataschema: {}, metadataelement: {}, metadataqualifier: {}", (Object)metadataSchema, (Object)metadataElement, (Object)metadataQualifier);
            return null;
        }
        metadataValue.setMetadataField(metadataField);
        return metadataValue;
    }

    private RelationshipMetadataValue constructResultingMetadataValue(Item item, String value, RelationshipMetadataValue metadataValue, Integer relationshipId) {
        metadataValue.setValue(value);
        metadataValue.setAuthority("virtual::" + relationshipId);
        metadataValue.setConfidence(-1);
        metadataValue.setDSpaceObject(item);
        return metadataValue;
    }

    private RelationshipMetadataValue getRelationMetadataFromOtherItem(Context context, Item otherItem, String relationName, Integer relationshipId, int place) {
        RelationshipMetadataValue metadataValue = this.constructMetadataValue(context, MetadataSchemaEnum.RELATION.getName() + "." + relationName);
        if (metadataValue != null) {
            metadataValue.setAuthority("virtual::" + relationshipId);
            metadataValue.setValue(otherItem.getID().toString());
            metadataValue.setPlace(place);
            return metadataValue;
        }
        return null;
    }
}

