/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Distributive;
import org.dspace.curate.Mutative;
import org.dspace.disseminate.factory.DisseminateServiceFactory;
import org.dspace.disseminate.service.CitationDocumentService;

@Distributive
@Mutative
public class CitationPage
extends AbstractCurationTask {
    private static final Logger log = LogManager.getLogger(CitationPage.class);
    protected int status = -2;
    protected String result = null;
    protected StringBuilder resBuilder;
    protected static final String DISPLAY_BUNDLE_NAME = "DISPLAY";
    protected static final String PRESERVATION_BUNDLE_NAME = "PRESERVATION";
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        this.resBuilder = new StringBuilder();
        this.distribute(dso);
        this.result = this.resBuilder.toString();
        this.setResult(this.result);
        this.report(this.result);
        return this.status;
    }

    @Override
    protected void performItem(Item item) throws SQLException {
        List<Bundle> dBundles = this.itemService.getBundles(item, DISPLAY_BUNDLE_NAME);
        Bundle dBundle = null;
        if (dBundles == null || dBundles.isEmpty()) {
            try {
                dBundle = this.bundleService.create(Curator.curationContext(), item, DISPLAY_BUNDLE_NAME);
            }
            catch (AuthorizeException e) {
                log.error("User not authroized to create bundle on item \"" + item.getName() + "\": " + e.getMessage());
            }
        } else {
            dBundle = dBundles.get(0);
        }
        HashMap<String, Bitstream> displayMap = new HashMap<String, Bitstream>();
        for (Bitstream bs : dBundle.getBitstreams()) {
            displayMap.put(bs.getName(), bs);
        }
        List<Bundle> pBundles = this.itemService.getBundles(item, PRESERVATION_BUNDLE_NAME);
        Bundle pBundle = null;
        List<Object> bundles = new ArrayList<Bundle>();
        if (pBundles != null && pBundles.size() > 0) {
            pBundle = pBundles.get(0);
            bundles.addAll(this.itemService.getBundles(item, "ORIGINAL"));
            bundles.addAll(pBundles);
        } else {
            try {
                pBundle = this.bundleService.create(Curator.curationContext(), item, PRESERVATION_BUNDLE_NAME);
            }
            catch (AuthorizeException e) {
                log.error("User not authroized to create bundle on item \"" + item.getName() + "\": " + e.getMessage());
            }
            bundles = this.itemService.getBundles(item, "ORIGINAL");
        }
        for (Bundle bundle : bundles) {
            List<Bitstream> bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                CitationDocumentService citationDocument = DisseminateServiceFactory.getInstance().getCitationDocumentService();
                if (citationDocument.canGenerateCitationVersion(Curator.curationContext(), bitstream)) {
                    this.resBuilder.append(item.getHandle()).append(" - ").append(bitstream.getName()).append(" is citable.");
                    try {
                        ByteArrayInputStream citedInputStream = new ByteArrayInputStream((byte[])citationDocument.makeCitedDocument(Curator.curationContext(), bitstream).getLeft());
                        this.addCitedPageToItem(citedInputStream, bundle, pBundle, dBundle, displayMap, item, bitstream);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        StackTraceElement[] stackTrace = e.getStackTrace();
                        StringBuilder stack = new StringBuilder();
                        int numLines = Math.min(stackTrace.length, 12);
                        for (int j = 0; j < numLines; ++j) {
                            stack.append("\t").append(stackTrace[j].toString()).append("\n");
                        }
                        if (stackTrace.length > numLines) {
                            stack.append("\t. . .\n");
                        }
                        log.error(e.toString() + " -> \n" + stack.toString());
                        this.resBuilder.append(", but there was an error generating the PDF.\n");
                        this.status = -1;
                    }
                    continue;
                }
                this.resBuilder.append(item.getHandle()).append(" - ").append(bitstream.getName()).append(" is not citable.\n");
                this.status = 0;
            }
        }
    }

    protected void addCitedPageToItem(InputStream citedDoc, Bundle bundle, Bundle pBundle, Bundle dBundle, Map<String, Bitstream> displayMap, Item item, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        Context context = Curator.curationContext();
        if (!bundle.getID().equals(pBundle.getID())) {
            this.bundleService.addBitstream(context, pBundle, bitstream);
            this.bundleService.removeBitstream(context, bundle, bitstream);
            List<Bitstream> bitstreams = bundle.getBitstreams();
            if (bitstreams == null || bitstreams.isEmpty()) {
                this.itemService.removeBundle(context, item, bundle);
            }
        }
        if (displayMap.containsKey(bitstream.getName())) {
            this.bundleService.removeBitstream(context, dBundle, displayMap.get(bitstream.getName()));
        }
        Bitstream citedBitstream = this.bitstreamService.create(context, dBundle, citedDoc);
        citedDoc.close();
        citedBitstream.setName(context, bitstream.getName());
        this.bitstreamService.setFormat(context, citedBitstream, bitstream.getFormat(Curator.curationContext()));
        citedBitstream.setDescription(context, bitstream.getDescription());
        this.resBuilder.append(" Added ").append(citedBitstream.getName()).append(" to the ").append(DISPLAY_BUNDLE_NAME).append(" bundle.\n");
        this.itemService.update(context, item);
        this.status = 0;
    }
}

