/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import ORG.oclc.oai.harvester2.verb.GetRecord;
import ORG.oclc.oai.harvester2.verb.Identify;
import ORG.oclc.oai.harvester2.verb.ListMetadataFormats;
import ORG.oclc.oai.harvester2.verb.ListRecords;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.Utils;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.harvest.HarvestScheduler;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.HarvestedItem;
import org.dspace.harvest.HarvestingException;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.dspace.harvest.service.HarvestedItemService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.DOMBuilder;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.SAXException;

public class OAIHarvester {
    private static Logger log = LogManager.getLogger(OAIHarvester.class);
    private static final Namespace ATOM_NS = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
    private static final Namespace ORE_NS = Namespace.getNamespace((String)"http://www.openarchives.org/ore/terms/");
    private static final Namespace OAI_NS = Namespace.getNamespace((String)"http://www.openarchives.org/OAI/2.0/");
    public static final String OAI_ADDRESS_ERROR = "invalidAddress";
    public static final String OAI_SET_ERROR = "noSuchSet";
    public static final String OAI_DMD_ERROR = "metadataNotSupported";
    public static final String OAI_ORE_ERROR = "oreNotSupported";
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected HarvestedCollectionService harvestedCollectionService;
    protected InstallItemService installItemService;
    protected ItemService itemService;
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected HarvestedItemService harvestedItemService;
    protected WorkspaceItemService workspaceItemService;
    protected PluginService pluginService;
    protected ConfigurationService configurationService;
    Collection targetCollection;
    HarvestedCollection harvestRow;
    Context ourContext;
    private Namespace ORESerialNS;
    private String ORESerialKey;
    private Namespace metadataNS;
    private String metadataKey;
    private static DOMBuilder db = new DOMBuilder();

    public OAIHarvester(Context c, DSpaceObject dso, HarvestedCollection hc) throws HarvestingException, SQLException {
        this.harvestedCollectionService = HarvestServiceFactory.getInstance().getHarvestedCollectionService();
        this.harvestedItemService = HarvestServiceFactory.getInstance().getHarvestedItemService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.installItemService = ContentServiceFactory.getInstance().getInstallItemService();
        this.workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
        this.pluginService = CoreServiceFactory.getInstance().getPluginService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        if (dso.getType() != 3) {
            throw new HarvestingException("OAIHarvester can only harvest collections");
        }
        this.ourContext = c;
        this.targetCollection = (Collection)dso;
        this.harvestRow = hc;
        if (this.harvestRow == null || !this.harvestedCollectionService.isHarvestable(this.harvestRow)) {
            throw new HarvestingException("Provided collection is not set up for harvesting");
        }
        Namespace ORESerializationNamespace = OAIHarvester.getORENamespace();
        this.ORESerialNS = Namespace.getNamespace((String)ORESerializationNamespace.getURI());
        this.ORESerialKey = ORESerializationNamespace.getPrefix();
        this.metadataKey = this.harvestRow.getHarvestMetadataConfig();
        this.metadataNS = OAIHarvester.getDMDNamespace(this.metadataKey);
        if (this.metadataNS == null) {
            log.error("No matching metadata namespace found for \"" + this.metadataKey + "\", see oai.cfg option \"oai.harvester.metadataformats.{MetadataKey} = {MetadataNS},{Display Name}\"");
            throw new HarvestingException("Metadata declaration not found");
        }
    }

    public static Namespace getORENamespace() {
        String ORESerializationString = null;
        String ORESeialKey = null;
        String oreString = "oai.harvester.oreSerializationFormat";
        List keys = DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyKeys(oreString);
        Iterator iterator = keys.iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            ORESeialKey = key.substring(oreString.length() + 1);
            ORESerializationString = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty(key);
            return Namespace.getNamespace((String)ORESeialKey, (String)ORESerializationString);
        }
        return Namespace.getNamespace((String)"ore", (String)ATOM_NS.getURI());
    }

    public static Namespace getDMDNamespace(String metadataKey) {
        String metadataString = null;
        String metaString = "oai.harvester.metadataformats";
        List keys = DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyKeys(metaString);
        for (String key : keys) {
            if (!key.substring(metaString.length() + 1).equals(metadataKey)) continue;
            metadataString = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty(key);
            String namespacePiece = metadataString.indexOf(44) != -1 ? metadataString.substring(0, metadataString.indexOf(44)) : metadataString;
            return Namespace.getNamespace((String)namespacePiece);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHarvest() throws SQLException, IOException, AuthorizeException {
        Context.Mode originalMode = this.ourContext.getCurrentMode();
        this.ourContext.setMode(Context.Mode.BATCH_EDIT);
        String oaiSource = this.harvestRow.getOaiSource();
        String oaiSetId = this.harvestRow.getOaiSetId();
        if ("all".equals(oaiSetId)) {
            oaiSetId = null;
        }
        Date lastHarvestDate = this.harvestRow.getHarvestDate();
        String fromDate = null;
        if (lastHarvestDate != null) {
            fromDate = this.processDate(this.harvestRow.getHarvestDate());
        }
        long totalListSize = 0L;
        long currentRecord = 0L;
        Date startTime = new Date();
        String toDate = this.processDate(startTime, 0);
        try {
            String OREPrefix;
            String descMDPrefix = null;
            try {
                String dateGranularity = this.oaiGetDateGranularity(oaiSource);
                if (fromDate != null) {
                    fromDate = fromDate.substring(0, dateGranularity.length());
                }
                toDate = toDate.substring(0, dateGranularity.length());
                descMDPrefix = OAIHarvester.oaiResolveNamespaceToPrefix(oaiSource, this.metadataNS.getURI());
                OREPrefix = OAIHarvester.oaiResolveNamespaceToPrefix(oaiSource, this.ORESerialNS.getURI());
            }
            catch (FileNotFoundException fe) {
                log.error("The OAI server did not respond.");
                throw new HarvestingException("The OAI server did not respond.", fe);
            }
            catch (ConnectException fe) {
                log.error("The OAI server did not respond.");
                throw new HarvestingException("The OAI server did not respond.", fe);
            }
            if (descMDPrefix == null) {
                log.error("The OAI server does not support this metadata format");
                throw new HarvestingException("The OAI server does not support this metadata format: " + this.metadataNS.getURI());
            }
            if (OREPrefix == null && this.harvestRow.getHarvestType() != 1) {
                throw new HarvestingException("The OAI server does not support ORE dissemination in the configured serialization format: " + this.ORESerialNS.getURI());
            }
            Document oaiResponse = null;
            Element root = null;
            this.harvestRow.setHarvestStatus(1);
            this.harvestRow.setHarvestMessage("Collection harvesting is initializing...");
            this.harvestRow.setHarvestStartTime(startTime);
            this.harvestedCollectionService.update(this.ourContext, this.harvestRow);
            this.intermediateCommit();
            int expirationInterval = this.configurationService.getIntProperty("oai.harvester.threadTimeout");
            if (expirationInterval == 0) {
                expirationInterval = 24;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            calendar.add(10, expirationInterval);
            Date expirationTime = calendar.getTime();
            HashSet<String> errorSet = new HashSet<String>();
            Object listRecords = new ListRecords(oaiSource, fromDate, toDate, oaiSetId, descMDPrefix);
            log.debug("Harvesting request parameters: listRecords " + oaiSource + " " + fromDate + " " + toDate + " " + oaiSetId + " " + descMDPrefix);
            if (listRecords != null) {
                log.info("HTTP Request: " + listRecords.getRequestURL());
            }
            while (listRecords != null) {
                String resumptionToken;
                String value;
                ArrayList records = new ArrayList();
                oaiResponse = db.build(listRecords.getDocument());
                if (listRecords.getErrors() != null && listRecords.getErrors().getLength() > 0) {
                    for (int i = 0; i < listRecords.getErrors().getLength(); ++i) {
                        String errorCode = listRecords.getErrors().item(i).getAttributes().getNamedItem("code").getTextContent();
                        errorSet.add(errorCode);
                    }
                    if (errorSet.contains("noRecordsMatch")) {
                        log.info("noRecordsMatch: OAI server did not contain any updates");
                        this.harvestRow.setHarvestStartTime(new Date());
                        this.harvestRow.setHarvestMessage("OAI server did not contain any updates");
                        this.harvestRow.setHarvestStatus(0);
                        this.harvestedCollectionService.update(this.ourContext, this.harvestRow);
                        return;
                    }
                    throw new HarvestingException(((Object)errorSet).toString());
                }
                root = oaiResponse.getRootElement();
                records.addAll(root.getChild("ListRecords", OAI_NS).getChildren("record", OAI_NS));
                Element resumptionElement = root.getChild("ListRecords", OAI_NS).getChild("resumptionToken", OAI_NS);
                if (resumptionElement != null && resumptionElement.getAttribute("completeListSize") != null && StringUtils.isNotBlank((CharSequence)(value = resumptionElement.getAttribute("completeListSize").getValue()))) {
                    totalListSize = Long.parseLong(value);
                }
                if (records != null && records.size() > 0) {
                    log.info("Found " + records.size() + " records to process");
                    for (Element record : records) {
                        if (HarvestScheduler.getInterrupt() == 2) {
                            throw new HarvestingException("Harvest process for " + this.targetCollection.getID() + " interrupted by stopping the scheduler.");
                        }
                        if (expirationTime.before(new Date())) {
                            throw new HarvestingException("runHarvest method timed out for collection " + this.targetCollection.getID());
                        }
                        this.processRecord(record, OREPrefix, ++currentRecord, totalListSize);
                        this.ourContext.dispatchEvents();
                        this.intermediateCommit();
                    }
                }
                listRecords = (resumptionToken = listRecords.getResumptionToken()) == null || resumptionToken.length() == 0 ? null : new ListRecords(oaiSource, resumptionToken);
                this.ourContext.turnOffAuthorisationSystem();
                try {
                    this.collectionService.update(this.ourContext, this.targetCollection);
                    this.harvestRow.setHarvestMessage(String.format("Collection is currently being harvested (item %d of %d)", currentRecord, totalListSize));
                    this.harvestedCollectionService.update(this.ourContext, this.harvestRow);
                }
                finally {
                    this.ourContext.restoreAuthSystemState();
                }
                this.ourContext.dispatchEvents();
                this.intermediateCommit();
            }
        }
        catch (HarvestingException hex) {
            log.error("Harvesting error occurred while processing an OAI record: " + hex.getMessage(), (Throwable)hex);
            this.harvestRow.setHarvestMessage("Error occurred while processing an OAI record");
            if (this.harvestRow.getHarvestMessage().contains("Error")) {
                this.alertAdmin(3, hex);
            }
            this.harvestRow.setHarvestStatus(3);
            this.harvestedCollectionService.update(this.ourContext, this.harvestRow);
            this.ourContext.complete();
            return;
        }
        catch (Exception ex) {
            this.harvestRow.setHarvestMessage("Unknown error occurred while generating an OAI response");
            this.harvestRow.setHarvestStatus(-1);
            this.harvestedCollectionService.update(this.ourContext, this.harvestRow);
            this.alertAdmin(-1, ex);
            log.error("Error occurred while generating an OAI response: " + ex.getMessage() + " " + ex.getCause(), (Throwable)ex);
            this.ourContext.complete();
            return;
        }
        finally {
            this.harvestedCollectionService.update(this.ourContext, this.harvestRow);
            this.ourContext.turnOffAuthorisationSystem();
            this.collectionService.update(this.ourContext, this.targetCollection);
            this.ourContext.restoreAuthSystemState();
        }
        Date finishTime = new Date();
        long timeTaken = finishTime.getTime() - startTime.getTime();
        this.harvestRow.setHarvestStartTime(startTime);
        this.harvestRow.setHarvestMessage("Harvest from " + oaiSource + " successful");
        this.harvestRow.setHarvestStatus(0);
        log.info("Harvest from " + oaiSource + " successful. The process took " + timeTaken + " milliseconds. Harvested " + currentRecord + " items.");
        this.harvestedCollectionService.update(this.ourContext, this.harvestRow);
        this.ourContext.setMode(originalMode);
    }

    private void intermediateCommit() throws SQLException {
        this.ourContext.commit();
        this.reloadRequiredEntities();
    }

    private void reloadRequiredEntities() throws SQLException {
        this.targetCollection = this.ourContext.reloadEntity(this.targetCollection);
        this.harvestRow = this.ourContext.reloadEntity(this.harvestRow);
    }

    protected void processRecord(Element record, String OREPrefix, long currentRecord, long totalListSize) throws SQLException, AuthorizeException, IOException, CrosswalkException, HarvestingException, ParserConfigurationException, SAXException, TransformerException {
        HarvestedItem hi;
        WorkspaceItem wi = null;
        Date timeStart = new Date();
        String itemOaiID = record.getChild("header", OAI_NS).getChild("identifier", OAI_NS).getText();
        Element header = record.getChild("header", OAI_NS);
        Item item = this.harvestedItemService.getItemByOAIId(this.ourContext, itemOaiID, this.targetCollection);
        if (header.getAttribute("status") != null && header.getAttribute("status").getValue().equals("deleted")) {
            log.info("Item " + itemOaiID + " has been marked as deleted on the OAI server.");
            if (item != null) {
                this.collectionService.removeItem(this.ourContext, this.targetCollection, item);
            }
            this.ourContext.restoreAuthSystemState();
            return;
        }
        List descMD = record.getChild("metadata", OAI_NS).getChildren();
        IngestionCrosswalk MDxwalk = (IngestionCrosswalk)this.pluginService.getNamedPlugin(IngestionCrosswalk.class, this.metadataKey);
        IngestionCrosswalk ORExwalk = null;
        Element oreREM = null;
        if (this.harvestRow.getHarvestType() > 1) {
            oreREM = this.getMDrecord(this.harvestRow.getOaiSource(), itemOaiID, OREPrefix).get(0);
            ORExwalk = (IngestionCrosswalk)this.pluginService.getNamedPlugin(IngestionCrosswalk.class, this.ORESerialKey);
        }
        this.ourContext.turnOffAuthorisationSystem();
        if (item != null) {
            log.debug("Item " + item.getHandle() + " was found locally. Using it to harvest " + itemOaiID + ".");
            hi = this.harvestedItemService.find(this.ourContext, item);
            Date OAIDatestamp = Utils.parseISO8601Date(header.getChildText("datestamp", OAI_NS));
            Date itemLastHarvest = hi.getHarvestDate();
            if (itemLastHarvest != null && OAIDatestamp.before(itemLastHarvest)) {
                log.info("Item " + item.getHandle() + " was harvested more recently than the last update time reported by the OAI server; skipping.");
                return;
            }
            this.itemService.clearMetadata(this.ourContext, item, "*", "*", "*", "*");
            if (descMD.size() == 1) {
                MDxwalk.ingest(this.ourContext, (DSpaceObject)item, (Element)descMD.get(0), true);
            } else {
                MDxwalk.ingest(this.ourContext, (DSpaceObject)item, descMD, true);
            }
            if (this.harvestRow.getHarvestType() == 3) {
                log.info("Running ORE ingest on: " + item.getHandle());
                List<Bundle> allBundles = item.getBundles();
                for (Bundle bundle : allBundles) {
                    this.itemService.removeBundle(this.ourContext, item, bundle);
                }
                ORExwalk.ingest(this.ourContext, (DSpaceObject)item, oreREM, true);
            }
        } else {
            DSpaceObject dso;
            String handle;
            wi = this.workspaceItemService.create(this.ourContext, this.targetCollection, false);
            item = wi.getItem();
            hi = this.harvestedItemService.create(this.ourContext, item, itemOaiID);
            if (descMD.size() == 1) {
                MDxwalk.ingest(this.ourContext, (DSpaceObject)item, (Element)descMD.get(0), true);
            } else {
                MDxwalk.ingest(this.ourContext, (DSpaceObject)item, descMD, true);
            }
            if (this.harvestRow.getHarvestType() == 3) {
                ORExwalk.ingest(this.ourContext, (DSpaceObject)item, oreREM, true);
            }
            if ((handle = this.extractHandle(item)) != null && (dso = this.handleService.resolveToObject(this.ourContext, handle)) != null) {
                throw new HarvestingException("Handle collision: attempted to re-assign handle '" + handle + "' to an incoming harvested item '" + hi.getOaiID() + "'.");
            }
            try {
                item = this.installItemService.installItem(this.ourContext, wi, handle);
            }
            catch (IOException | SQLException | AuthorizeException se) {
                this.workspaceItemService.deleteWrapper(this.ourContext, wi);
                throw se;
            }
        }
        if (this.harvestRow.getHarvestType() == 2 || this.harvestRow.getHarvestType() == 3) {
            Bundle OREBundle = null;
            List<Bundle> OREBundles = this.itemService.getBundles(item, "ORE");
            Bitstream OREBitstream = null;
            OREBundle = OREBundles.size() > 0 ? OREBundles.get(0) : this.bundleService.create(this.ourContext, item, "ORE");
            XMLOutputter outputter = new XMLOutputter();
            String OREString = outputter.outputString(oreREM);
            ByteArrayInputStream OREStream = new ByteArrayInputStream(OREString.getBytes());
            OREBitstream = this.bundleService.getBitstreamByName(OREBundle, "ORE.xml");
            if (OREBitstream != null) {
                this.bundleService.removeBitstream(this.ourContext, OREBundle, OREBitstream);
            }
            OREBitstream = this.bitstreamService.create(this.ourContext, OREBundle, OREStream);
            OREBitstream.setName(this.ourContext, "ORE.xml");
            BitstreamFormat bf = this.bitstreamFormatService.guessFormat(this.ourContext, OREBitstream);
            this.bitstreamService.setFormat(this.ourContext, OREBitstream, bf);
            this.bitstreamService.update(this.ourContext, OREBitstream);
            this.bundleService.addBitstream(this.ourContext, OREBundle, OREBitstream);
            this.bundleService.update(this.ourContext, OREBundle);
        }
        hi.setHarvestDate(new Date());
        String provenanceMsg = "Item created via OAI harvest from source: " + this.harvestRow.getOaiSource() + " on " + new DCDate(hi.getHarvestDate()) + " (GMT).  Item's OAI Record identifier: " + hi.getOaiID();
        this.itemService.addMetadata(this.ourContext, item, "dc", "description", "provenance", "en", provenanceMsg);
        this.itemService.update(this.ourContext, item);
        this.harvestedItemService.update(this.ourContext, hi);
        long timeTaken = new Date().getTime() - timeStart.getTime();
        log.info(String.format("Item %s (%s) has been ingested (item %d of %d). The whole process took: %d ms.", item.getHandle(), item.getID(), currentRecord, totalListSize, timeTaken));
        this.ourContext.uncacheEntity(wi);
        this.ourContext.uncacheEntity(hi);
        this.ourContext.uncacheEntity(item);
        this.ourContext.restoreAuthSystemState();
    }

    protected String extractHandle(Item item) {
        List<MetadataValue> values;
        String[] rejectedHandlePrefixes;
        String[] acceptedHandleServers = this.configurationService.getArrayProperty("oai.harvester.acceptedHandleServer");
        if (acceptedHandleServers == null) {
            acceptedHandleServers = new String[]{"hdl.handle.net"};
        }
        if ((rejectedHandlePrefixes = this.configurationService.getArrayProperty("oai.harvester.rejectedHandlePrefix")) == null) {
            rejectedHandlePrefixes = new String[]{"123456789"};
        }
        if ((values = this.itemService.getMetadata(item, "dc", "identifier", "*", "*")).size() > 0 && acceptedHandleServers != null) {
            for (MetadataValue value : values) {
                String[] urlPieces = value.getValue().split("/");
                if (urlPieces.length != 5) continue;
                for (String server : acceptedHandleServers) {
                    if (!urlPieces[2].equals(server)) continue;
                    for (String prefix : rejectedHandlePrefixes) {
                        if (urlPieces[3].equals(prefix)) continue;
                        return urlPieces[3] + "/" + urlPieces[4];
                    }
                }
            }
        }
        return null;
    }

    private String processDate(Date date) {
        Integer timePad = this.configurationService.getIntProperty("oai.harvester.timePadding");
        if (timePad == 0) {
            timePad = 120;
        }
        return this.processDate(date, timePad);
    }

    private String processDate(Date date, int secondsPad) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, -1 * secondsPad);
        date = calendar.getTime();
        return formatter.format(date);
    }

    private String oaiGetDateGranularity(String oaiSource) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        Identify iden = new Identify(oaiSource);
        return iden.getDocument().getElementsByTagNameNS(OAI_NS.getURI(), "granularity").item(0).getTextContent();
    }

    public static String oaiResolveNamespaceToPrefix(String oaiSource, String MDNamespace) throws IOException, ParserConfigurationException, SAXException, TransformerException, ConnectException {
        String metaPrefix = null;
        ListMetadataFormats lmf = new ListMetadataFormats(oaiSource);
        if (lmf != null) {
            Document lmfResponse = db.build(lmf.getDocument());
            List mdFormats = lmfResponse.getRootElement().getChild("ListMetadataFormats", OAI_NS).getChildren("metadataFormat", OAI_NS);
            for (Element mdFormat : mdFormats) {
                if (!MDNamespace.equals(mdFormat.getChildText("metadataNamespace", OAI_NS))) continue;
                metaPrefix = mdFormat.getChildText("metadataPrefix", OAI_NS);
                break;
            }
        }
        return metaPrefix;
    }

    protected void alertAdmin(int status, Exception ex) {
        try {
            String recipient = this.configurationService.getProperty("alert.recipient");
            if (StringUtils.isNotBlank((CharSequence)recipient)) {
                String stackTrace;
                Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "harvesting_error"));
                email.addRecipient(recipient);
                email.addArgument(this.targetCollection.getID());
                email.addArgument(new Date());
                email.addArgument(status);
                if (ex != null) {
                    email.addArgument(ex.getMessage());
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn("Unable to send email alert", (Throwable)e);
        }
    }

    protected List<Element> getMDrecord(String oaiSource, String itemOaiId, String metadataPrefix) throws IOException, ParserConfigurationException, SAXException, TransformerException, HarvestingException {
        GetRecord getRecord = new GetRecord(oaiSource, itemOaiId, metadataPrefix);
        HashSet<String> errorSet = new HashSet<String>();
        if (getRecord != null && getRecord.getErrors() != null && getRecord.getErrors().getLength() > 0) {
            for (int i = 0; i < getRecord.getErrors().getLength(); ++i) {
                String errorCode = getRecord.getErrors().item(i).getAttributes().getNamedItem("code").getTextContent();
                errorSet.add(errorCode);
            }
            throw new HarvestingException("OAI server returned the following errors during getDescMD execution: " + ((Object)errorSet).toString());
        }
        Document record = db.build(getRecord.getDocument());
        Element root = record.getRootElement();
        return root.getChild("GetRecord", OAI_NS).getChild("record", OAI_NS).getChild("metadata", OAI_NS).getChildren();
    }

    public List<String> verifyOAIharvester() {
        String oaiSource = this.harvestRow.getOaiSource();
        String oaiSetId = this.harvestRow.getOaiSetId();
        String metaPrefix = this.harvestRow.getHarvestMetadataConfig();
        return this.harvestedCollectionService.verifyOAIharvester(oaiSource, oaiSetId, metaPrefix, true);
    }

    public static List<Map<String, String>> getAvailableMetadataFormats() {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        String metaString = "oai.harvester.metadataformats.";
        Enumeration pe = Collections.enumeration(DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyKeys("oai.harvester.metadataformats"));
        while (pe.hasMoreElements()) {
            Object label;
            String key = (String)pe.nextElement();
            String metadataString = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty(key);
            String id = key.substring(metaString.length());
            String namespace = "";
            if (metadataString.indexOf(44) != -1) {
                label = metadataString.substring(metadataString.indexOf(44) + 2);
                namespace = metadataString.substring(0, metadataString.indexOf(44));
            } else {
                label = id + "(" + metadataString + ")";
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("id", id);
            config.put("label", label);
            config.put("namespace", namespace);
            configs.add(config);
        }
        return configs;
    }
}

