/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.sql.SQLException;
import org.apache.commons.cli.Options;
import org.dspace.administer.ProcessCleaner;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessCleanerConfiguration<T extends ProcessCleaner>
extends ScriptConfiguration<T> {
    @Autowired
    private AuthorizeService authorizeService;
    private Class<T> dspaceRunnableClass;

    @Override
    public boolean isAllowedToExecute(Context context) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException occurred when checking if the current user is an admin", e);
        }
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            Options options = new Options();
            options.addOption("h", "help", false, "help");
            options.addOption("r", "running", false, "delete the process with RUNNING status");
            options.getOption("r").setType(Boolean.TYPE);
            options.addOption("f", "failed", false, "delete the process with FAILED status");
            options.getOption("f").setType(Boolean.TYPE);
            options.addOption("c", "completed", false, "delete the process with COMPLETED status (default if no statuses are specified)");
            options.getOption("c").setType(Boolean.TYPE);
            this.options = options;
        }
        return this.options;
    }

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }
}

