/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.itemimport.ItemImportScriptConfiguration;
import org.dspace.app.itemimport.factory.ItemImportServiceFactory;
import org.dspace.app.itemimport.service.ItemImportService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.utils.DSpace;

public class ItemImport
extends DSpaceRunnable<ItemImportScriptConfiguration> {
    public static String TEMP_DIR = "importSAF";
    public static String MAPFILE_FILENAME = "mapfile";
    public static String MAPFILE_BITSTREAM_TYPE = "importSAFMapfile";
    protected boolean template = false;
    protected String command = null;
    protected String sourcedir = null;
    protected String mapfile = null;
    protected String eperson = null;
    protected String[] collections = null;
    protected boolean isTest = false;
    protected boolean isResume = false;
    protected boolean useWorkflow = false;
    protected boolean useWorkflowSendEmail = false;
    protected boolean isQuiet = false;
    protected boolean commandLineCollections = false;
    protected boolean zip = false;
    protected String zipfilename = null;
    protected boolean help = false;
    protected File workDir = null;
    private File workFile = null;
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final EPersonService epersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    @Override
    public ItemImportScriptConfiguration getScriptConfiguration() {
        return (ItemImportScriptConfiguration)new DSpace().getServiceManager().getServiceByName("import", ItemImportScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.help = this.commandLine.hasOption('h');
        if (this.commandLine.hasOption('a')) {
            this.command = "add";
        }
        if (this.commandLine.hasOption('r')) {
            this.command = "replace";
        }
        if (this.commandLine.hasOption('d')) {
            this.command = "delete";
        }
        if (this.commandLine.hasOption('w')) {
            this.useWorkflow = true;
            if (this.commandLine.hasOption('n')) {
                this.useWorkflowSendEmail = true;
            }
        }
        if (this.commandLine.hasOption('v')) {
            this.isTest = true;
            this.handler.logInfo("**Test Run** - not actually importing items.");
        }
        if (this.commandLine.hasOption('p')) {
            this.template = true;
        }
        if (this.commandLine.hasOption('c')) {
            this.collections = this.commandLine.getOptionValues('c');
            this.commandLineCollections = true;
        } else {
            this.handler.logInfo("No collections given. Assuming 'collections' file inside item directory");
        }
        if (this.commandLine.hasOption('R')) {
            this.isResume = true;
            this.handler.logInfo("**Resume import** - attempting to import items not already imported");
        }
        if (this.commandLine.hasOption('q')) {
            this.isQuiet = true;
        }
        this.setZip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.printHelp();
            return;
        }
        Date startTime = new Date();
        Context context = new Context(Context.Mode.BATCH_EDIT);
        this.setMapFile();
        this.validate(context);
        this.setEPerson(context);
        ArrayList<Collection> mycollections = null;
        if (!"delete".equals(this.command) && this.commandLineCollections) {
            this.handler.logInfo("Destination collections:");
            mycollections = new ArrayList<Collection>();
            for (int i = 0; i < this.collections.length; ++i) {
                Collection collection = null;
                if (this.collections[i] != null) {
                    collection = this.collections[i].indexOf(47) != -1 ? (Collection)handleService.resolveToObject(context, this.collections[i]) : (Collection)collectionService.find(context, UUID.fromString(this.collections[i]));
                }
                if (collection == null || collection.getType() != 3) {
                    throw new IllegalArgumentException("Cannot resolve " + this.collections[i] + " to collection");
                }
                mycollections.add(collection);
                this.handler.logInfo((i == 0 ? "Owning " : "") + "Collection: " + collection.getName());
            }
        }
        ItemImportService itemImportService = ItemImportServiceFactory.getInstance().getItemImportService();
        try {
            itemImportService.setTest(this.isTest);
            itemImportService.setResume(this.isResume);
            itemImportService.setUseWorkflow(this.useWorkflow);
            itemImportService.setUseWorkflowSendEmail(this.useWorkflowSendEmail);
            itemImportService.setQuiet(this.isQuiet);
            itemImportService.setHandler(this.handler);
            try {
                context.turnOffAuthorisationSystem();
                this.readZip(context, itemImportService);
                this.process(context, itemImportService, mycollections);
                context.complete();
            }
            catch (Exception e) {
                context.abort();
                throw new Exception("Error committing changes to database: " + e.getMessage() + ", aborting most recent changes", e);
            }
            if (this.isTest) {
                this.handler.logInfo("***End of Test Run***");
            }
        }
        finally {
            if (this.zip) {
                FileUtils.deleteDirectory((File)new File(this.sourcedir));
                FileUtils.deleteDirectory((File)this.workDir);
            }
            Date endTime = new Date();
            this.handler.logInfo("Started: " + startTime.getTime());
            this.handler.logInfo("Ended: " + endTime.getTime());
            this.handler.logInfo("Elapsed time: " + (endTime.getTime() - startTime.getTime()) / 1000L + " secs (" + (endTime.getTime() - startTime.getTime()) + " msecs)");
        }
    }

    protected void validate(Context context) {
        if (this.command == null) {
            this.handler.logError("Must run with either add, replace, or remove (run with -h flag for details)");
            throw new UnsupportedOperationException("Must run with either add, replace, or remove");
        }
        if (this.isResume && !"add".equals(this.command)) {
            this.handler.logError("Resume option only works with the --add command (run with -h flag for details)");
            throw new UnsupportedOperationException("Resume option only works with the --add command");
        }
        if (this.isResume && StringUtils.isBlank((CharSequence)this.mapfile)) {
            this.handler.logError("The mapfile does not exist. ");
            throw new UnsupportedOperationException("The mapfile does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Context context, ItemImportService itemImportService, List<Collection> collections) throws Exception {
        this.readMapfile(context);
        if ("add".equals(this.command)) {
            itemImportService.addItems(context, collections, this.sourcedir, this.mapfile, this.template);
        } else if ("replace".equals(this.command)) {
            itemImportService.replaceItems(context, collections, this.sourcedir, this.mapfile, this.template);
        } else if ("delete".equals(this.command)) {
            itemImportService.deleteItems(context, this.mapfile);
        }
        File mapFile = new File(this.mapfile);
        try (FileInputStream mapfileInputStream = new FileInputStream(mapFile);){
            this.handler.writeFilestream(context, MAPFILE_FILENAME, mapfileInputStream, MAPFILE_BITSTREAM_TYPE);
        }
        finally {
            mapFile.delete();
            this.workFile.delete();
        }
    }

    protected void readZip(Context context, ItemImportService itemImportService) throws Exception {
        Optional<InputStream> optionalFileStream = this.handler.getFileStream(context, this.zipfilename);
        if (!optionalFileStream.isPresent()) {
            throw new IllegalArgumentException("Error reading file, the file couldn't be found for filename: " + this.zipfilename);
        }
        this.workFile = new File(itemImportService.getTempWorkDir() + File.separator + this.zipfilename + "-" + context.getCurrentUser().getID());
        FileUtils.copyInputStreamToFile((InputStream)optionalFileStream.get(), (File)this.workFile);
        this.workDir = new File(itemImportService.getTempWorkDir() + File.separator + TEMP_DIR);
        this.sourcedir = itemImportService.unzip(this.workFile, this.workDir.getAbsolutePath());
    }

    protected void readMapfile(Context context) {
        if (this.isResume) {
            try {
                Optional<InputStream> optionalFileStream = this.handler.getFileStream(context, this.mapfile);
                if (optionalFileStream.isPresent()) {
                    File tempFile = File.createTempFile(this.mapfile, "temp");
                    tempFile.deleteOnExit();
                    FileUtils.copyInputStreamToFile((InputStream)optionalFileStream.get(), (File)tempFile);
                    this.mapfile = tempFile.getAbsolutePath();
                }
            }
            catch (IOException | AuthorizeException e) {
                throw new UnsupportedOperationException("The mapfile does not exist");
            }
        }
    }

    protected void setMapFile() throws IOException {
        this.mapfile = this.isResume && this.commandLine.hasOption('m') ? this.commandLine.getOptionValue('m') : Files.createTempFile(MAPFILE_FILENAME, "temp", new FileAttribute[0]).toString();
    }

    protected void setZip() {
        this.zip = true;
        this.zipfilename = this.commandLine.getOptionValue('z');
    }

    protected void setEPerson(Context context) throws SQLException {
        EPerson myEPerson = (EPerson)epersonService.find(context, this.getEpersonIdentifier());
        if (myEPerson == null) {
            this.handler.logError("EPerson cannot be found: " + this.getEpersonIdentifier());
            throw new UnsupportedOperationException("EPerson cannot be found: " + this.getEpersonIdentifier());
        }
        context.setCurrentUser(myEPerson);
    }
}

