/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemSubmitterStrategy;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;

public class RequestItemHelpdeskStrategy
extends RequestItemSubmitterStrategy {
    @Autowired(required=true)
    protected EPersonService ePersonService;
    @Autowired(required=true)
    private ConfigurationService configuration;

    @Override
    @NonNull
    public List<RequestItemAuthor> getRequestItemAuthor(Context context, Item item) throws SQLException {
        boolean helpdeskOverridesSubmitter = this.configuration.getBooleanProperty("request.item.helpdesk.override", false);
        String helpDeskEmail = this.configuration.getProperty("mail.helpdesk");
        if (helpdeskOverridesSubmitter && StringUtils.isNotBlank((CharSequence)helpDeskEmail)) {
            ArrayList<RequestItemAuthor> authors = new ArrayList<RequestItemAuthor>(1);
            authors.add(this.getHelpDeskPerson(context, helpDeskEmail));
            return authors;
        }
        return super.getRequestItemAuthor(context, item);
    }

    public RequestItemAuthor getHelpDeskPerson(Context context, String helpDeskEmail) throws SQLException {
        context.turnOffAuthorisationSystem();
        EPerson helpdeskEPerson = this.ePersonService.findByEmail(context, helpDeskEmail);
        context.restoreAuthSystemState();
        if (helpdeskEPerson != null) {
            return new RequestItemAuthor(helpdeskEPerson);
        }
        String helpdeskName = I18nUtil.getMessage("org.dspace.app.requestitem.RequestItemHelpdeskStrategy.helpdeskname", context);
        return new RequestItemAuthor(helpdeskName, helpDeskEmail);
    }
}

