/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCInput {
    private static final Logger log = LoggerFactory.getLogger(DCInput.class);
    private String dcElement = null;
    private String dcQualifier = null;
    private String dcSchema = null;
    private boolean language = false;
    private static final String LanguageName = "common_iso_languages";
    private List<String> valueLanguageList = null;
    private String label = null;
    private String style = null;
    private String inputType = null;
    private boolean required = false;
    private String warning = null;
    private boolean repeatable = false;
    private boolean nameVariants = false;
    private String hint = null;
    private String valueListName = null;
    private List<String> valueList = null;
    private String visibility = null;
    private String readOnly = null;
    private String vocabulary = null;
    private boolean closedVocabulary = false;
    private String regex = null;
    private List<String> typeBind = null;
    private boolean isRelationshipField = false;
    private boolean isMetadataField = false;
    private String relationshipType = null;
    private String searchConfiguration = null;
    private final String filter;
    private final List<String> externalSources;
    public static final String WORKFLOW_SCOPE = "workflow";
    public static final String SUBMISSION_SCOPE = "submit";

    public DCInput(Map<String, String> fieldMap, Map<String, List<String>> listMap) {
        String repStr;
        this.dcElement = fieldMap.get("dc-element");
        this.dcQualifier = fieldMap.get("dc-qualifier");
        this.dcSchema = fieldMap.get("dc-schema");
        if (this.dcSchema == null) {
            this.dcSchema = MetadataSchemaEnum.DC.getName();
        }
        this.language = Boolean.valueOf(fieldMap.get("language"));
        this.valueLanguageList = new ArrayList<String>();
        if (this.language) {
            String languageNameTmp = fieldMap.get("value-pairs-name");
            if (StringUtils.isBlank((CharSequence)languageNameTmp)) {
                languageNameTmp = LanguageName;
            }
            this.valueLanguageList = listMap.get(languageNameTmp);
        }
        this.repeatable = "true".equalsIgnoreCase(repStr = fieldMap.get("repeatable")) || "yes".equalsIgnoreCase(repStr);
        String nameVariantsString = fieldMap.get("name-variants");
        this.nameVariants = StringUtils.isNotBlank((CharSequence)nameVariantsString) ? nameVariantsString.equalsIgnoreCase("true") : false;
        this.label = fieldMap.get("label");
        this.inputType = fieldMap.get("input-type");
        if ("dropdown".equals(this.inputType) || "qualdrop_value".equals(this.inputType) || "list".equals(this.inputType)) {
            this.valueListName = fieldMap.get("value-pairs-name");
            this.valueList = listMap.get(this.valueListName);
        }
        this.hint = fieldMap.get("hint");
        this.warning = fieldMap.get("required");
        this.required = this.warning != null && this.warning.length() > 0;
        this.visibility = fieldMap.get("visibility");
        this.readOnly = fieldMap.get("readonly");
        this.vocabulary = fieldMap.get("vocabulary");
        this.regex = fieldMap.get("regex");
        String closedVocabularyStr = fieldMap.get("closedVocabulary");
        this.closedVocabulary = "true".equalsIgnoreCase(closedVocabularyStr) || "yes".equalsIgnoreCase(closedVocabularyStr);
        this.typeBind = new ArrayList<String>();
        String typeBindDef = fieldMap.get("type-bind");
        if (typeBindDef != null && typeBindDef.trim().length() > 0) {
            String[] types;
            for (String type : types = typeBindDef.split(",")) {
                this.typeBind.add(type.trim());
            }
        }
        this.style = fieldMap.get("style");
        this.isRelationshipField = fieldMap.containsKey("relationship-type");
        this.isMetadataField = fieldMap.containsKey("dc-schema");
        this.relationshipType = fieldMap.get("relationship-type");
        this.searchConfiguration = fieldMap.get("search-configuration");
        this.filter = fieldMap.get("filter");
        this.externalSources = new ArrayList<String>();
        String externalSourcesDef = fieldMap.get("externalsources");
        if (StringUtils.isNotBlank((CharSequence)externalSourcesDef)) {
            String[] sources;
            for (String source : sources = StringUtils.split((String)externalSourcesDef, (String)",")) {
                this.externalSources.add(StringUtils.trim((String)source));
            }
        }
    }

    public boolean isVisible(String scope) {
        return this.visibility == null || this.visibility.equals(scope);
    }

    public boolean isReadOnly(String scope) {
        if (this.isVisible(scope)) {
            return false;
        }
        return this.readOnly != null && this.readOnly.equalsIgnoreCase("readonly");
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean getRepeatable() {
        return this.isRepeatable();
    }

    public boolean areNameVariantsAllowed() {
        return this.nameVariants;
    }

    @Nullable
    public String getInputType() {
        return this.inputType;
    }

    public String getElement() {
        return this.dcElement;
    }

    public String getSchema() {
        return this.dcSchema;
    }

    public String getWarning() {
        return this.warning;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getQualifier() {
        return this.dcQualifier;
    }

    public boolean getLanguage() {
        return this.language;
    }

    public String getHints() {
        return this.hint;
    }

    public String getLabel() {
        return this.label;
    }

    public String getStyle() {
        return this.style;
    }

    public String getPairsType() {
        return this.valueListName;
    }

    public List getPairs() {
        return this.valueList;
    }

    public List<String> getValueLanguageList() {
        return this.valueLanguageList;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public void setVocabulary(String vocabulary) {
        this.vocabulary = vocabulary;
    }

    public String getDisplayString(String pairTypeName, String storedString) {
        if (this.valueList != null && storedString != null) {
            for (int i = 0; i < this.valueList.size(); i += 2) {
                if (!storedString.equals(this.valueList.get(i + 1))) continue;
                return this.valueList.get(i);
            }
        }
        return null;
    }

    public String getStoredString(String pairTypeName, String displayedString) {
        if (this.valueList != null && displayedString != null) {
            for (int i = 0; i < this.valueList.size(); i += 2) {
                if (!displayedString.equals(this.valueList.get(i))) continue;
                return this.valueList.get(i + 1);
            }
        }
        return null;
    }

    public boolean isClosedVocabulary() {
        return this.closedVocabulary;
    }

    public boolean isAllowedFor(String typeName) {
        if (this.typeBind.size() == 0) {
            return true;
        }
        return this.typeBind.contains(typeName);
    }

    public String getScope() {
        return this.visibility;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getFieldName() {
        return Utils.standardize(this.getSchema(), this.getElement(), this.getQualifier(), ".");
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public String getSearchConfiguration() {
        return this.searchConfiguration;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<String> getExternalSources() {
        return this.externalSources;
    }

    public boolean isQualdropValue() {
        return "qualdrop_value".equals(this.getInputType());
    }

    public boolean validate(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                Pattern pattern;
                if (StringUtils.isNotBlank((CharSequence)this.regex) && !(pattern = Pattern.compile(this.regex)).matcher(value).matches()) {
                    return false;
                }
            }
            catch (PatternSyntaxException ex) {
                log.error("Regex validation failed!  {}", (Object)ex.getMessage());
            }
        }
        return true;
    }

    public List<String> getTypeBindList() {
        return this.typeBind;
    }

    public boolean isRelationshipField() {
        return this.isRelationshipField;
    }

    public boolean isMetadataField() {
        return this.isMetadataField;
    }
}

