/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataService;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.dao.RelationshipDAO;
import org.dspace.content.dao.pojo.ItemUuidAndRelationshipId;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.virtual.VirtualMetadataConfiguration;
import org.dspace.content.virtual.VirtualMetadataPopulator;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.utils.RelationshipVersioningUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RelationshipServiceImpl
implements RelationshipService {
    private static final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected RelationshipDAO relationshipDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected RelationshipTypeService relationshipTypeService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private RelationshipMetadataService relationshipMetadataService;
    @Autowired
    private RelationshipVersioningUtils relationshipVersioningUtils;
    @Autowired
    private VirtualMetadataPopulator virtualMetadataPopulator;

    @Override
    public Relationship create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can modify relationship");
        }
        return this.relationshipDAO.create(context, new Relationship());
    }

    @Override
    public Relationship create(Context c, Item leftItem, Item rightItem, RelationshipType relationshipType, int leftPlace, int rightPlace) throws AuthorizeException, SQLException {
        return this.create(c, leftItem, rightItem, relationshipType, leftPlace, rightPlace, null, null);
    }

    @Override
    public Relationship create(Context c, Item leftItem, Item rightItem, RelationshipType relationshipType, int leftPlace, int rightPlace, String leftwardValue, String rightwardValue, Relationship.LatestVersionStatus latestVersionStatus) throws AuthorizeException, SQLException {
        Relationship relationship = new Relationship();
        relationship.setLeftItem(leftItem);
        relationship.setRightItem(rightItem);
        relationship.setRelationshipType(relationshipType);
        relationship.setLeftPlace(leftPlace);
        relationship.setRightPlace(rightPlace);
        relationship.setLeftwardValue(leftwardValue);
        relationship.setRightwardValue(rightwardValue);
        relationship.setLatestVersionStatus(latestVersionStatus);
        return this.create(c, relationship);
    }

    @Override
    public Relationship create(Context c, Item leftItem, Item rightItem, RelationshipType relationshipType, int leftPlace, int rightPlace, String leftwardValue, String rightwardValue) throws AuthorizeException, SQLException {
        return this.create(c, leftItem, rightItem, relationshipType, leftPlace, rightPlace, leftwardValue, rightwardValue, Relationship.LatestVersionStatus.BOTH);
    }

    @Override
    public Relationship create(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        if (this.isRelationshipValidToCreate(context, relationship)) {
            if (this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) || this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
                Relationship relationshipToReturn = this.relationshipDAO.create(context, relationship);
                this.updatePlaceInRelationship(context, relationshipToReturn, null, null, true, true);
                this.update(context, relationshipToReturn);
                this.updateItemsInRelationship(context, relationship);
                return relationshipToReturn;
            }
            throw new AuthorizeException("You do not have write rights on this relationship's items");
        }
        throw new IllegalArgumentException("The relationship given was not valid");
    }

    @Override
    public Relationship move(Context context, Relationship relationship, Integer newLeftPlace, Integer newRightPlace) throws SQLException, AuthorizeException {
        if (this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) || this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
            if (newLeftPlace != null || newRightPlace != null) {
                this.updatePlaceInRelationship(context, relationship, newLeftPlace, newRightPlace, false, false);
                this.update(context, relationship);
                this.updateItemsInRelationship(context, relationship);
            }
            return relationship;
        }
        throw new AuthorizeException("You do not have write rights on this relationship's items");
    }

    @Override
    public Relationship move(Context context, Relationship relationship, Item newLeftItem, Item newRightItem) throws SQLException, AuthorizeException {
        newLeftItem = newLeftItem != relationship.getLeftItem() ? newLeftItem : null;
        Item item = newRightItem = newRightItem != relationship.getRightItem() ? newRightItem : null;
        if (newLeftItem != null || newRightItem != null) {
            this.move(context, relationship, newLeftItem != null ? Integer.valueOf(-1) : null, newRightItem != null ? Integer.valueOf(-1) : null);
            boolean insertLeft = false;
            boolean insertRight = false;
            if (newLeftItem != null) {
                relationship.getLeftItem().setMetadataModified();
                relationship.setLeftItem(newLeftItem);
                relationship.setLeftPlace(-1);
                insertLeft = true;
            }
            if (newRightItem != null) {
                relationship.getRightItem().setMetadataModified();
                relationship.setRightItem(newRightItem);
                relationship.setRightPlace(-1);
                insertRight = true;
            }
            this.updatePlaceInRelationship(context, relationship, null, null, insertLeft, insertRight);
            this.update(context, relationship);
            this.updateItemsInRelationship(context, relationship);
        }
        return relationship;
    }

    private void updatePlaceInRelationship(Context context, Relationship relationship, Integer newLeftPlace, Integer newRightPlace, boolean insertLeft, boolean insertRight) throws SQLException, AuthorizeException {
        Item leftItem = relationship.getLeftItem();
        Item rightItem = relationship.getRightItem();
        List<Relationship> leftRelationships = this.findByItemAndRelationshipType(context, leftItem, relationship.getRelationshipType(), true, -1, -1, false);
        List<Relationship> rightRelationships = this.findByItemAndRelationshipType(context, rightItem, relationship.getRelationshipType(), false, -1, -1, false);
        boolean deletedFromLeft = !leftRelationships.contains(relationship);
        boolean deletedFromRight = !rightRelationships.contains(relationship);
        leftRelationships.remove(relationship);
        rightRelationships.remove(relationship);
        List<MetadataValue> leftMetadata = this.getSiblingMetadata(leftItem, relationship, true);
        List<MetadataValue> rightMetadata = this.getSiblingMetadata(rightItem, relationship, false);
        int oldLeftPlace = relationship.getLeftPlace();
        int oldRightPlace = relationship.getRightPlace();
        boolean movedUpLeft = this.resolveRelationshipPlace(relationship, true, leftRelationships, leftMetadata, oldLeftPlace, newLeftPlace);
        boolean movedUpRight = this.resolveRelationshipPlace(relationship, false, rightRelationships, rightMetadata, oldRightPlace, newRightPlace);
        context.turnOffAuthorisationSystem();
        if (this.relationshipVersioningUtils.otherSideIsLatest(true, relationship.getLatestVersionStatus())) {
            this.shiftSiblings(relationship, true, oldLeftPlace, movedUpLeft, insertLeft, deletedFromLeft, leftRelationships, leftMetadata);
        }
        if (this.relationshipVersioningUtils.otherSideIsLatest(false, relationship.getLatestVersionStatus())) {
            this.shiftSiblings(relationship, false, oldRightPlace, movedUpRight, insertRight, deletedFromRight, rightRelationships, rightMetadata);
        }
        this.updateItem(context, leftItem);
        this.updateItem(context, rightItem);
        context.restoreAuthSystemState();
    }

    private List<MetadataValue> getSiblingMetadata(Item item, Relationship relationship, boolean isLeft) {
        HashMap<String, VirtualMetadataConfiguration> mapping;
        ArrayList<MetadataValue> metadata = new ArrayList<MetadataValue>();
        if (this.virtualMetadataPopulator.isUseForPlaceTrueForRelationshipType(relationship.getRelationshipType(), isLeft) && (mapping = isLeft ? this.virtualMetadataPopulator.getMap().get(relationship.getRelationshipType().getLeftwardType()) : this.virtualMetadataPopulator.getMap().get(relationship.getRelationshipType().getRightwardType())) != null) {
            for (String mdf : mapping.keySet()) {
                metadata.addAll(item.getMetadata().stream().filter(mdv -> mdv.getMetadataField().toString().equals(mdf.replace(".", "_"))).collect(Collectors.toList()));
            }
        }
        return metadata;
    }

    private boolean resolveRelationshipPlace(Relationship relationship, boolean isLeft, List<Relationship> relationships, List<MetadataValue> metadata, int oldPlace, Integer newPlace) {
        boolean movedUp = false;
        if (newPlace != null) {
            if (newPlace == -1) {
                int nextPlace = this.getNextPlace(relationships, metadata, isLeft);
                newPlace = nextPlace == oldPlace ? Integer.valueOf(oldPlace) : Integer.valueOf(nextPlace - 1);
            }
            if (newPlace > oldPlace) {
                movedUp = true;
            }
        } else if (oldPlace == -1) {
            newPlace = this.getNextPlace(relationships, metadata, isLeft);
        }
        if (newPlace != null) {
            this.setPlace(relationship, isLeft, newPlace);
        }
        return movedUp;
    }

    private int getNextPlace(List<Relationship> relationships, List<MetadataValue> metadata, boolean isLeft) {
        return Stream.concat(metadata.stream().map(MetadataValue::getPlace), relationships.stream().map(r -> this.getPlace((Relationship)r, isLeft))).max(Integer::compare).map(integer -> integer + 1).orElse(0);
    }

    private void shiftSiblings(Relationship relationship, boolean isLeft, int oldPlace, boolean movedUp, boolean inserted, boolean deleted, List<Relationship> relationships, List<MetadataValue> metadata) {
        int newPlace = this.getPlace(relationship, isLeft);
        for (Relationship sibling : relationships) {
            if (!this.relationshipVersioningUtils.otherSideIsLatest(isLeft, sibling.getLatestVersionStatus())) continue;
            int siblingPlace = this.getPlace(sibling, isLeft);
            if (deleted && siblingPlace > newPlace || movedUp && siblingPlace <= newPlace && siblingPlace > oldPlace) {
                this.setPlace(sibling, isLeft, siblingPlace - 1);
                continue;
            }
            if ((!inserted || siblingPlace < newPlace) && (movedUp || siblingPlace < newPlace || siblingPlace >= oldPlace)) continue;
            this.setPlace(sibling, isLeft, siblingPlace + 1);
        }
        for (MetadataValue mdv : metadata) {
            int mdvPlace = mdv.getPlace();
            if (deleted && mdvPlace > newPlace || movedUp && mdvPlace <= newPlace && mdvPlace > oldPlace) {
                mdv.setPlace(mdvPlace - 1);
                continue;
            }
            if ((!inserted || mdvPlace < newPlace) && (movedUp || mdvPlace < newPlace || mdvPlace >= oldPlace)) continue;
            mdv.setPlace(mdvPlace + 1);
        }
    }

    private int getPlace(Relationship relationship, boolean isLeft) {
        if (isLeft) {
            return relationship.getLeftPlace();
        }
        return relationship.getRightPlace();
    }

    private void setPlace(Relationship relationship, boolean isLeft, int place) {
        if (isLeft) {
            relationship.setLeftPlace(place);
        } else {
            relationship.setRightPlace(place);
        }
    }

    @Override
    public void updateItem(Context context, Item relatedItem) throws SQLException, AuthorizeException {
        relatedItem.setMetadataModified();
        this.itemService.update(context, relatedItem);
    }

    private boolean isRelationshipValidToCreate(Context context, Relationship relationship) throws SQLException {
        RelationshipType relationshipType = relationship.getRelationshipType();
        if (!this.verifyEntityTypes(relationship.getLeftItem(), relationshipType.getLeftType())) {
            log.warn("The relationship has been deemed invalid since the leftItem and leftType do no match on entityType");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!this.verifyEntityTypes(relationship.getRightItem(), relationshipType.getRightType())) {
            log.warn("The relationship has been deemed invalid since the rightItem and rightType do no match on entityType");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!relationship.getLatestVersionStatus().equals((Object)Relationship.LatestVersionStatus.LEFT_ONLY) && !this.verifyMaxCardinality(context, relationship.getLeftItem(), relationshipType.getLeftMaxCardinality(), relationshipType, true)) {
            log.warn("The relationship has been deemed invalid since the left item has more relationships than the left max cardinality allows after we'd store this relationship");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!relationship.getLatestVersionStatus().equals((Object)Relationship.LatestVersionStatus.RIGHT_ONLY) && !this.verifyMaxCardinality(context, relationship.getRightItem(), relationshipType.getRightMaxCardinality(), relationshipType, false)) {
            log.warn("The relationship has been deemed invalid since the right item has more relationships than the right max cardinality allows after we'd store this relationship");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        return true;
    }

    private void logRelationshipTypeDetailsForError(RelationshipType relationshipType) {
        log.warn("The relationshipType's ID is: " + relationshipType.getID());
        log.warn("The relationshipType's leftward type is: " + relationshipType.getLeftwardType());
        log.warn("The relationshipType's rightward type is: " + relationshipType.getRightwardType());
        log.warn("The relationshipType's left entityType label is: " + relationshipType.getLeftType().getLabel());
        log.warn("The relationshipType's right entityType label is: " + relationshipType.getRightType().getLabel());
        log.warn("The relationshipType's left min cardinality is: " + relationshipType.getLeftMinCardinality());
        log.warn("The relationshipType's left max cardinality is: " + relationshipType.getLeftMaxCardinality());
        log.warn("The relationshipType's right min cardinality is: " + relationshipType.getRightMinCardinality());
        log.warn("The relationshipType's right max cardinality is: " + relationshipType.getRightMaxCardinality());
    }

    private boolean verifyMaxCardinality(Context context, Item itemToProcess, Integer maxCardinality, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        if (maxCardinality == null) {
            return true;
        }
        List<Relationship> rightRelationships = this.findByItemAndRelationshipType(context, itemToProcess, relationshipType, isLeft);
        return rightRelationships.size() < maxCardinality;
    }

    private boolean verifyEntityTypes(Item itemToProcess, EntityType entityTypeToProcess) {
        List<MetadataValue> list = this.itemService.getMetadata(itemToProcess, "dspace", "entity", "type", "*", false);
        if (list.isEmpty()) {
            return false;
        }
        String leftEntityType = list.get(0).getValue();
        return StringUtils.equals((CharSequence)leftEntityType, (CharSequence)entityTypeToProcess.getLabel());
    }

    @Override
    public Relationship find(Context context, int id) throws SQLException {
        Relationship relationship = (Relationship)this.relationshipDAO.findByID(context, Relationship.class, id);
        return relationship;
    }

    @Override
    public List<Relationship> findByItem(Context context, Item item) throws SQLException {
        return this.findByItem(context, item, -1, -1, false);
    }

    @Override
    public List<Relationship> findByItem(Context context, Item item, Integer limit, Integer offset, boolean excludeTilted) throws SQLException {
        return this.findByItem(context, item, limit, offset, excludeTilted, true);
    }

    @Override
    public List<Relationship> findByItem(Context context, Item item, Integer limit, Integer offset, boolean excludeTilted, boolean excludeNonLatest) throws SQLException {
        List<Relationship> list = this.relationshipDAO.findByItem(context, item, limit, offset, excludeTilted, excludeNonLatest);
        list.sort((o1, o2) -> {
            int relationshipType = o1.getRelationshipType().getLeftwardType().compareTo(o2.getRelationshipType().getLeftwardType());
            if (relationshipType != 0) {
                return relationshipType;
            }
            if (o1.getLeftItem() == item) {
                return o1.getLeftPlace() - o2.getLeftPlace();
            }
            return o1.getRightPlace() - o2.getRightPlace();
        });
        return list;
    }

    @Override
    public List<Relationship> findAll(Context context) throws SQLException {
        return this.findAll(context, -1, -1);
    }

    @Override
    public List<Relationship> findAll(Context context, Integer limit, Integer offset) throws SQLException {
        return this.relationshipDAO.findAll(context, Relationship.class, limit, offset);
    }

    @Override
    public void update(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        this.update(context, Collections.singletonList(relationship));
    }

    @Override
    public void update(Context context, List<Relationship> relationships) throws SQLException, AuthorizeException {
        if (CollectionUtils.isNotEmpty(relationships)) {
            for (Relationship relationship : relationships) {
                if (this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) || this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
                    if (!this.isRelationshipValidToCreate(context, relationship)) continue;
                    this.relationshipDAO.save(context, relationship);
                    continue;
                }
                throw new AuthorizeException("You do not have write rights on this relationship's items");
            }
        }
    }

    @Override
    public void delete(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        this.delete(context, relationship, relationship.getRelationshipType().isCopyToLeft(), relationship.getRelationshipType().isCopyToRight());
    }

    @Override
    public void delete(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException, AuthorizeException {
        log.info(LogHelper.getHeader(context, "delete_relationship", "relationship_id=" + relationship.getID() + "&copyMetadataValuesToLeftItem=" + copyToLeftItem + "&copyMetadataValuesToRightItem=" + copyToRightItem));
        if (!this.isRelationshipValidToDelete(context, relationship) || !this.copyToItemPermissionCheck(context, relationship, copyToLeftItem, copyToRightItem)) {
            throw new IllegalArgumentException("The relationship given was not valid");
        }
        this.deleteRelationshipAndCopyToItem(context, relationship, copyToLeftItem, copyToRightItem);
    }

    @Override
    public void forceDelete(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException, AuthorizeException {
        log.info(LogHelper.getHeader(context, "delete_relationship", "relationship_id=" + relationship.getID() + "&copyMetadataValuesToLeftItem=" + copyToLeftItem + "&copyMetadataValuesToRightItem=" + copyToRightItem));
        if (!this.copyToItemPermissionCheck(context, relationship, copyToLeftItem, copyToRightItem)) {
            throw new IllegalArgumentException("The relationship given was not valid");
        }
        this.deleteRelationshipAndCopyToItem(context, relationship, copyToLeftItem, copyToRightItem);
    }

    private void deleteRelationshipAndCopyToItem(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException, AuthorizeException {
        this.copyMetadataValues(context, relationship, copyToLeftItem, copyToRightItem);
        if (!this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) && !this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
            throw new AuthorizeException("You do not have write rights on this relationship's items");
        }
        this.relationshipDAO.delete(context, relationship);
        this.updatePlaceInRelationship(context, relationship, null, null, false, false);
        this.updateItemsInRelationship(context, relationship);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemsInRelationship(Context context, Relationship relationship) throws SQLException {
        context.turnOffAuthorisationSystem();
        try {
            int max = this.configurationService.getIntProperty("relationship.update.relateditems.max", 20);
            int maxDepth = this.configurationService.getIntProperty("relationship.update.relateditems.maxdepth", 5);
            ArrayList<Item> itemsToUpdate = new ArrayList<Item>();
            itemsToUpdate.add(relationship.getLeftItem());
            itemsToUpdate.add(relationship.getRightItem());
            if (this.containsVirtualMetadata(relationship.getRelationshipType().getLeftwardType())) {
                this.findModifiedDiscoveryItemsForCurrentItem(context, relationship.getLeftItem(), itemsToUpdate, max, 0, maxDepth);
            }
            if (this.containsVirtualMetadata(relationship.getRelationshipType().getRightwardType())) {
                this.findModifiedDiscoveryItemsForCurrentItem(context, relationship.getRightItem(), itemsToUpdate, max, 0, maxDepth);
            }
            for (Item item : itemsToUpdate) {
                this.updateItem(context, item);
            }
        }
        catch (AuthorizeException e) {
            log.error("Authorization Exception while authorization has been disabled", (Throwable)e);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    private void findModifiedDiscoveryItemsForCurrentItem(Context context, Item item, List<Item> itemsToUpdate, int max, int currentDepth, int maxDepth) throws SQLException {
        if (itemsToUpdate.size() >= max) {
            log.debug("skipping findModifiedDiscoveryItemsForCurrentItem for item " + item.getID() + " due to " + itemsToUpdate.size() + " items to be updated");
            return;
        }
        if (currentDepth == maxDepth) {
            log.debug("skipping findModifiedDiscoveryItemsForCurrentItem for item " + item.getID() + " due to " + currentDepth + " depth");
            return;
        }
        String entityTypeStringFromMetadata = this.itemService.getEntityTypeLabel(item);
        EntityType actualEntityType = this.entityTypeService.findByEntityType(context, entityTypeStringFromMetadata);
        List<RelationshipType> relationshipTypes = this.relationshipTypeService.findByEntityType(context, actualEntityType);
        for (RelationshipType relationshipType : relationshipTypes) {
            boolean isLeft = relationshipType.getLeftType().equals(actualEntityType);
            String typeToSearchInVirtualMetadata = isLeft ? relationshipType.getRightwardType() : relationshipType.getLeftwardType();
            if (this.containsVirtualMetadata(typeToSearchInVirtualMetadata)) {
                List<Relationship> list = this.findByItemAndRelationshipType(context, item, relationshipType, isLeft);
                for (Relationship foundRelationship : list) {
                    Item nextItem = isLeft ? foundRelationship.getRightItem() : foundRelationship.getLeftItem();
                    if (itemsToUpdate.contains(nextItem)) continue;
                    itemsToUpdate.add(nextItem);
                    this.findModifiedDiscoveryItemsForCurrentItem(context, nextItem, itemsToUpdate, max, currentDepth + 1, maxDepth);
                }
                continue;
            }
            log.debug("skipping " + relationshipType.getID() + " in findModifiedDiscoveryItemsForCurrentItem for item " + item.getID() + " because no relevant virtual metadata was found");
        }
    }

    private boolean containsVirtualMetadata(String typeToSearchInVirtualMetadata) {
        return this.virtualMetadataPopulator.getMap().containsKey(typeToSearchInVirtualMetadata) && this.virtualMetadataPopulator.getMap().get(typeToSearchInVirtualMetadata).size() > 0;
    }

    private void copyMetadataValues(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException, AuthorizeException {
        List<RelationshipMetadataValue> relationshipMetadataValues;
        String entityTypeString;
        if (copyToLeftItem) {
            entityTypeString = this.itemService.getEntityTypeLabel(relationship.getLeftItem());
            relationshipMetadataValues = this.relationshipMetadataService.findRelationshipMetadataValueForItemRelationship(context, relationship.getLeftItem(), entityTypeString, relationship, true);
            for (RelationshipMetadataValue relationshipMetadataValue : relationshipMetadataValues) {
                this.itemService.addMetadata(context, relationship.getLeftItem(), relationshipMetadataValue.getMetadataField().getMetadataSchema().getName(), relationshipMetadataValue.getMetadataField().getElement(), relationshipMetadataValue.getMetadataField().getQualifier(), relationshipMetadataValue.getLanguage(), relationshipMetadataValue.getValue(), null, -1, relationshipMetadataValue.getPlace());
            }
            this.itemService.update(context, relationship.getLeftItem());
        }
        if (copyToRightItem) {
            entityTypeString = this.itemService.getEntityTypeLabel(relationship.getRightItem());
            relationshipMetadataValues = this.relationshipMetadataService.findRelationshipMetadataValueForItemRelationship(context, relationship.getRightItem(), entityTypeString, relationship, true);
            for (RelationshipMetadataValue relationshipMetadataValue : relationshipMetadataValues) {
                this.itemService.addMetadata(context, relationship.getRightItem(), relationshipMetadataValue.getMetadataField().getMetadataSchema().getName(), relationshipMetadataValue.getMetadataField().getElement(), relationshipMetadataValue.getMetadataField().getQualifier(), relationshipMetadataValue.getLanguage(), relationshipMetadataValue.getValue(), null, -1, relationshipMetadataValue.getPlace());
            }
            this.itemService.update(context, relationship.getRightItem());
        }
    }

    private boolean copyToItemPermissionCheck(Context context, Relationship relationship, boolean copyToLeftItem, boolean copyToRightItem) throws SQLException {
        boolean isPermissionCorrect = true;
        if (copyToLeftItem && !this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1)) {
            isPermissionCorrect = false;
        }
        if (copyToRightItem && !this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
            isPermissionCorrect = false;
        }
        return isPermissionCorrect;
    }

    private boolean isRelationshipValidToDelete(Context context, Relationship relationship) throws SQLException {
        if (relationship == null) {
            log.warn("The relationship has been deemed invalid since the relation was null");
            return false;
        }
        if (relationship.getID() == null) {
            log.warn("The relationship has been deemed invalid since the ID off the given relationship was null");
            return false;
        }
        if (this.find(context, relationship.getID()) == null) {
            log.warn("The relationship has been deemed invalid since the relationship is not present in the DB with the current ID");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        if (!this.checkMinCardinality(context, relationship.getLeftItem(), relationship, relationship.getRelationshipType().getLeftMinCardinality(), true)) {
            log.warn("The relationship has been deemed invalid since the leftMinCardinality constraint would be violated upon deletion");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        if (!this.checkMinCardinality(context, relationship.getRightItem(), relationship, relationship.getRelationshipType().getRightMinCardinality(), false)) {
            log.warn("The relationship has been deemed invalid since the rightMinCardinality constraint would be violated upon deletion");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        return true;
    }

    private boolean checkMinCardinality(Context context, Item item, Relationship relationship, Integer minCardinality, boolean isLeft) throws SQLException {
        List<Relationship> list = this.findByItemAndRelationshipType(context, item, relationship.getRelationshipType(), isLeft, -1, -1);
        return minCardinality == null || list.size() > minCardinality;
    }

    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        return this.findByItemAndRelationshipType(context, item, relationshipType, isLeft, -1, -1);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType) throws SQLException {
        return this.findByItemAndRelationshipType(context, item, relationshipType, -1, -1, true);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, int limit, int offset) throws SQLException {
        return this.findByItemAndRelationshipType(context, item, relationshipType, limit, offset, true);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, int limit, int offset, boolean excludeNonLatest) throws SQLException {
        return this.relationshipDAO.findByItemAndRelationshipType(context, item, relationshipType, limit, offset, excludeNonLatest);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft, int limit, int offset) throws SQLException {
        return this.findByItemAndRelationshipType(context, item, relationshipType, isLeft, limit, offset, true);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft, int limit, int offset, boolean excludeNonLatest) throws SQLException {
        return this.relationshipDAO.findByItemAndRelationshipType(context, item, relationshipType, isLeft, limit, offset, excludeNonLatest);
    }

    @Override
    public List<ItemUuidAndRelationshipId> findByLatestItemAndRelationshipType(Context context, Item latestItem, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        return this.relationshipDAO.findByLatestItemAndRelationshipType(context, latestItem, relationshipType, isLeft);
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        return this.findByRelationshipType(context, relationshipType, -1, -1);
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType, Integer limit, Integer offset) throws SQLException {
        return this.relationshipDAO.findByRelationshipType(context, relationshipType, limit, offset);
    }

    @Override
    public List<Relationship> findByTypeName(Context context, String typeName) throws SQLException {
        return this.findByTypeName(context, typeName, -1, -1);
    }

    @Override
    public List<Relationship> findByTypeName(Context context, String typeName, Integer limit, Integer offset) throws SQLException {
        return this.relationshipDAO.findByTypeName(context, typeName, limit, offset);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.relationshipDAO.countRows(context);
    }

    @Override
    public int countByItem(Context context, Item item) throws SQLException {
        return this.countByItem(context, item, false, true);
    }

    @Override
    public int countByItem(Context context, Item item, boolean excludeTilted, boolean excludeNonLatest) throws SQLException {
        return this.relationshipDAO.countByItem(context, item, excludeTilted, excludeNonLatest);
    }

    @Override
    public int countByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        return this.relationshipDAO.countByRelationshipType(context, relationshipType);
    }

    @Override
    public int countByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        return this.countByItemAndRelationshipType(context, item, relationshipType, isLeft, true);
    }

    @Override
    public int countByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft, boolean excludeNonLatest) throws SQLException {
        return this.relationshipDAO.countByItemAndRelationshipType(context, item, relationshipType, isLeft, excludeNonLatest);
    }

    @Override
    public int countByTypeName(Context context, String typeName) throws SQLException {
        return this.relationshipDAO.countByTypeName(context, typeName);
    }

    @Override
    public List<Relationship> findByItemRelationshipTypeAndRelatedList(Context context, UUID focusUUID, RelationshipType relationshipType, List<UUID> items, boolean isLeft, int offset, int limit) throws SQLException {
        return this.relationshipDAO.findByItemAndRelationshipTypeAndList(context, focusUUID, relationshipType, items, isLeft, offset, limit);
    }

    @Override
    public int countByItemRelationshipTypeAndRelatedList(Context context, UUID focusUUID, RelationshipType relationshipType, List<UUID> items, boolean isLeft) throws SQLException {
        return this.relationshipDAO.countByItemAndRelationshipTypeAndList(context, focusUUID, relationshipType, items, isLeft);
    }
}

