/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceIndexCollectionSubmittersPlugin
implements SolrServiceIndexPlugin {
    private static final Logger log = LogManager.getLogger(SolrServiceIndexCollectionSubmittersPlugin.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;

    @Override
    public void additionalIndex(Context context, IndexableObject idxObj, SolrInputDocument document) {
        Collection col;
        if (idxObj instanceof IndexableCollection && (col = (Collection)((IndexableCollection)idxObj).getIndexedObject()) != null) {
            try {
                String fieldValue = null;
                Community parent = (Community)ContentServiceFactory.getInstance().getDSpaceObjectService(col).getParentObject(context, col);
                while (parent != null) {
                    if (parent.getAdministrators() != null) {
                        fieldValue = "g" + parent.getAdministrators().getID();
                        document.addField("submit", (Object)fieldValue);
                    }
                    parent = (Community)ContentServiceFactory.getInstance().getDSpaceObjectService(parent).getParentObject(context, parent);
                }
                List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, col, 3);
                policies.addAll(this.authorizeService.getPoliciesActionFilter(context, col, 11));
                for (ResourcePolicy resourcePolicy : policies) {
                    fieldValue = resourcePolicy.getGroup() != null ? "g" + resourcePolicy.getGroup().getID() : "e" + resourcePolicy.getEPerson().getID();
                    document.addField("submit", (Object)fieldValue);
                    context.uncacheEntity(resourcePolicy);
                }
            }
            catch (SQLException e) {
                log.error(LogHelper.getHeader(context, "Error while indexing resource policies", "Collection: (id " + col.getID() + " type " + col.getName() + ")"));
            }
        }
    }
}

