/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.mail.MessagingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.search.Harvest;
import org.dspace.search.HarvestedItemInfo;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class SubscribeCLITool {
    private static final Logger log = LogManager.getLogger(SubscribeCLITool.class);
    private static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final SubscribeService subscribeService = EPersonServiceFactory.getInstance().getSubscribeService();
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    private SubscribeCLITool() {
    }

    public static void processDaily(Context context, boolean test) throws SQLException, IOException {
        List<Subscription> subscriptions = subscribeService.findAll(context);
        DSpaceObject currentEPerson = null;
        ArrayList<Collection> collections = null;
        for (Subscription subscription : subscriptions) {
            if (currentEPerson == null || !subscription.getePerson().getID().equals(currentEPerson.getID())) {
                if (currentEPerson != null) {
                    try {
                        SubscribeCLITool.sendEmail(context, (EPerson)currentEPerson, collections, test);
                    }
                    catch (MessagingException me) {
                        log.error("Failed to send subscription to eperson_id=" + currentEPerson.getID());
                        log.error((Object)me);
                    }
                }
                currentEPerson = subscription.getePerson();
                collections = new ArrayList<Collection>();
            }
            collections.add(subscription.getCollection());
        }
        if (currentEPerson != null) {
            try {
                SubscribeCLITool.sendEmail(context, currentEPerson, collections, test);
            }
            catch (MessagingException me) {
                log.error("Failed to send subscription to eperson_id=" + currentEPerson.getID());
                log.error((Object)me);
            }
        }
    }

    public static void sendEmail(Context context, EPerson eperson, List<Collection> collections, boolean test) throws IOException, MessagingException, SQLException {
        Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
        ResourceBundle labels = ResourceBundle.getBundle("Messages", supportedLocale);
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(new Date());
        cal.add(10, -24);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date midnightYesterday = cal.getTime();
        StringBuilder emailText = new StringBuilder();
        boolean isFirst = true;
        for (int i = 0; i < collections.size(); ++i) {
            Collection c = collections.get(i);
            try {
                boolean includeAll = configurationService.getBooleanProperty("harvest.includerestricted.subscription", true);
                List<HarvestedItemInfo> itemInfos = Harvest.harvest(context, c, new DCDate(midnightYesterday).toString(), null, 0, 0, true, false, false, includeAll);
                itemInfos = configurationService.getBooleanProperty("eperson.subscription.onlynew", false) ? SubscribeCLITool.filterOutModified(itemInfos) : SubscribeCLITool.filterOutToday(itemInfos);
                if (itemInfos.size() <= 0) continue;
                if (!isFirst) {
                    emailText.append("\n---------------------------------------\n");
                } else {
                    isFirst = false;
                }
                emailText.append(labels.getString("org.dspace.eperson.Subscribe.new-items")).append(" ").append(c.getName()).append(": ").append(itemInfos.size()).append("\n\n");
                for (int j = 0; j < itemInfos.size(); ++j) {
                    HarvestedItemInfo hii = itemInfos.get(j);
                    String title = hii.item.getName();
                    emailText.append("      ").append(labels.getString("org.dspace.eperson.Subscribe.title")).append(" ");
                    if (StringUtils.isNotBlank((CharSequence)title)) {
                        emailText.append(title);
                    } else {
                        emailText.append(labels.getString("org.dspace.eperson.Subscribe.untitled"));
                    }
                    List<MetadataValue> authors = itemService.getMetadata(hii.item, MetadataSchemaEnum.DC.getName(), "contributor", "*", "*");
                    if (authors.size() > 0) {
                        emailText.append("\n    ").append(labels.getString("org.dspace.eperson.Subscribe.authors")).append(" ").append(authors.get(0).getValue());
                        for (int k = 1; k < authors.size(); ++k) {
                            emailText.append("\n             ").append(authors.get(k).getValue());
                        }
                    }
                    emailText.append("\n         ").append(labels.getString("org.dspace.eperson.Subscribe.id")).append(" ").append(handleService.getCanonicalForm(hii.handle)).append("\n\n");
                }
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (emailText.length() > 0) {
            if (test) {
                log.info(LogHelper.getHeader(context, "subscription:", "eperson=" + eperson.getEmail()));
                log.info(LogHelper.getHeader(context, "subscription:", "text=" + emailText.toString()));
            } else {
                Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "subscription"));
                email.addRecipient(eperson.getEmail());
                email.addArgument(emailText.toString());
                email.send();
                log.info(LogHelper.getHeader(context, "sent_subscription", "eperson_id=" + eperson.getID()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        String usage = "org.dspace.eperson.Subscribe [-t] or nothing to send out subscriptions.";
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine line = null;
        Option opt = new Option("t", "test", false, "Run test session");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("h", "help", false, "Print this help message");
        opt.setRequired(false);
        options.addOption(opt);
        try {
            line = new DefaultParser().parse(options, argv);
        }
        catch (org.apache.commons.cli.ParseException e) {
            formatter.printHelp(usage, e.getMessage(), options, "");
            System.exit(1);
        }
        if (line.hasOption("h")) {
            formatter.printHelp(usage, options);
            System.exit(1);
        }
        boolean test = line.hasOption("t");
        Context context = null;
        try {
            context = new Context(Context.Mode.READ_ONLY);
            SubscribeCLITool.processDaily(context, test);
            context.complete();
        }
        catch (IOException | SQLException e) {
            log.fatal((Object)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    private static List<HarvestedItemInfo> filterOutToday(List<HarvestedItemInfo> completeList) {
        log.debug("Filtering out all today item to leave new items list size=" + completeList.size());
        ArrayList<HarvestedItemInfo> filteredList = new ArrayList<HarvestedItemInfo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String today = sdf.format(new Date());
        Date thisTimeYesterday = new Date(System.currentTimeMillis() - 86400000L);
        String yesterday = sdf.format(thisTimeYesterday);
        block0: for (HarvestedItemInfo infoObject : completeList) {
            Date lastUpdate = infoObject.item.getLastModified();
            String lastUpdateStr = sdf.format(lastUpdate);
            if (lastUpdateStr.equals(today)) {
                List<MetadataValue> dateAccArr = itemService.getMetadata(infoObject.item, "dc", "date", "accessioned", "*");
                if (dateAccArr != null && dateAccArr.size() > 0) {
                    for (MetadataValue date : dateAccArr) {
                        if (date == null || date.getValue() == null) continue;
                        if (date.getValue().startsWith(yesterday)) {
                            filteredList.add(infoObject);
                            log.debug("adding : " + dateAccArr.get(0).getValue() + " : " + today + " : " + infoObject.handle);
                            continue block0;
                        }
                        log.debug("ignoring : " + dateAccArr.get(0).getValue() + " : " + today + " : " + infoObject.handle);
                    }
                    continue;
                }
                log.debug("no date accessioned, adding  : " + infoObject.handle);
                filteredList.add(infoObject);
                continue;
            }
            filteredList.add(infoObject);
        }
        return filteredList;
    }

    private static List<HarvestedItemInfo> filterOutModified(List<HarvestedItemInfo> completeList) {
        log.debug("Filtering out all modified to leave new items list size=" + completeList.size());
        ArrayList<HarvestedItemInfo> filteredList = new ArrayList<HarvestedItemInfo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date thisTimeYesterday = new Date(System.currentTimeMillis() - 86400000L);
        String yesterday = sdf.format(thisTimeYesterday);
        block0: for (HarvestedItemInfo infoObject : completeList) {
            List<MetadataValue> dateAccArr = itemService.getMetadata(infoObject.item, "dc", "date", "accessioned", "*");
            if (dateAccArr != null && dateAccArr.size() > 0) {
                for (MetadataValue date : dateAccArr) {
                    if (date == null || date.getValue() == null) continue;
                    if (date.getValue().startsWith(yesterday)) {
                        filteredList.add(infoObject);
                        log.debug("adding : " + dateAccArr.get(0).getValue() + " : " + yesterday + " : " + infoObject.handle);
                        continue block0;
                    }
                    log.debug("ignoring : " + dateAccArr.get(0).getValue() + " : " + yesterday + " : " + infoObject.handle);
                }
                continue;
            }
            log.debug("no date accessioned, adding  : " + infoObject.handle);
            filteredList.add(infoObject);
        }
        return filteredList;
    }
}

