/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Item;
import org.dspace.core.ReloadableEntity;
import org.dspace.orcid.OrcidOperation;
import org.hibernate.annotations.Type;

@Entity
@Table(name="orcid_queue")
public class OrcidQueue
implements ReloadableEntity<Integer> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="orcid_queue_id_seq")
    @SequenceGenerator(name="orcid_queue_id_seq", sequenceName="orcid_queue_id_seq", allocationSize=1)
    private Integer id;
    @ManyToOne
    @JoinColumn(name="owner_id")
    protected Item profileItem;
    @ManyToOne
    @JoinColumn(name="entity_id")
    private Item entity;
    @Column(name="description")
    private String description;
    @Column(name="put_code")
    private String putCode;
    @Column(name="record_type")
    private String recordType;
    @Lob
    @Column(name="metadata")
    @Type(type="org.dspace.storage.rdbms.hibernate.DatabaseAwareLobType")
    private String metadata;
    @Enumerated(value=EnumType.STRING)
    @Column(name="operation")
    private OrcidOperation operation;
    @Column(name="attempts")
    private Integer attempts = 0;

    public boolean isInsertAction() {
        return this.entity != null && StringUtils.isEmpty((CharSequence)this.putCode);
    }

    public boolean isUpdateAction() {
        return this.entity != null && StringUtils.isNotEmpty((CharSequence)this.putCode);
    }

    public boolean isDeleteAction() {
        return this.entity == null && StringUtils.isNotEmpty((CharSequence)this.putCode);
    }

    public void setID(Integer id) {
        this.id = id;
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public Item getProfileItem() {
        return this.profileItem;
    }

    public void setProfileItem(Item profileItem) {
        this.profileItem = profileItem;
    }

    public Item getEntity() {
        return this.entity;
    }

    public void setEntity(Item entity) {
        this.entity = entity;
    }

    public String getPutCode() {
        return this.putCode;
    }

    public void setPutCode(String putCode) {
        this.putCode = putCode;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrcidQueue other = (OrcidQueue)obj;
        return Objects.equals(this.id, other.id);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public OrcidOperation getOperation() {
        return this.operation;
    }

    public void setOperation(OrcidOperation operation) {
        this.operation = operation;
    }

    public Integer getAttempts() {
        return this.attempts;
    }

    public void setAttempts(Integer attempts) {
        this.attempts = attempts;
    }

    public String toString() {
        return "OrcidQueue [id=" + this.id + ", profileItem=" + this.profileItem + ", entity=" + this.entity + ", description=" + this.description + ", putCode=" + this.putCode + ", recordType=" + this.recordType + ", metadata=" + this.metadata + ", operation=" + this.operation + "]";
    }
}

