/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.consumer;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.Relationship;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.orcid.OrcidHistory;
import org.dspace.orcid.OrcidOperation;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.model.OrcidEntityType;
import org.dspace.orcid.model.factory.OrcidProfileSectionFactory;
import org.dspace.orcid.service.OrcidHistoryService;
import org.dspace.orcid.service.OrcidProfileSectionFactoryService;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.profile.OrcidProfileSyncPreference;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcidQueueConsumer
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrcidQueueConsumer.class);
    private OrcidQueueService orcidQueueService;
    private OrcidHistoryService orcidHistoryService;
    private OrcidTokenService orcidTokenService;
    private OrcidSynchronizationService orcidSynchronizationService;
    private ItemService itemService;
    private OrcidProfileSectionFactoryService profileSectionFactoryService;
    private ConfigurationService configurationService;
    private RelationshipService relationshipService;
    private List<UUID> alreadyConsumedItems = new ArrayList<UUID>();

    @Override
    public void initialize() throws Exception {
        OrcidServiceFactory orcidServiceFactory = OrcidServiceFactory.getInstance();
        this.orcidQueueService = orcidServiceFactory.getOrcidQueueService();
        this.orcidHistoryService = orcidServiceFactory.getOrcidHistoryService();
        this.orcidSynchronizationService = orcidServiceFactory.getOrcidSynchronizationService();
        this.orcidTokenService = orcidServiceFactory.getOrcidTokenService();
        this.profileSectionFactoryService = orcidServiceFactory.getOrcidProfileSectionFactoryService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Context context, Event event) throws Exception {
        if (this.isOrcidSynchronizationDisabled()) {
            return;
        }
        DSpaceObject dso = event.getSubject(context);
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        if (!item.isArchived()) {
            return;
        }
        if (this.alreadyConsumedItems.contains(item.getID())) {
            return;
        }
        context.turnOffAuthorisationSystem();
        try {
            this.consumeItem(context, item);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    private void consumeItem(Context context, Item item) throws SQLException {
        String entityType = this.itemService.getEntityTypeLabel(item);
        if (entityType == null) {
            return;
        }
        if (OrcidEntityType.isValidEntityType(entityType)) {
            this.consumeEntity(context, item);
        } else if (entityType.equals(this.getProfileType())) {
            this.consumeProfile(context, item);
        }
        this.alreadyConsumedItems.add(item.getID());
    }

    private void consumeEntity(Context context, Item entity) throws SQLException {
        List<Item> relatedItems = this.findAllRelatedItems(context, entity);
        for (Item relatedItem : relatedItems) {
            if (this.isNotProfileItem(relatedItem) || this.isNotLinkedToOrcid(context, relatedItem) || this.shouldNotBeSynchronized(relatedItem, entity) || this.isAlreadyQueued(context, relatedItem, entity)) continue;
            this.orcidQueueService.create(context, relatedItem, entity);
        }
    }

    private List<Item> findAllRelatedItems(Context context, Item entity) throws SQLException {
        return this.relationshipService.findByItem(context, entity).stream().map(relationship -> this.getRelatedItem(entity, (Relationship)relationship)).collect(Collectors.toList());
    }

    private Item getRelatedItem(Item item, Relationship relationship) {
        return item.equals(relationship.getLeftItem()) ? relationship.getRightItem() : relationship.getLeftItem();
    }

    private void consumeProfile(Context context, Item item) throws SQLException {
        if (this.isNotLinkedToOrcid(context, item)) {
            return;
        }
        for (OrcidProfileSectionFactory factory : this.getAllProfileSectionFactories(item)) {
            String sectionType = factory.getProfileSectionType().name();
            this.orcidQueueService.deleteByEntityAndRecordType(context, item, sectionType);
            if (this.isProfileSectionSynchronizationDisabled(context, item, factory)) continue;
            List<String> signatures = factory.getMetadataSignatures(context, item);
            List<OrcidHistory> historyRecords = this.findSuccessfullyOrcidHistoryRecords(context, item, sectionType);
            this.createInsertionRecordForNewSignatures(context, item, historyRecords, factory, signatures);
            this.createDeletionRecordForNoMorePresentSignatures(context, item, historyRecords, factory, signatures);
        }
    }

    private boolean isProfileSectionSynchronizationDisabled(Context context, Item item, OrcidProfileSectionFactory factory) {
        List<OrcidProfileSyncPreference> preferences = this.orcidSynchronizationService.getProfilePreferences(item);
        return !preferences.contains((Object)factory.getSynchronizationPreference());
    }

    private void createInsertionRecordForNewSignatures(Context context, Item item, List<OrcidHistory> historyRecords, OrcidProfileSectionFactory factory, List<String> signatures) throws SQLException {
        String sectionType = factory.getProfileSectionType().name();
        for (String signature : signatures) {
            if (!this.isNotAlreadySynchronized(historyRecords, signature)) continue;
            String description = factory.getDescription(context, item, signature);
            this.orcidQueueService.createProfileInsertionRecord(context, item, description, sectionType, signature);
        }
    }

    private void createDeletionRecordForNoMorePresentSignatures(Context context, Item profile, List<OrcidHistory> historyRecords, OrcidProfileSectionFactory factory, List<String> signatures) throws SQLException {
        String sectionType = factory.getProfileSectionType().name();
        for (OrcidHistory historyRecord : historyRecords) {
            String storedSignature = historyRecord.getMetadata();
            String putCode = historyRecord.getPutCode();
            String description = historyRecord.getDescription();
            if (signatures.contains(storedSignature) || this.isAlreadyDeleted(historyRecords, historyRecord)) continue;
            if (StringUtils.isBlank((CharSequence)putCode)) {
                LOGGER.warn("The orcid history record with id {} should have a not blank put code", (Object)historyRecord.getID());
                continue;
            }
            this.orcidQueueService.createProfileDeletionRecord(context, profile, description, sectionType, storedSignature, putCode);
        }
    }

    private List<OrcidHistory> findSuccessfullyOrcidHistoryRecords(Context context, Item item, String sectionType) throws SQLException {
        return this.orcidHistoryService.findSuccessfullyRecordsByEntityAndType(context, item, sectionType);
    }

    private boolean isNotAlreadySynchronized(List<OrcidHistory> records, String signature) {
        return this.getLastOperation(records, signature).map(operation -> operation == OrcidOperation.DELETE).orElse(Boolean.TRUE);
    }

    private boolean isAlreadyDeleted(List<OrcidHistory> records, OrcidHistory historyRecord) {
        if (historyRecord.getOperation() == OrcidOperation.DELETE) {
            return true;
        }
        return this.findDeletedHistoryRecordsBySignature(records, historyRecord.getMetadata()).anyMatch(record -> record.getTimestamp().after(historyRecord.getTimestamp()));
    }

    private Stream<OrcidHistory> findDeletedHistoryRecordsBySignature(List<OrcidHistory> records, String signature) {
        return records.stream().filter(record -> signature.equals(record.getMetadata())).filter(record -> record.getOperation() == OrcidOperation.DELETE);
    }

    private Optional<OrcidOperation> getLastOperation(List<OrcidHistory> records, String signature) {
        return records.stream().filter(record -> signature.equals(record.getMetadata())).sorted(Comparator.comparing(OrcidHistory::getTimestamp, Comparator.nullsFirst(Comparator.naturalOrder())).reversed()).map(OrcidHistory::getOperation).findFirst();
    }

    private boolean isAlreadyQueued(Context context, Item profileItem, Item entity) throws SQLException {
        return CollectionUtils.isNotEmpty(this.orcidQueueService.findByProfileItemAndEntity(context, profileItem, entity));
    }

    private boolean isNotLinkedToOrcid(Context context, Item profileItemItem) {
        return this.hasNotOrcidAccessToken(context, profileItemItem) || this.getMetadataValue(profileItemItem, "person.identifier.orcid") == null;
    }

    private boolean hasNotOrcidAccessToken(Context context, Item profileItemItem) {
        return this.orcidTokenService.findByProfileItem(context, profileItemItem) == null;
    }

    private boolean shouldNotBeSynchronized(Item profileItem, Item entity) {
        return !this.orcidSynchronizationService.isSynchronizationAllowed(profileItem, entity);
    }

    private boolean isNotProfileItem(Item profileItemItem) {
        return !this.getProfileType().equals(this.itemService.getEntityTypeLabel(profileItemItem));
    }

    private String getMetadataValue(Item item, String metadataField) {
        return this.itemService.getMetadataFirstValue(item, new MetadataFieldName(metadataField), "*");
    }

    private List<OrcidProfileSectionFactory> getAllProfileSectionFactories(Item item) {
        return this.profileSectionFactoryService.findByPreferences(Arrays.asList(OrcidProfileSyncPreference.values()));
    }

    private String getProfileType() {
        return this.configurationService.getProperty("researcher-profile.entity-type", "Person");
    }

    private boolean isOrcidSynchronizationDisabled() {
        return !this.configurationService.getBooleanProperty("orcid.synchronization-enabled", true);
    }

    @Override
    public void end(Context context) throws Exception {
        this.alreadyConsumedItems.clear();
    }

    @Override
    public void finish(Context context) throws Exception {
    }
}

