/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms.migration;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.FileCopyUtils;

public class MigrationUtils {
    private MigrationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Integer dropDBConstraint(Connection connection, String tableName, String columnName, String constraintSuffix) throws SQLException {
        Integer checksum = -1;
        String dbtype = connection.getMetaData().getDatabaseProductName();
        Object constraintName = null;
        String constraintNameSQL = null;
        boolean cascade = false;
        switch (dbtype.toLowerCase()) {
            case "postgres": 
            case "postgresql": {
                constraintName = StringUtils.lowerCase((String)tableName);
                if (!StringUtils.equals((CharSequence)constraintSuffix, (CharSequence)"pkey")) {
                    constraintName = (String)constraintName + "_" + StringUtils.lowerCase((String)columnName);
                }
                constraintName = (String)constraintName + "_" + StringUtils.lowerCase((String)constraintSuffix);
                cascade = true;
                break;
            }
            case "oracle": {
                constraintNameSQL = "SELECT CONSTRAINT_NAME FROM USER_CONS_COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
                cascade = true;
                break;
            }
            case "h2": {
                constraintNameSQL = "SELECT DISTINCT CONSTRAINT_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
                cascade = true;
                break;
            }
            default: {
                throw new SQLException("DBMS " + dbtype + " is unsupported in this migration.");
            }
        }
        if (constraintNameSQL != null) {
            PreparedStatement statement = connection.prepareStatement(constraintNameSQL);
            statement.setString(1, StringUtils.upperCase((String)tableName));
            statement.setString(2, StringUtils.upperCase((String)columnName));
            try {
                ResultSet results = statement.executeQuery();
                if (results.next()) {
                    constraintName = results.getString("CONSTRAINT_NAME");
                }
                results.close();
            }
            finally {
                statement.close();
            }
        }
        if (constraintName != null && !((String)constraintName).isEmpty()) {
            String dropConstraintSQL = "ALTER TABLE " + tableName + " DROP CONSTRAINT " + (String)constraintName;
            if (cascade) {
                dropConstraintSQL = dropConstraintSQL + " CASCADE";
            }
            try (PreparedStatement statement = connection.prepareStatement(dropConstraintSQL);){
                statement.execute();
            }
            checksum = dropConstraintSQL.length();
        }
        return checksum;
    }

    protected static Integer dropDBTable(Connection connection, String tableName) throws SQLException {
        String dropTableSQL = null;
        Integer checksum = -1;
        String dbtype = connection.getMetaData().getDatabaseProductName();
        switch (dbtype.toLowerCase()) {
            case "postgres": 
            case "postgresql": {
                dropTableSQL = "DROP TABLE IF EXISTS " + tableName + " CASCADE";
                break;
            }
            case "oracle": {
                dropTableSQL = "DROP TABLE " + tableName + " CASCADE CONSTRAINTS";
                break;
            }
            case "h2": {
                dropTableSQL = "DROP TABLE IF EXISTS " + tableName + " CASCADE";
                break;
            }
            default: {
                throw new SQLException("DBMS " + dbtype + " is unsupported in this migration.");
            }
        }
        if (dropTableSQL != null) {
            try (PreparedStatement statement = connection.prepareStatement(dropTableSQL);){
                statement.execute();
            }
            checksum = dropTableSQL.length();
        }
        return checksum;
    }

    protected static Integer dropDBSequence(Connection connection, String sequenceName) throws SQLException {
        String dropSequenceSQL = null;
        Integer checksum = -1;
        String dbtype = connection.getMetaData().getDatabaseProductName();
        switch (dbtype.toLowerCase()) {
            case "postgres": 
            case "postgresql": {
                dropSequenceSQL = "DROP SEQUENCE IF EXISTS " + sequenceName;
                break;
            }
            case "oracle": {
                dropSequenceSQL = "DROP SEQUENCE " + sequenceName;
                break;
            }
            case "h2": {
                dropSequenceSQL = "DROP SEQUENCE IF EXISTS " + sequenceName;
                break;
            }
            default: {
                throw new SQLException("DBMS " + dbtype + " is unsupported in this migration.");
            }
        }
        if (dropSequenceSQL != null) {
            try (PreparedStatement statement = connection.prepareStatement(dropSequenceSQL);){
                statement.execute();
            }
            checksum = dropSequenceSQL.length();
        }
        return checksum;
    }

    protected static Integer dropDBView(Connection connection, String viewName) throws SQLException {
        String dropViewSQL = null;
        Integer checksum = -1;
        String dbtype = connection.getMetaData().getDatabaseProductName();
        switch (dbtype.toLowerCase()) {
            case "postgres": 
            case "postgresql": {
                dropViewSQL = "DROP VIEW IF EXISTS " + viewName + " CASCADE";
                break;
            }
            case "oracle": {
                dropViewSQL = "DROP VIEW " + viewName + " CASCADE CONSTRAINTS";
                break;
            }
            case "h2": {
                dropViewSQL = "DROP VIEW IF EXISTS " + viewName + " CASCADE";
                break;
            }
            default: {
                throw new SQLException("DBMS " + dbtype + " is unsupported in this migration.");
            }
        }
        if (dropViewSQL != null) {
            try (PreparedStatement statement = connection.prepareStatement(dropViewSQL);){
                statement.execute();
            }
            checksum = dropViewSQL.length();
        }
        return checksum;
    }

    public static String getResourceAsString(String resourcePath) {
        String string;
        InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(MigrationUtils.class.getClassLoader().getResourceAsStream(resourcePath)), "UTF-8");
        try {
            string = FileCopyUtils.copyToString((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("Resource at " + resourcePath + " was not found", e);
            }
        }
        ((Reader)reader).close();
        return string;
    }
}

