/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.access.status;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dspace.access.status.AccessStatusHelper;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class DefaultAccessStatusHelper
implements AccessStatusHelper {
    public static final String EMBARGO = "embargo";
    public static final String METADATA_ONLY = "metadata.only";
    public static final String OPEN_ACCESS = "open.access";
    public static final String RESTRICTED = "restricted";
    public static final String UNKNOWN = "unknown";
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    @Override
    public String getAccessStatusFromItem(Context context, Item item, Date threshold) throws SQLException {
        if (item == null) {
            return UNKNOWN;
        }
        List<Bundle> bundles = item.getBundles("ORIGINAL");
        Bitstream bitstream = bundles.stream().map(bundle -> bundle.getPrimaryBitstream()).filter(Objects::nonNull).findFirst().orElse(null);
        if (bitstream == null) {
            bitstream = bundles.stream().map(bundle -> bundle.getBitstreams()).flatMap(Collection::stream).findFirst().orElse(null);
        }
        return this.caculateAccessStatusForDso(context, bitstream, threshold);
    }

    private String caculateAccessStatusForDso(Context context, DSpaceObject dso, Date threshold) throws SQLException {
        if (dso == null) {
            return METADATA_ONLY;
        }
        List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, dso, 0);
        int openAccessCount = 0;
        int embargoCount = 0;
        int restrictedCount = 0;
        int unknownCount = 0;
        for (ResourcePolicy policy : policies) {
            boolean isValid = this.resourcePolicyService.isDateValid(policy);
            Group group = policy.getGroup();
            if (group == null) {
                ++unknownCount;
                continue;
            }
            if (!StringUtils.equals((CharSequence)group.getName(), (CharSequence)"Anonymous")) continue;
            if (isValid) {
                ++openAccessCount;
                continue;
            }
            Date startDate = policy.getStartDate();
            if (startDate != null && !startDate.before(threshold)) {
                ++restrictedCount;
                continue;
            }
            ++embargoCount;
        }
        if (openAccessCount > 0) {
            return OPEN_ACCESS;
        }
        if (embargoCount > 0 && restrictedCount == 0) {
            return EMBARGO;
        }
        if (unknownCount > 0) {
            return UNKNOWN;
        }
        return RESTRICTED;
    }
}

