/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.sql.SQLException;
import org.apache.commons.cli.Options;
import org.dspace.app.bulkedit.MetadataExport;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataExportScriptConfiguration<T extends MetadataExport>
extends ScriptConfiguration<T> {
    @Autowired
    private AuthorizeService authorizeService;
    private Class<T> dspaceRunnableClass;

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }

    @Override
    public boolean isAllowedToExecute(Context context) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException occurred when checking if the current user is an admin", e);
        }
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            Options options = new Options();
            options.addOption("i", "id", true, "ID or handle of thing to export (item, collection, or community)");
            options.addOption("a", "all", false, "include all metadata fields that are not normally changed (e.g. provenance)");
            options.addOption("h", "help", false, "help");
            this.options = options;
        }
        return this.options;
    }
}

