/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import java.io.File;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.itemimport.ItemImport;
import org.dspace.app.itemimport.service.ItemImportService;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class ItemImportCLI
extends ItemImport {
    @Override
    protected void validate(Context context) {
        if (this.isResume && !"add".equals(this.command)) {
            this.handler.logError("Resume option only works with the --add command (run with -h flag for details)");
            throw new UnsupportedOperationException("Resume option only works with the --add command");
        }
        if (this.commandLine.hasOption('e')) {
            this.eperson = this.commandLine.getOptionValue('e');
        }
        if (this.eperson == null) {
            this.handler.logError("An eperson to do the importing must be specified (run with -h flag for details)");
            throw new UnsupportedOperationException("An eperson to do the importing must be specified");
        }
        File myFile = null;
        try {
            myFile = new File(this.mapfile);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("The mapfile " + this.mapfile + " does not exist");
        }
        if (!this.isResume && "add".equals(this.command) && myFile.exists()) {
            this.handler.logError("The mapfile " + this.mapfile + " already exists. Either delete it or use --resume if attempting to resume an aborted import. (run with -h flag for details)");
            throw new UnsupportedOperationException("The mapfile " + this.mapfile + " already exists");
        }
        if (this.command == null) {
            this.handler.logError("Must run with either add, replace, or remove (run with -h flag for details)");
            throw new UnsupportedOperationException("Must run with either add, replace, or remove");
        }
        if ("add".equals(this.command) || "replace".equals(this.command)) {
            if (this.sourcedir == null) {
                this.handler.logError("A source directory containing items must be set (run with -h flag for details)");
                throw new UnsupportedOperationException("A source directory containing items must be set");
            }
            if (this.mapfile == null) {
                this.handler.logError("A map file to hold importing results must be specified (run with -h flag for details)");
                throw new UnsupportedOperationException("A map file to hold importing results must be specified");
            }
        } else if ("delete".equals(this.command) && this.mapfile == null) {
            this.handler.logError("A map file must be specified (run with -h flag for details)");
            throw new UnsupportedOperationException("A map file must be specified");
        }
    }

    @Override
    protected void process(Context context, ItemImportService itemImportService, List<Collection> collections) throws Exception {
        if ("add".equals(this.command)) {
            itemImportService.addItems(context, collections, this.sourcedir, this.mapfile, this.template);
        } else if ("replace".equals(this.command)) {
            itemImportService.replaceItems(context, collections, this.sourcedir, this.mapfile, this.template);
        } else if ("delete".equals(this.command)) {
            itemImportService.deleteItems(context, this.mapfile);
        }
    }

    @Override
    protected void readZip(Context context, ItemImportService itemImportService) throws Exception {
        if (this.zip) {
            this.workDir = new File(itemImportService.getTempWorkDir() + File.separator + TEMP_DIR + File.separator + context.getCurrentUser().getID());
            this.sourcedir = itemImportService.unzip(new File(this.sourcedir + File.separator + this.zipfilename), this.workDir.getAbsolutePath());
        }
    }

    @Override
    protected void setMapFile() {
        if (this.commandLine.hasOption('m')) {
            this.mapfile = this.commandLine.getOptionValue('m');
        }
    }

    @Override
    protected void setZip() {
        if (this.commandLine.hasOption('s')) {
            this.sourcedir = this.commandLine.getOptionValue('s');
        }
        if (this.commandLine.hasOption('z')) {
            this.zip = true;
            this.zipfilename = this.commandLine.getOptionValue('z');
        }
    }

    @Override
    protected void setEPerson(Context context) throws SQLException {
        EPerson myEPerson = null;
        myEPerson = StringUtils.contains((CharSequence)this.eperson, (int)64) ? epersonService.findByEmail(context, this.eperson) : (EPerson)epersonService.find(context, UUID.fromString(this.eperson));
        if (myEPerson == null) {
            this.handler.logError("EPerson cannot be found: " + this.eperson + " (run with -h flag for details)");
            throw new UnsupportedOperationException("EPerson cannot be found: " + this.eperson);
        }
        context.setCurrentUser(myEPerson);
    }
}

