/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import java.io.InputStream;
import java.sql.SQLException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dspace.app.itemimport.ItemImport;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.springframework.beans.factory.annotation.Autowired;

public class ItemImportScriptConfiguration<T extends ItemImport>
extends ScriptConfiguration<T> {
    @Autowired
    private AuthorizeService authorizeService;
    private Class<T> dspaceRunnableClass;

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }

    @Override
    public boolean isAllowedToExecute(Context context) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException occurred when checking if the current user is an admin", e);
        }
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"a").longOpt("add").desc("add items to DSpace").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"r").longOpt("replace").desc("replace items in mapfile").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"d").longOpt("delete").desc("delete items listed in mapfile").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"z").longOpt("zip").desc("name of zip file").type(InputStream.class).hasArg().required().build());
        options.addOption(Option.builder((String)"c").longOpt("collection").desc("destination collection(s) Handle or database ID").hasArg().required(false).build());
        options.addOption(Option.builder((String)"m").longOpt("mapfile").desc("mapfile items in mapfile").type(InputStream.class).hasArg().required(false).build());
        options.addOption(Option.builder((String)"w").longOpt("workflow").desc("send submission through collection's workflow").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"n").longOpt("notify").desc("if sending submissions through the workflow, send notification emails").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"v").longOpt("validate").desc("test run - do not actually import items").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"x").longOpt("exclude-bitstreams").desc("do not load or expect content bitstreams").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"p").longOpt("template").desc("apply template").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"R").longOpt("resume").desc("resume a failed import (add only)").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"q").longOpt("quiet").desc("don't display metadata").hasArg(false).required(false).build());
        options.addOption(Option.builder((String)"h").longOpt("help").desc("help").hasArg(false).required(false).build());
        return options;
    }
}

