/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.requestitem.factory.RequestItemServiceFactory;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class RequestItemEmailNotifier {
    private static final Logger LOG = LogManager.getLogger();
    private static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private static final RequestItemService requestItemService = RequestItemServiceFactory.getInstance().getRequestItemService();
    private static final RequestItemAuthorExtractor requestItemAuthorExtractor = (RequestItemAuthorExtractor)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("requestItemAuthorExtractor", RequestItemAuthorExtractor.class);

    private RequestItemEmailNotifier() {
    }

    public static void sendRequest(Context context, RequestItem ri, String responseLink) throws IOException, SQLException {
        List<RequestItemAuthor> authors = requestItemAuthorExtractor.getRequestItemAuthor(context, ri.getItem());
        Email email = Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "request_item.author"));
        for (RequestItemAuthor author : authors) {
            email.addRecipient(author.getEmail());
        }
        email.setReplyTo(ri.getReqEmail());
        email.addArgument(ri.getReqName());
        email.addArgument(ri.getReqEmail());
        email.addArgument(ri.isAllfiles() ? I18nUtil.getMessage("itemRequest.all") : ri.getBitstream().getName());
        email.addArgument(handleService.getCanonicalForm(ri.getItem().getHandle()));
        email.addArgument(ri.getItem().getName());
        email.addArgument(ri.getReqMessage());
        email.addArgument(responseLink);
        StringBuilder names = new StringBuilder();
        StringBuilder addresses = new StringBuilder();
        for (RequestItemAuthor author : authors) {
            if (names.length() > 0) {
                names.append("; ");
                addresses.append("; ");
            }
            names.append(author.getFullName());
            addresses.append(author.getEmail());
        }
        email.addArgument(names.toString());
        email.addArgument(addresses.toString());
        email.addArgument(configurationService.getProperty("dspace.name"));
        email.addArgument(configurationService.getProperty("mail.helpdesk"));
        try {
            email.send();
            Bitstream bitstream = ri.getBitstream();
            String bitstreamID = null == bitstream ? "null" : ri.getBitstream().getID().toString();
            LOG.info(LogHelper.getHeader(context, "sent_email_requestItem", "submitter_id={},bitstream_id={},requestEmail={}"), (Object)ri.getReqEmail(), (Object)bitstreamID, (Object)ri.getReqEmail());
        }
        catch (MessagingException e) {
            LOG.warn(LogHelper.getHeader(context, "error_mailing_requestItem", e.getMessage()));
            throw new IOException("Request not sent:  " + e.getMessage());
        }
    }

    public static void sendResponse(Context context, RequestItem ri, String subject, String message) throws IOException {
        Email email = new Email();
        email.setContent("body", message);
        email.setSubject(subject);
        email.addRecipient(ri.getReqEmail());
        try {
            if (ri.isAccept_request()) {
                if (ri.isAllfiles()) {
                    Item item = ri.getItem();
                    List<Bundle> bundles = item.getBundles("ORIGINAL");
                    for (Bundle bundle : bundles) {
                        List<Bitstream> bitstreams = bundle.getBitstreams();
                        for (Bitstream bitstream : bitstreams) {
                            if (bitstream.getFormat(context).isInternal() || !requestItemService.isRestricted(context, bitstream)) continue;
                            email.addAttachment(bitstreamService.retrieve(context, bitstream), bitstream.getName(), bitstream.getFormat(context).getMIMEType());
                        }
                    }
                } else {
                    Bitstream bitstream = ri.getBitstream();
                    email.addAttachment(bitstreamService.retrieve(context, bitstream), bitstream.getName(), bitstream.getFormat(context).getMIMEType());
                }
                email.send();
            } else {
                boolean sendRejectEmail = configurationService.getBooleanProperty("request.item.reject.email", true);
                if (sendRejectEmail) {
                    email.send();
                }
            }
        }
        catch (IOException | SQLException | MessagingException | AuthorizeException e) {
            LOG.warn(LogHelper.getHeader(context, "error_mailing_requestItem", e.getMessage()));
            throw new IOException("Reply not sent:  " + e.getMessage());
        }
        LOG.info(LogHelper.getHeader(context, "sent_attach_requestItem", "token={}"), (Object)ri.getToken());
    }

    public static void requestOpenAccess(Context context, RequestItem ri) throws IOException {
        Email message = Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "request_item.admin"));
        Bitstream bitstream = ri.getBitstream();
        String bitstreamName = bitstream != null ? bitstream.getName() : "all";
        Item item = ri.getItem();
        EPerson approver = context.getCurrentUser();
        message.addArgument(bitstreamName);
        message.addArgument(item.getHandle());
        message.addArgument(ri.getToken());
        if (approver != null) {
            message.addArgument(approver.getFullName());
            message.addArgument(approver.getEmail());
        } else {
            message.addArgument("anonymous approver");
            message.addArgument(configurationService.getProperty("mail.admin"));
        }
        EPerson submitter = item.getSubmitter();
        String recipient = submitter != null ? submitter.getEmail() : configurationService.getProperty("mail.helpdesk");
        if (null == recipient) {
            recipient = configurationService.getProperty("mail.admin");
        }
        message.addRecipient(recipient);
        try {
            message.send();
        }
        catch (MessagingException ex) {
            LOG.warn(LogHelper.getHeader(context, "error_mailing_requestItem", ex.getMessage()));
            throw new IOException("Open Access request not sent:  " + ex.getMessage());
        }
    }
}

