/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sfx;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sfx.service.SFXFileReaderService;
import org.dspace.content.DCPersonName;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SFXFileReaderServiceImpl
implements SFXFileReaderService {
    protected Document doc;
    @Autowired(required=true)
    protected ItemService itemService;
    private final Logger log = LogManager.getLogger(SFXFileReaderServiceImpl.class);

    protected SFXFileReaderServiceImpl() {
    }

    @Override
    public String loadSFXFile(String fileName, Item item) throws IOException {
        if (this.doc == null) {
            this.doc = this.parseFile(fileName);
        }
        return this.doNodes(this.doc, item);
    }

    @Override
    public Document parseFile(String fileName) {
        DocumentBuilder docBuilder;
        this.log.info("Parsing XML file... " + fileName);
        Document doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.log.error("Wrong parser configuration: " + e.getMessage());
            return null;
        }
        File sourceFile = new File(fileName);
        try {
            doc = docBuilder.parse(sourceFile);
        }
        catch (SAXException e) {
            this.log.error("Wrong XML file structure: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            this.log.error("Could not read source file: " + e.getMessage());
        }
        this.log.info("XML file parsed");
        return doc;
    }

    @Override
    public String doNodes(Node node, Item item) throws IOException {
        if (node == null) {
            this.log.error(" Empty Node ");
            return null;
        }
        Node e = this.getElement(node);
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        String sfxfield = "";
        int i = 0;
        while (i < len && StringUtils.isEmpty((CharSequence)sfxfield)) {
            Node nd = nl.item(i);
            if (nd == null || this.isEmptyTextNode(nd)) {
                ++i;
                continue;
            }
            String tagName = nd.getNodeName();
            if (tagName.equals("query-pairs")) {
                sfxfield = this.processFields(nd, item);
            }
            ++i;
        }
        this.log.info("Process fields : " + sfxfield);
        return sfxfield;
    }

    protected String processFields(Node e, Item item) throws IOException {
        NodeList cl = e.getChildNodes();
        int lench = cl.getLength();
        Object myquery = "";
        for (int j = 0; j < lench; ++j) {
            Node nch = cl.item(j);
            String querystring = "";
            String schema = "";
            String qualifier = "";
            String element = "";
            if (!nch.getNodeName().equals("field")) continue;
            NodeList pl = nch.getChildNodes();
            int plen = pl.getLength();
            int finish = 0;
            for (int k = 0; k < plen; ++k) {
                Node vn = pl.item(k);
                String vName = vn.getNodeName();
                if (vName.equals("querystring")) {
                    querystring = this.getValue(vn);
                    ++finish;
                } else if (vName.equals("dc-schema")) {
                    schema = this.getValue(vn);
                    ++finish;
                } else if (vName.equals("dc-element")) {
                    element = this.getValue(vn);
                    ++finish;
                } else if (vName.equals("dc-qualifier")) {
                    qualifier = this.getValue(vn);
                    ++finish;
                    if (StringUtils.isEmpty((CharSequence)qualifier)) {
                        qualifier = null;
                    }
                }
                if (finish != 4) continue;
                List<MetadataValue> dcvalue = this.itemService.getMetadata(item, schema, element, qualifier, "*");
                if (dcvalue.size() > 0) {
                    if (element.equals("date") && qualifier.equals("issued")) {
                        String fullDate = dcvalue.get(0).getValue();
                        if (fullDate.length() > 10) {
                            fullDate = fullDate.substring(0, 10);
                        }
                        myquery = ((String)myquery).equals("") ? querystring + URLEncoder.encode(fullDate, "UTF-8") : (String)myquery + "&" + querystring + URLEncoder.encode(fullDate, "UTF-8");
                    } else if (element.equals("contributor") && qualifier.equals("author")) {
                        DCPersonName dpn = new DCPersonName(dcvalue.get(0).getValue());
                        String dpnName = dcvalue.get(0).getValue();
                        if (querystring.endsWith("aulast=")) {
                            dpnName = dpn.getLastName();
                        } else if (querystring.endsWith("aufirst=")) {
                            dpnName = dpn.getFirstNames();
                        }
                        myquery = ((String)myquery).equals("") ? querystring + URLEncoder.encode(dpnName, "UTF-8") : (String)myquery + "&" + querystring + URLEncoder.encode(dpnName, "UTF-8");
                    } else {
                        myquery = ((String)myquery).equals("") ? querystring + URLEncoder.encode(dcvalue.get(0).getValue(), "UTF-8") : (String)myquery + "&" + querystring + URLEncoder.encode(dcvalue.get(0).getValue(), "UTF-8");
                    }
                }
                finish = 0;
                querystring = "";
                schema = "";
                element = "";
                qualifier = "";
            }
        }
        return myquery;
    }

    @Override
    public Node getElement(Node node) {
        NodeList child = node.getChildNodes();
        int length = child.getLength();
        for (int i = 0; i < length; ++i) {
            Node kid = child.item(i);
            if (kid.getNodeType() != 1) continue;
            return kid;
        }
        return null;
    }

    @Override
    public boolean isEmptyTextNode(Node nd) {
        String text;
        boolean isEmpty = false;
        if (nd.getNodeType() == 3 && (text = nd.getNodeValue().trim()).length() == 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    @Override
    public String getAttribute(Node e, String name) {
        NamedNodeMap attrs = e.getAttributes();
        int len = attrs.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node attr = attrs.item(i);
                if (!name.equals(attr.getNodeName())) continue;
                return attr.getNodeValue().trim();
            }
        }
        return null;
    }

    @Override
    public String getValue(Node node) {
        NodeList child = node.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            Node kid = child.item(i);
            short type = kid.getNodeType();
            if (type != 3) continue;
            return kid.getNodeValue().trim();
        }
        return null;
    }
}

