/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate.oidc.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.dspace.authenticate.oidc.OidcClient;
import org.dspace.authenticate.oidc.OidcClientException;
import org.dspace.authenticate.oidc.model.OidcTokenResponseDTO;
import org.dspace.services.ConfigurationService;
import org.dspace.util.ThrowingSupplier;
import org.springframework.beans.factory.annotation.Autowired;

public class OidcClientImpl
implements OidcClient {
    @Autowired
    private ConfigurationService configurationService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @PostConstruct
    private void setup() {
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    @Override
    public OidcTokenResponseDTO getAccessToken(String code) throws OidcClientException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("code", code));
        params.add(new BasicNameValuePair("grant_type", "authorization_code"));
        params.add(new BasicNameValuePair("client_id", this.getClientId()));
        params.add(new BasicNameValuePair("client_secret", this.getClientSecret()));
        params.add(new BasicNameValuePair("redirect_uri", this.getRedirectUrl()));
        HttpUriRequest httpUriRequest = RequestBuilder.post((String)this.getTokenEndpointUrl()).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Accept", "application/json").setEntity((HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset())).build();
        return this.executeAndParseJson(httpUriRequest, OidcTokenResponseDTO.class);
    }

    @Override
    public Map<String, Object> getUserInfo(String accessToken) throws OidcClientException {
        HttpUriRequest httpUriRequest = RequestBuilder.get((String)this.getUserInfoEndpointUrl()).addHeader("Authorization", "Bearer " + accessToken).build();
        return this.executeAndParseJson(httpUriRequest, Map.class);
    }

    private <T> T executeAndParseJson(HttpUriRequest httpUriRequest, Class<T> clazz) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        return (T)this.executeAndReturns(() -> this.lambda$executeAndParseJson$0((HttpClient)client, httpUriRequest, clazz));
    }

    private <T> T executeAndReturns(ThrowingSupplier<T, Exception> supplier) {
        try {
            return supplier.get();
        }
        catch (OidcClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OidcClientException(ex);
        }
    }

    private String formatErrorMessage(HttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
        }
        catch (IOException | UnsupportedOperationException e) {
            return "Generic error";
        }
    }

    private boolean isNotSuccessfull(HttpResponse response) {
        int statusCode = this.getStatusCode(response);
        return statusCode < 200 || statusCode > 299;
    }

    private int getStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private String getContent(HttpResponse response) throws UnsupportedOperationException, IOException {
        HttpEntity entity = response.getEntity();
        return entity != null ? IOUtils.toString((InputStream)entity.getContent(), (String)StandardCharsets.UTF_8.name()) : null;
    }

    private String getClientId() {
        return this.configurationService.getProperty("authentication-oidc.client-id");
    }

    private String getClientSecret() {
        return this.configurationService.getProperty("authentication-oidc.client-secret");
    }

    private String getTokenEndpointUrl() {
        return this.configurationService.getProperty("authentication-oidc.token-endpoint");
    }

    private String getUserInfoEndpointUrl() {
        return this.configurationService.getProperty("authentication-oidc.user-info-endpoint");
    }

    private String getRedirectUrl() {
        return this.configurationService.getProperty("authentication-oidc.redirect-url");
    }

    private /* synthetic */ Object lambda$executeAndParseJson$0(HttpClient client, HttpUriRequest httpUriRequest, Class clazz) throws Exception {
        HttpResponse response = client.execute(httpUriRequest);
        if (this.isNotSuccessfull(response)) {
            throw new OidcClientException(this.getStatusCode(response), this.formatErrorMessage(response));
        }
        return this.objectMapper.readValue(this.getContent(response), clazz);
    }
}

