/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.workflow.WorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorizeServiceImpl
implements AuthorizeService {
    private static final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ContentServiceFactory serviceFactory;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected WorkflowItemService workflowItemService;
    @Autowired(required=true)
    private SearchService searchService;

    protected AuthorizeServiceImpl() {
    }

    @Override
    public void authorizeAnyOf(Context c, DSpaceObject o, int[] actions) throws AuthorizeException, SQLException {
        AuthorizeException ex = null;
        for (int action : actions) {
            try {
                this.authorizeAction(c, o, action);
                return;
            }
            catch (AuthorizeException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        throw ex;
    }

    @Override
    public void authorizeAction(Context c, DSpaceObject o, int action) throws AuthorizeException, SQLException {
        this.authorizeAction(c, o, action, true);
    }

    @Override
    public void authorizeAction(Context c, DSpaceObject o, int action, boolean useInheritance) throws AuthorizeException, SQLException {
        this.authorizeAction(c, c.getCurrentUser(), o, action, useInheritance);
    }

    @Override
    public void authorizeAction(Context c, EPerson e, DSpaceObject o, int action, boolean useInheritance) throws AuthorizeException, SQLException {
        if (o == null) {
            String actionText = action == -1 ? "null" : Constants.actionText[action];
            UUID userid = e == null ? null : e.getID();
            throw new AuthorizeException("Authorization attempted on null DSpace object " + actionText + " by user " + userid);
        }
        if (!this.authorize(c, o, action, e, useInheritance)) {
            int otype = o.getType();
            UUID oid = o.getID();
            UUID userid = e == null ? null : e.getID();
            String actionText = action == -1 ? "null" : Constants.actionText[action];
            throw new AuthorizeException("Authorization denied for action " + actionText + " on " + Constants.typeText[otype] + ":" + oid + " by user " + userid, o, action);
        }
    }

    @Override
    public boolean authorizeActionBoolean(Context c, DSpaceObject o, int a) throws SQLException {
        return this.authorizeActionBoolean(c, o, a, true);
    }

    @Override
    public boolean authorizeActionBoolean(Context c, DSpaceObject o, int a, boolean useInheritance) throws SQLException {
        boolean isAuthorized = true;
        if (o == null) {
            return false;
        }
        try {
            this.authorizeAction(c, o, a, useInheritance);
        }
        catch (AuthorizeException e) {
            isAuthorized = false;
        }
        return isAuthorized;
    }

    @Override
    public boolean authorizeActionBoolean(Context c, EPerson e, DSpaceObject o, int a, boolean useInheritance) throws SQLException {
        boolean isAuthorized = true;
        if (o == null) {
            return false;
        }
        try {
            this.authorizeAction(c, e, o, a, useInheritance);
        }
        catch (AuthorizeException ex) {
            isAuthorized = false;
        }
        return isAuthorized;
    }

    protected boolean authorize(Context c, DSpaceObject o, int action, EPerson e, boolean useInheritance) throws SQLException {
        Object b;
        DSpaceObject parent;
        if (o == null) {
            return false;
        }
        if (c.ignoreAuthorization()) {
            return true;
        }
        Boolean cachedResult = c.getCachedAuthorizationResult(o, action, e);
        if (cachedResult != null) {
            return cachedResult;
        }
        EPerson userToCheck = null;
        if (e != null) {
            userToCheck = e;
            if (this.isAdmin(c, e)) {
                return true;
            }
        }
        boolean ignoreCustomPolicies = false;
        if (o instanceof Bitstream && !((parent = this.bitstreamService.getParentObject(c, b = (Bitstream)o)) instanceof Collection) && !(parent instanceof Community)) {
            boolean bl = ignoreCustomPolicies = !this.isAnyItemInstalled(c, ((Bitstream)b).getBundles());
        }
        if (o instanceof Bundle) {
            boolean bl = ignoreCustomPolicies = !this.isAnyItemInstalled(c, Arrays.asList((Bundle)o));
        }
        if (o instanceof Item && !((Item)o).isArchived() && (this.workspaceItemService.findByItem(c, (Item)o) != null || this.workflowItemService.findByItem(c, (Item)o) != null)) {
            ignoreCustomPolicies = true;
        }
        for (ResourcePolicy rp : this.getPoliciesActionFilter(c, o, action)) {
            if (ignoreCustomPolicies && ResourcePolicy.TYPE_CUSTOM.equals(rp.getRpType())) {
                if (!c.isReadOnly()) continue;
                c.uncacheEntity(rp);
                continue;
            }
            if (this.resourcePolicyService.isDateValid(rp)) {
                if (rp.getEPerson() != null && rp.getEPerson().equals(userToCheck)) {
                    c.cacheAuthorizedAction(o, action, e, true, rp);
                    return true;
                }
                if (rp.getGroup() != null && this.groupService.isMember(c, e, rp.getGroup())) {
                    c.cacheAuthorizedAction(o, action, e, true, rp);
                    return true;
                }
            }
            if (!c.isReadOnly()) continue;
            c.uncacheEntity(rp);
        }
        if (e != null) {
            DSpaceObject adminObject;
            DSpaceObject dSpaceObject = adminObject = useInheritance ? this.serviceFactory.getDSpaceObjectService(o).getAdminObject(c, o, action) : null;
            if (this.isAdmin(c, e, adminObject)) {
                c.cacheAuthorizedAction(o, action, e, true, null);
                return true;
            }
        }
        c.cacheAuthorizedAction(o, action, e, false, null);
        return false;
    }

    protected boolean isAnyItemInstalled(Context ctx, List<Bundle> bundles) throws SQLException {
        for (Bundle bundle : bundles) {
            for (Item item : bundle.getItems()) {
                if (this.workspaceItemService.findByItem(ctx, item) != null || this.workflowItemService.findByItem(ctx, item) != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAdmin(Context c, DSpaceObject o) throws SQLException {
        return this.isAdmin(c, c.getCurrentUser(), o);
    }

    @Override
    public boolean isAdmin(Context c, EPerson e, DSpaceObject o) throws SQLException {
        if (this.isAdmin(c, e)) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Boolean cachedResult = c.getCachedAuthorizationResult(o, 11, e);
        if (cachedResult != null) {
            return cachedResult;
        }
        List<ResourcePolicy> policies = this.getPoliciesActionFilter(c, o, 11);
        for (ResourcePolicy rp : policies) {
            if (this.resourcePolicyService.isDateValid(rp)) {
                if (rp.getEPerson() != null && rp.getEPerson().equals(e)) {
                    c.cacheAuthorizedAction(o, 11, e, true, rp);
                    return true;
                }
                if (rp.getGroup() != null && this.groupService.isMember(c, e, rp.getGroup())) {
                    c.cacheAuthorizedAction(o, 11, e, true, rp);
                    return true;
                }
            }
            if (!c.isReadOnly()) continue;
            c.uncacheEntity(rp);
        }
        DSpaceObject parent = this.serviceFactory.getDSpaceObjectService(o).getParentObject(c, o);
        if (parent != null) {
            boolean admin = this.isAdmin(c, e, parent);
            c.cacheAuthorizedAction(o, 11, e, admin, null);
            return admin;
        }
        c.cacheAuthorizedAction(o, 11, e, false, null);
        return false;
    }

    @Override
    public boolean isAdmin(Context c) throws SQLException {
        if (c.ignoreAuthorization()) {
            return true;
        }
        EPerson e = c.getCurrentUser();
        if (e == null) {
            return false;
        }
        return this.groupService.isMember(c, "Administrator");
    }

    @Override
    public boolean isAdmin(Context c, EPerson e) throws SQLException {
        if (c.ignoreAuthorization()) {
            return true;
        }
        if (e == null) {
            return false;
        }
        return this.groupService.isMember(c, e, "Administrator");
    }

    @Override
    public void addPolicy(Context c, DSpaceObject o, int actionID, EPerson e) throws SQLException, AuthorizeException {
        this.addPolicy(c, o, actionID, e, null);
    }

    @Override
    public void addPolicy(Context context, DSpaceObject o, int actionID, EPerson e, String type) throws SQLException, AuthorizeException {
        this.createResourcePolicy(context, o, null, e, actionID, type);
    }

    @Override
    public void addPolicy(Context c, DSpaceObject o, int actionID, Group g) throws SQLException, AuthorizeException {
        this.createResourcePolicy(c, o, g, null, actionID, null);
    }

    @Override
    public void addPolicy(Context c, DSpaceObject o, int actionID, Group g, String type) throws SQLException, AuthorizeException {
        this.createResourcePolicy(c, o, g, null, actionID, type);
    }

    @Override
    public List<ResourcePolicy> getPolicies(Context c, DSpaceObject o) throws SQLException {
        return this.resourcePolicyService.find(c, o);
    }

    @Override
    public List<ResourcePolicy> findPoliciesByDSOAndType(Context c, DSpaceObject o, String type) throws SQLException {
        return this.resourcePolicyService.find(c, o, type);
    }

    @Override
    public List<ResourcePolicy> getPoliciesForGroup(Context c, Group g) throws SQLException {
        return this.resourcePolicyService.find(c, g);
    }

    @Override
    public List<ResourcePolicy> getPoliciesActionFilter(Context c, DSpaceObject o, int actionID) throws SQLException {
        return this.resourcePolicyService.find(c, o, actionID);
    }

    @Override
    public void inheritPolicies(Context c, DSpaceObject src, DSpaceObject dest) throws SQLException, AuthorizeException {
        List<ResourcePolicy> policies = this.getPolicies(c, src);
        ArrayList<ResourcePolicy> nonAdminPolicies = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy rp : policies) {
            if (rp.getAction() == 11 || StringUtils.equals((CharSequence)rp.getRpType(), (CharSequence)ResourcePolicy.TYPE_CUSTOM)) continue;
            nonAdminPolicies.add(rp);
        }
        this.addPolicies(c, nonAdminPolicies, dest);
    }

    @Override
    public void replaceAllPolicies(Context context, DSpaceObject source, DSpaceObject dest) throws SQLException, AuthorizeException {
        List<ResourcePolicy> policies = this.getPolicies(context, source);
        this.removeAllPolicies(context, dest);
        this.addPolicies(context, policies, dest);
    }

    @Override
    public void switchPoliciesAction(Context context, DSpaceObject dso, int fromAction, int toAction) throws SQLException, AuthorizeException {
        List<ResourcePolicy> rps = this.getPoliciesActionFilter(context, dso, fromAction);
        for (ResourcePolicy rp : rps) {
            rp.setAction(toAction);
        }
        this.resourcePolicyService.update(context, rps);
    }

    @Override
    public void addPolicies(Context c, List<ResourcePolicy> policies, DSpaceObject dest) throws SQLException, AuthorizeException {
        ArrayList<ResourcePolicy> newPolicies = new ArrayList<ResourcePolicy>(policies.size());
        for (ResourcePolicy srp : policies) {
            ResourcePolicy rp = (ResourcePolicy)this.resourcePolicyService.create(c);
            rp.setdSpaceObject(dest);
            rp.setAction(srp.getAction());
            rp.setEPerson(srp.getEPerson());
            rp.setGroup(srp.getGroup());
            rp.setStartDate(srp.getStartDate());
            rp.setEndDate(srp.getEndDate());
            rp.setRpName(srp.getRpName());
            rp.setRpDescription(srp.getRpDescription());
            rp.setRpType(srp.getRpType());
            newPolicies.add(rp);
        }
        this.resourcePolicyService.update(c, newPolicies);
    }

    @Override
    public void removeAllPolicies(Context c, DSpaceObject o) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeAllPolicies(c, o);
    }

    @Override
    public void removeAllPoliciesByDSOAndTypeNotEqualsTo(Context c, DSpaceObject o, String type) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeDsoAndTypeNotEqualsToPolicies(c, o, type);
    }

    @Override
    public void removeAllPoliciesByDSOAndType(Context c, DSpaceObject o, String type) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removePolicies(c, o, type);
    }

    @Override
    public void removePoliciesActionFilter(Context context, DSpaceObject dso, int actionID) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removePolicies(context, dso, actionID);
    }

    @Override
    public void removeGroupPolicies(Context c, Group group) throws SQLException {
        this.resourcePolicyService.removeGroupPolicies(c, group);
    }

    @Override
    public void removeGroupPolicies(Context c, DSpaceObject o, Group g) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeDsoGroupPolicies(c, o, g);
    }

    @Override
    public void removeEPersonPolicies(Context c, DSpaceObject o, EPerson e) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeDsoEPersonPolicies(c, o, e);
    }

    @Override
    public void removeAllEPersonPolicies(Context c, EPerson e) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeAllEPersonPolicies(c, e);
    }

    @Override
    public List<Group> getAuthorizedGroups(Context c, DSpaceObject o, int actionID) throws SQLException {
        List<ResourcePolicy> policies = this.getPoliciesActionFilter(c, o, actionID);
        ArrayList<Group> groups = new ArrayList<Group>();
        for (ResourcePolicy resourcePolicy : policies) {
            if (resourcePolicy.getGroup() == null || !this.resourcePolicyService.isDateValid(resourcePolicy)) continue;
            groups.add(resourcePolicy.getGroup());
        }
        return groups;
    }

    @Override
    public boolean isAnIdenticalPolicyAlreadyInPlace(Context c, DSpaceObject o, ResourcePolicy rp) throws SQLException {
        return this.isAnIdenticalPolicyAlreadyInPlace(c, o, rp.getGroup(), rp.getAction(), rp.getID());
    }

    @Override
    public boolean isAnIdenticalPolicyAlreadyInPlace(Context c, DSpaceObject dso, Group group, int action, int policyID) throws SQLException {
        return !this.resourcePolicyService.findByTypeGroupActionExceptId(c, dso, group, action, policyID).isEmpty();
    }

    @Override
    public ResourcePolicy findByTypeGroupAction(Context c, DSpaceObject dso, Group group, int action) throws SQLException {
        List<ResourcePolicy> policies = this.resourcePolicyService.find(c, dso, group, action);
        if (CollectionUtils.isNotEmpty(policies)) {
            return policies.iterator().next();
        }
        return null;
    }

    @Override
    public void generateAutomaticPolicies(Context context, Date embargoDate, String reason, DSpaceObject dso, Collection owningCollection) throws SQLException, AuthorizeException {
        if (embargoDate != null || embargoDate == null && dso instanceof Bitstream) {
            List<Group> authorizedGroups = this.getAuthorizedGroups(context, owningCollection, 10);
            this.removeAllPoliciesByDSOAndType(context, dso, ResourcePolicy.TYPE_CUSTOM);
            boolean isAnonymousInPlace = false;
            for (Group g : authorizedGroups) {
                if (!StringUtils.equals((CharSequence)g.getName(), (CharSequence)"Anonymous")) continue;
                isAnonymousInPlace = true;
            }
            if (!isAnonymousInPlace) {
                for (Group g : authorizedGroups) {
                    ResourcePolicy rp = this.createOrModifyPolicy(null, context, null, g, null, embargoDate, 0, reason, dso);
                    if (rp == null) continue;
                    this.resourcePolicyService.update(context, rp);
                }
            } else {
                ResourcePolicy rp = this.createOrModifyPolicy(null, context, null, this.groupService.findByName(context, "Anonymous"), null, embargoDate, 0, reason, dso);
                if (rp != null) {
                    this.resourcePolicyService.update(context, rp);
                }
            }
        }
    }

    @Override
    public ResourcePolicy createResourcePolicy(Context context, DSpaceObject dso, Group group, EPerson eperson, int type, String rpType) throws SQLException, AuthorizeException {
        return this.createResourcePolicy(context, dso, group, eperson, type, rpType, null, null, null, null);
    }

    @Override
    public ResourcePolicy createResourcePolicy(Context context, DSpaceObject dso, Group group, EPerson eperson, int type, String rpType, String rpName, String rpDescription, Date startDate, Date endDate) throws SQLException, AuthorizeException {
        if (group == null && eperson == null) {
            throw new IllegalArgumentException("We need at least an eperson or a group in order to create a resource policy.");
        }
        ResourcePolicy myPolicy = (ResourcePolicy)this.resourcePolicyService.create(context);
        myPolicy.setdSpaceObject(dso);
        myPolicy.setAction(type);
        myPolicy.setGroup(group);
        myPolicy.setEPerson(eperson);
        myPolicy.setRpType(rpType);
        myPolicy.setRpName(rpName);
        myPolicy.setRpDescription(rpDescription);
        myPolicy.setEndDate(endDate);
        myPolicy.setStartDate(startDate);
        this.resourcePolicyService.update(context, myPolicy);
        return myPolicy;
    }

    @Override
    public ResourcePolicy createOrModifyPolicy(ResourcePolicy policy, Context context, String name, Group group, EPerson ePerson, Date embargoDate, int action, String reason, DSpaceObject dso) throws AuthorizeException, SQLException {
        ResourcePolicy policyTemp = null;
        if (policy != null) {
            List<ResourcePolicy> duplicates = this.resourcePolicyService.findByTypeGroupActionExceptId(context, dso, group, action, policy.getID());
            if (!duplicates.isEmpty()) {
                policy = duplicates.get(0);
            }
        } else {
            policyTemp = this.findByTypeGroupAction(context, dso, group, action);
        }
        if (policyTemp != null) {
            policy = policyTemp;
            policy.setRpType(ResourcePolicy.TYPE_CUSTOM);
        }
        if (policy == null) {
            policy = this.createResourcePolicy(context, dso, group, ePerson, action, ResourcePolicy.TYPE_CUSTOM);
        }
        policy.setGroup(group);
        policy.setEPerson(ePerson);
        if (embargoDate != null) {
            policy.setStartDate(embargoDate);
        } else {
            policy.setStartDate(null);
            policy.setEndDate(null);
        }
        policy.setRpName(name);
        policy.setRpDescription(reason);
        return policy;
    }

    @Override
    public List<ResourcePolicy> getPoliciesActionFilterExceptRpType(Context c, DSpaceObject o, int actionID, String rpType) throws SQLException {
        return this.resourcePolicyService.findExceptRpType(c, o, actionID, rpType);
    }

    @Override
    public boolean isCommunityAdmin(Context context) throws SQLException {
        return this.performCheck(context, "search.resourcetype:" + IndexableCommunity.TYPE);
    }

    @Override
    public boolean isCollectionAdmin(Context context) throws SQLException {
        return this.performCheck(context, "search.resourcetype:" + IndexableCollection.TYPE);
    }

    @Override
    public boolean isComColAdmin(Context context) throws SQLException {
        return this.performCheck(context, "(search.resourcetype:" + IndexableCommunity.TYPE + " OR search.resourcetype:" + IndexableCollection.TYPE + ")");
    }

    @Override
    public List<Community> findAdminAuthorizedCommunity(Context context, String query, int offset, int limit) throws SearchServiceException, SQLException {
        ArrayList<Community> communities = new ArrayList<Community>();
        query = this.formatCustomQuery(query);
        DiscoverResult discoverResult = this.getDiscoverResult(context, query + "search.resourcetype:" + IndexableCommunity.TYPE, offset, limit, null, null);
        for (IndexableObject solrCollections : discoverResult.getIndexableObjects()) {
            Community community = (Community)((IndexableCommunity)solrCollections).getIndexedObject();
            communities.add(community);
        }
        return communities;
    }

    @Override
    public long countAdminAuthorizedCommunity(Context context, String query) throws SearchServiceException, SQLException {
        query = this.formatCustomQuery(query);
        DiscoverResult discoverResult = this.getDiscoverResult(context, query + "search.resourcetype:" + IndexableCommunity.TYPE, null, null, null, null);
        return discoverResult.getTotalSearchResults();
    }

    @Override
    public List<Collection> findAdminAuthorizedCollection(Context context, String query, int offset, int limit) throws SearchServiceException, SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        if (context.getCurrentUser() == null) {
            return collections;
        }
        query = this.formatCustomQuery(query);
        DiscoverResult discoverResult = this.getDiscoverResult(context, query + "search.resourcetype:" + IndexableCollection.TYPE, offset, limit, "dc.title_sort", DiscoverQuery.SORT_ORDER.asc);
        for (IndexableObject solrCollections : discoverResult.getIndexableObjects()) {
            Collection collection = (Collection)((IndexableCollection)solrCollections).getIndexedObject();
            collections.add(collection);
        }
        return collections;
    }

    @Override
    public long countAdminAuthorizedCollection(Context context, String query) throws SearchServiceException, SQLException {
        query = this.formatCustomQuery(query);
        DiscoverResult discoverResult = this.getDiscoverResult(context, query + "search.resourcetype:" + IndexableCollection.TYPE, null, null, null, null);
        return discoverResult.getTotalSearchResults();
    }

    @Override
    public boolean isAccountManager(Context context) {
        try {
            return AuthorizeUtil.canCommunityAdminManageAccounts() && this.isCommunityAdmin(context) || AuthorizeUtil.canCollectionAdminManageAccounts() && this.isCollectionAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean performCheck(Context context, String query) throws SQLException {
        if (context.getCurrentUser() == null) {
            return false;
        }
        try {
            DiscoverResult discoverResult = this.getDiscoverResult(context, query, null, null, null, null);
            if (discoverResult.getTotalSearchResults() > 0L) {
                return true;
            }
        }
        catch (SearchServiceException e) {
            log.error("Failed getting getting community/collection admin status for " + context.getCurrentUser().getEmail() + " The search error is: " + e.getMessage() + " The search resourceType filter was: " + query);
        }
        return false;
    }

    private DiscoverResult getDiscoverResult(Context context, String query, Integer offset, Integer limit, String sortField, DiscoverQuery.SORT_ORDER sortOrder) throws SearchServiceException, SQLException {
        String groupQuery = this.getGroupToQuery(this.groupService.allMemberGroups(context, context.getCurrentUser()));
        DiscoverQuery discoverQuery = new DiscoverQuery();
        if (!this.isAdmin(context)) {
            query = (String)query + " AND (admin:e" + context.getCurrentUser().getID() + groupQuery + ")";
        }
        discoverQuery.setQuery((String)query);
        if (offset != null) {
            discoverQuery.setStart(offset);
        }
        if (limit != null) {
            discoverQuery.setMaxResults(limit);
        }
        if (sortField != null && sortOrder != null) {
            discoverQuery.setSortField(sortField, sortOrder);
        }
        return this.searchService.search(context, discoverQuery);
    }

    private String getGroupToQuery(List<Group> groups) {
        StringBuilder groupQuery = new StringBuilder();
        if (groups != null) {
            for (Group group : groups) {
                groupQuery.append(" OR admin:g");
                groupQuery.append(group.getID());
            }
        }
        return groupQuery.toString();
    }

    private String formatCustomQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return "";
        }
        return query + " AND ";
    }
}

