/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="bundle")
public class Bundle
extends DSpaceObject
implements DSpaceObjectLegacySupport {
    @Column(name="bundle_id", insertable=false, updatable=false)
    private Integer legacyId;
    @OneToOne
    @JoinColumn(name="primary_bitstream_id")
    private Bitstream primaryBitstream;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="bundle2bitstream", joinColumns={@JoinColumn(name="bundle_id")}, inverseJoinColumns={@JoinColumn(name="bitstream_id")})
    @OrderColumn(name="bitstream_order")
    private final List<Bitstream> bitstreams = new ArrayList<Bitstream>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="item2bundle", joinColumns={@JoinColumn(name="bundle_id", referencedColumnName="uuid")}, inverseJoinColumns={@JoinColumn(name="item_id", referencedColumnName="uuid")})
    private final List<Item> items = new ArrayList<Item>();
    @Transient
    protected transient BundleService bundleService;

    protected Bundle() {
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    @Override
    public String getName() {
        return this.getBundleService().getMetadataFirstValue(this, MetadataSchemaEnum.DC.getName(), "title", null, "*");
    }

    public void setName(Context context, String name) throws SQLException {
        this.getBundleService().setMetadataSingleValue(context, this, MetadataSchemaEnum.DC.getName(), "title", null, null, name);
    }

    public Bitstream getPrimaryBitstream() {
        return this.primaryBitstream;
    }

    public void setPrimaryBitstreamID(Bitstream bitstream) {
        this.primaryBitstream = bitstream;
        this.setModified();
    }

    public void unsetPrimaryBitstreamID() {
        this.primaryBitstream = null;
    }

    public List<Bitstream> getBitstreams() {
        ArrayList<Bitstream> bitstreamList = new ArrayList<Bitstream>(this.bitstreams);
        return bitstreamList;
    }

    void addBitstream(Bitstream bitstream) {
        this.bitstreams.add(bitstream);
    }

    public void clearBitstreams() {
        this.bitstreams.clear();
    }

    public void removeBitstream(Bitstream bitstream) {
        this.bitstreams.remove(bitstream);
    }

    public List<Item> getItems() {
        return this.items;
    }

    void removeItem(Item item) {
        this.getItems().remove(item);
    }

    void addItem(Item item) {
        this.getItems().add(item);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Bundle)) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
        if (this.getClass() != objClass) {
            return false;
        }
        Bundle other = (Bundle)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getID().equals(other.getID());
    }

    public int hashCode() {
        int hash = 5;
        hash += 71 * hash + this.getType();
        hash += 71 * hash + this.getID().hashCode();
        return hash;
    }

    @Override
    public int getType() {
        return 1;
    }

    private BundleService getBundleService() {
        if (this.bundleService == null) {
            this.bundleService = ContentServiceFactory.getInstance().getBundleService();
        }
        return this.bundleService;
    }
}

