/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class METSRightsCrosswalk
implements IngestionCrosswalk,
DisseminationCrosswalk {
    private static Logger log = LogManager.getLogger(METSRightsCrosswalk.class);
    private static final Namespace METSRights_NS = Namespace.getNamespace((String)"rights", (String)"http://cosimo.stanford.edu/sdr/metsrights/");
    private String schemaLocation = METSRights_NS.getURI() + " http://cosimo.stanford.edu/sdr/metsrights.xsd";
    private static final Namespace[] namespaces = new Namespace[]{METSRights_NS};
    private static final Map<Integer, String> otherTypesMapping = new HashMap<Integer, String>();
    private static final String GROUP_CONTEXTCLASS = "MANAGED GRP";
    private static final String PERSON_CONTEXTCLASS = "ACADEMIC USER";
    private static final String ANONYMOUS_CONTEXTCLASS = "GENERAL PUBLIC";
    private static final String ADMIN_CONTEXTCLASS = "REPOSITORY MGR";
    private static final String GROUP_USERTYPE = "GROUP";
    private static final String PERSON_USERTYPE = "INDIVIDUAL";
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() != 5;
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso == null) {
            return null;
        }
        if (dso.getType() == 5) {
            throw new CrosswalkObjectNotSupported("The METSRightsCrosswalk cannot crosswalk a SITE object");
        }
        Element rightsMD = new Element("RightsDeclarationMD", METSRights_NS);
        rightsMD.setAttribute("RIGHTSCATEGORY", "LICENSED");
        List<ResourcePolicy> policies = this.authorizeService.getPolicies(context, dso);
        for (ResourcePolicy policy : policies) {
            Group group = policy.getGroup();
            EPerson person = policy.getEPerson();
            Element rightsContext = new Element("Context", METSRights_NS);
            String rpName = policy.getRpName();
            if (rpName != null) {
                rightsContext.setAttribute("rpName", rpName);
            }
            rightsContext.setAttribute("in-effect", "true");
            Date now = new Date();
            SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd");
            if (policy.getStartDate() != null) {
                rightsContext.setAttribute("start-date", iso8601.format(policy.getStartDate()));
                if (policy.getStartDate().after(now)) {
                    rightsContext.setAttribute("in-effect", "false");
                }
            }
            if (policy.getEndDate() != null) {
                rightsContext.setAttribute("end-date", iso8601.format(policy.getEndDate()));
                if (policy.getEndDate().before(now)) {
                    rightsContext.setAttribute("in-effect", "false");
                }
            }
            if (group != null) {
                String contextClass = GROUP_CONTEXTCLASS;
                if (StringUtils.equals((CharSequence)group.getName(), (CharSequence)"Anonymous")) {
                    contextClass = ANONYMOUS_CONTEXTCLASS;
                } else if (StringUtils.equals((CharSequence)group.getName(), (CharSequence)"Administrator")) {
                    contextClass = ADMIN_CONTEXTCLASS;
                }
                rightsContext.setAttribute("CONTEXTCLASS", contextClass);
                if (contextClass.equals(GROUP_CONTEXTCLASS)) {
                    try {
                        String exportGroupName = PackageUtils.translateGroupNameForExport(context, group.getName());
                        if (exportGroupName == null || exportGroupName.isEmpty()) continue;
                        Element rightsUser = new Element("UserName", METSRights_NS);
                        rightsUser.setAttribute("USERTYPE", GROUP_USERTYPE);
                        rightsUser.addContent(exportGroupName);
                        rightsContext.addContent((Content)rightsUser);
                    }
                    catch (PackageException pe) {
                        throw new CrosswalkException(pe);
                    }
                }
                rightsMD.addContent((Content)rightsContext);
            } else if (person != null) {
                rightsContext.setAttribute("CONTEXTCLASS", PERSON_CONTEXTCLASS);
                Element rightsUser = new Element("UserName", METSRights_NS);
                rightsUser.setAttribute("USERTYPE", PERSON_USERTYPE);
                rightsUser.addContent(person.getEmail());
                rightsContext.addContent((Content)rightsUser);
                rightsMD.addContent((Content)rightsContext);
            } else {
                log.error("Policy " + String.valueOf(policy.getID()) + " is neither user nor group!  Omitted from package.");
            }
            Element rightsPerm = this.translatePermissions(policy);
            rightsContext.addContent((Content)rightsPerm);
        }
        return rightsMD;
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(context, dso));
        return result;
    }

    @Override
    public boolean preferList() {
        return false;
    }

    private Element translatePermissions(ResourcePolicy policy) {
        Element rightsPerm = new Element("Permissions", METSRights_NS);
        int action = policy.getAction();
        if (action == 0 || action == 9 || action == 10) {
            rightsPerm.setAttribute("DISCOVER", "true");
            rightsPerm.setAttribute("DISPLAY", "true");
            rightsPerm.setAttribute("MODIFY", "false");
            rightsPerm.setAttribute("DELETE", "false");
        } else if (action == 1 || action == 3) {
            rightsPerm.setAttribute("DISCOVER", "true");
            rightsPerm.setAttribute("DISPLAY", "true");
            rightsPerm.setAttribute("MODIFY", "true");
            rightsPerm.setAttribute("DELETE", "false");
        } else if (action == 2 || action == 4) {
            rightsPerm.setAttribute("DISCOVER", "true");
            rightsPerm.setAttribute("DISPLAY", "true");
            rightsPerm.setAttribute("MODIFY", "true");
            rightsPerm.setAttribute("DELETE", "true");
        } else if (action == 11) {
            rightsPerm.setAttribute("DISCOVER", "true");
            rightsPerm.setAttribute("DISPLAY", "true");
            rightsPerm.setAttribute("COPY", "true");
            rightsPerm.setAttribute("DUPLICATE", "true");
            rightsPerm.setAttribute("MODIFY", "true");
            rightsPerm.setAttribute("DELETE", "true");
            rightsPerm.setAttribute("PRINT", "true");
        }
        if (otherTypesMapping.containsKey(action)) {
            rightsPerm.setAttribute("OTHER", "true");
            rightsPerm.setAttribute("OTHERPERMITTYPE", otherTypesMapping.get(action));
        }
        return rightsPerm;
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (!root.getName().equals("RightsDeclarationMD")) {
            throw new MetadataValidationException("Wrong root element for METSRights: " + root.toString());
        }
        this.ingest(context, dso, root.getChildren(), createMissingMetadataFields);
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> ml, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() == 5) {
            throw new CrosswalkObjectNotSupported("Wrong target object type, METSRightsCrosswalk cannot crosswalk a SITE object.");
        }
        if (!ml.isEmpty() && ml.get(0).getName().equals("RightsDeclarationMD")) {
            this.ingest(context, dso, ml.get(0).getChildren(), createMissingMetadataFields);
        } else {
            ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
            for (Element element : ml) {
                if (!element.getName().equals("Context")) continue;
                String contextClass = element.getAttributeValue("CONTEXTCLASS");
                ResourcePolicy rp = (ResourcePolicy)this.resourcePolicyService.create(context);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Element permsElement = element.getChild("Permissions", METSRights_NS);
                if (permsElement == null) {
                    log.error("No <Permissions> element was found. Skipping this <Context> element.");
                    continue;
                }
                if (element.getAttributeValue("rpName") != null) {
                    rp.setRpName(element.getAttributeValue("rpName"));
                }
                try {
                    if (element.getAttributeValue("start-date") != null) {
                        rp.setStartDate(sdf.parse(element.getAttributeValue("start-date")));
                    }
                    if (element.getAttributeValue("end-date") != null) {
                        rp.setEndDate(sdf.parse(element.getAttributeValue("end-date")));
                    }
                }
                catch (ParseException ex) {
                    log.error("Failed to parse embargo date. The date needs to be in the format 'yyyy-MM-dd'.", (Throwable)ex);
                }
                if (ANONYMOUS_CONTEXTCLASS.equals(contextClass)) {
                    Group anonGroup = this.groupService.findByName(context, "Anonymous");
                    if (anonGroup == null) {
                        throw new CrosswalkInternalException("The DSpace database has not been properly initialized.  The Anonymous Group is missing from the database.");
                    }
                    rp.setGroup(anonGroup);
                } else if (ADMIN_CONTEXTCLASS.equals(contextClass)) {
                    Group adminGroup = this.groupService.findByName(context, "Administrator");
                    if (adminGroup == null) {
                        throw new CrosswalkInternalException("The DSpace database has not been properly initialized.  The Administrator Group is missing from the database.");
                    }
                    rp.setGroup(adminGroup);
                } else if (GROUP_CONTEXTCLASS.equals(contextClass)) {
                    try {
                        String groupName = element.getChildTextTrim("UserName", METSRights_NS);
                        groupName = PackageUtils.translateGroupNameForImport(context, groupName);
                        Group group = this.groupService.findByName(context, groupName);
                        if (group == null) {
                            throw new CrosswalkInternalException("Cannot restore Group permissions on object (type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", ID=" + dso.getID() + "). The Group named '" + groupName + "' is missing from DSpace. Please restore this group using the SITE AIP, or recreate it.");
                        }
                        rp.setGroup(group);
                    }
                    catch (PackageException pe) {
                        throw new CrosswalkException(pe);
                    }
                } else if (PERSON_CONTEXTCLASS.equals(contextClass)) {
                    String personEmail = element.getChildTextTrim("UserName", METSRights_NS);
                    EPerson person = this.ePersonService.findByEmail(context, personEmail);
                    if (person == null) {
                        person = this.ePersonService.findByNetid(context, personEmail);
                    }
                    if (person == null) {
                        throw new CrosswalkInternalException("Cannot restore Person permissions on object (type=" + Constants.typeText[dso.getType()] + ", handle=" + dso.getHandle() + ", ID=" + dso.getID() + "). The Person with email/netid '" + personEmail + "' is missing from DSpace. Please restore this Person object using the SITE AIP, or recreate it.");
                    }
                    rp.setEPerson(person);
                } else {
                    log.error("Unrecognized CONTEXTCLASS:  " + contextClass);
                }
                rp.setAction(this.parsePermissions(permsElement));
                policies.add(rp);
            }
            this.authorizeService.removeAllPolicies(context, dso);
            this.authorizeService.addPolicies(context, policies, dso);
        }
    }

    private int parsePermissions(Element permsElement) {
        String otherPermitType = permsElement.getAttributeValue("OTHERPERMITTYPE");
        if (otherPermitType != null && !otherPermitType.isEmpty()) {
            if (otherTypesMapping.containsValue(otherPermitType)) {
                for (int actionType : otherTypesMapping.keySet()) {
                    if (!otherTypesMapping.get(actionType).equals(otherPermitType)) continue;
                    return actionType;
                }
            } else {
                log.warn("Unrecognized @OTHERPERMITTYPE attribute value (" + otherPermitType + ") found in METSRights section of METS Manifest.");
            }
        } else {
            boolean discoverPermit = Boolean.parseBoolean(permsElement.getAttributeValue("DISCOVER"));
            boolean displayPermit = Boolean.parseBoolean(permsElement.getAttributeValue("DISPLAY"));
            boolean modifyPermit = Boolean.parseBoolean(permsElement.getAttributeValue("MODIFY"));
            boolean deletePermit = Boolean.parseBoolean(permsElement.getAttributeValue("DELETE"));
            boolean otherPermit = Boolean.parseBoolean(permsElement.getAttributeValue("OTHER"));
            if (deletePermit && !otherPermit) {
                return 2;
            }
            if (modifyPermit && !otherPermit) {
                return 1;
            }
            if (discoverPermit && displayPermit && !otherPermit) {
                return 0;
            }
        }
        return -1;
    }

    static {
        otherTypesMapping.put(3, "ADD CONTENTS");
        otherTypesMapping.put(4, "REMOVE CONTENTS");
        otherTypesMapping.put(11, "ADMIN");
        otherTypesMapping.put(9, "READ FILE CONTENTS");
        otherTypesMapping.put(10, "READ ITEM CONTENTS");
    }
}

