/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.SiteService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class PackageUtils {
    private static final Logger log = LogManager.getLogger(PackageUtils.class);
    protected static final String[] ccMetadataMap = new String[]{"name", "dc.title", "introductory_text", "dc.description", "short_description", "dc.description.abstract", "side_bar_text", "dc.description.tableofcontents", "copyright_text", "dc.rights", "provenance_description", "dc.provenance", "license", "dc.rights.license"};
    protected static final Map<String, String> ccMetadataToDC = new HashMap<String, String>();
    protected static final Map<String, String> ccDCToMetadata = new HashMap<String, String>();
    protected static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected static final BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected static final BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected static final WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected static final SiteService siteService = ContentServiceFactory.getInstance().getSiteService();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected static final Map<String, String> orphanGroups;

    private PackageUtils() {
    }

    public static String dcToContainerMetadata(String dcField) {
        return ccDCToMetadata.get(dcField);
    }

    public static String containerMetadataToDC(String databaseField) {
        return ccMetadataToDC.get(databaseField);
    }

    public static void checkItemMetadata(Item item) throws PackageValidationException {
        List<MetadataValue> t = itemService.getMetadata(item, MetadataSchemaEnum.DC.getName(), "title", null, "*");
        if (t == null || t.isEmpty()) {
            throw new PackageValidationException("Item cannot be created without the required \"title\" DC metadata.");
        }
    }

    public static void addDepositLicense(Context context, String license, Item item, Collection collection) throws SQLException, IOException, AuthorizeException {
        if (license == null) {
            license = collectionService.getLicense(collection);
        }
        ByteArrayInputStream lis = new ByteArrayInputStream(license.getBytes());
        List<Bundle> bundles = itemService.getBundles(item, "LICENSE");
        Bundle lb = CollectionUtils.isEmpty(bundles) ? bundleService.create(context, item, "LICENSE") : bundles.get(0);
        Bitstream lbs = bitstreamService.create(context, lb, lis);
        ((InputStream)lis).close();
        BitstreamFormat bf = bitstreamFormatService.findByShortDescription(context, "License");
        if (bf == null) {
            bf = bitstreamFormatService.guessFormat(context, lbs);
        }
        lbs.setFormat(context, bf);
        lbs.setName(context, "license.txt");
        lbs.setSource(context, "license.txt");
        bitstreamService.update(context, lbs);
    }

    public static Bitstream getBitstreamByName(Item item, String name) throws SQLException {
        return PackageUtils.getBitstreamByName(item, name, null);
    }

    public static Bitstream getBitstreamByName(Item item, String bsName, String bnName) throws SQLException {
        List<Bundle> bundles = bnName == null ? item.getBundles() : itemService.getBundles(item, bnName);
        for (Bundle bundle : bundles) {
            List<Bitstream> bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                if (!bsName.equals(bitstream.getName())) continue;
                return bitstream;
            }
        }
        return null;
    }

    public static Bitstream getBitstreamByFormat(Context context, Item item, BitstreamFormat bsf, String bnName) throws SQLException {
        int fid = bsf.getID();
        List<Bundle> bundles = bnName == null ? item.getBundles() : itemService.getBundles(item, bnName);
        for (Bundle bundle : bundles) {
            List<Bitstream> bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                if (bitstream.getFormat(context).getID() != fid) continue;
                return bitstream;
            }
        }
        return null;
    }

    public static boolean isMetaInfoBundle(Bundle bn) {
        return bn.getName().equals("LICENSE") || bn.getName().equals("CC-LICENSE") || bn.getName().equals("METADATA");
    }

    public static BitstreamFormat findOrCreateBitstreamFormat(Context context, String shortDesc, String MIMEType, String desc) throws SQLException, AuthorizeException {
        return PackageUtils.findOrCreateBitstreamFormat(context, shortDesc, MIMEType, desc, 1, false);
    }

    public static BitstreamFormat findOrCreateBitstreamFormat(Context context, String shortDesc, String MIMEType, String desc, int supportLevel, boolean internal) throws SQLException, AuthorizeException {
        BitstreamFormat bsf = bitstreamFormatService.findByShortDescription(context, shortDesc);
        if (bsf == null) {
            bsf = (BitstreamFormat)bitstreamFormatService.create(context);
            bsf.setShortDescription(context, shortDesc);
            bsf.setMIMEType(MIMEType);
            bsf.setDescription(desc);
            bsf.setSupportLevel(supportLevel);
            bsf.setInternal(internal);
            bitstreamFormatService.update(context, bsf);
        }
        return bsf;
    }

    public static Bitstream findDepositLicense(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        int licenseFormatId = -1;
        BitstreamFormat bf = bitstreamFormatService.findByShortDescription(context, "License");
        if (bf != null) {
            licenseFormatId = bf.getID();
        }
        List<Bundle> bundles = itemService.getBundles(item, "LICENSE");
        for (Bundle bundle : bundles) {
            List<Bitstream> bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                if (bitstream.getFormat(context).getID() != licenseFormatId) continue;
                return bitstream;
            }
            if (bitstreams.size() <= 0) continue;
            return bitstreams.get(0);
        }
        return null;
    }

    public static DSpaceObject createDSpaceObject(Context context, DSpaceObject parent, int type, String handle, UUID uuid, PackageParameters params) throws AuthorizeException, SQLException, IOException {
        DSpaceObject dso = null;
        switch (type) {
            case 3: {
                Collection collection = (Collection)collectionService.find(context, uuid);
                dso = collection != null ? collectionService.create(context, (Community)parent, handle) : collectionService.create(context, (Community)parent, handle, uuid);
                return dso;
            }
            case 4: {
                Community community;
                dso = parent == null || parent.getType() == 5 ? ((community = (Community)communityService.find(context, uuid)) != null ? communityService.create(null, context, handle) : communityService.create(null, context, handle, uuid)) : ((community = (Community)communityService.find(context, uuid)) != null ? communityService.createSubcommunity(context, (Community)parent, handle) : communityService.createSubcommunity(context, (Community)parent, handle, uuid));
                return dso;
            }
            case 2: {
                Item item = (Item)itemService.find(context, uuid);
                if (item != null) {
                    return item;
                }
                WorkspaceItem wsi = null;
                wsi = !params.replaceModeEnabled() ? workspaceItemService.create(context, (Collection)parent, params.useCollectionTemplate()) : workspaceItemService.create(context, (Collection)parent, uuid, params.useCollectionTemplate());
                return wsi.getItem();
            }
            case 5: {
                return siteService.findSite(context);
            }
        }
        return null;
    }

    public static Item finishCreateItem(Context context, WorkspaceItem wsi, String handle, PackageParameters params) throws IOException, SQLException, AuthorizeException, WorkflowException {
        if (params.restoreModeEnabled()) {
            installItemService.restoreItem(context, wsi, handle);
            return wsi.getItem();
        }
        if (params.workflowEnabled()) {
            WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
            return workflowService.startWithoutNotify(context, wsi).getItem();
        }
        installItemService.installItem(context, wsi, handle);
        return wsi.getItem();
    }

    public static void updateDSpaceObject(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IOException {
        if (dso != null) {
            DSpaceObjectService<DSpaceObject> dsoService = ContentServiceFactory.getInstance().getDSpaceObjectService(dso);
            dsoService.update(context, dso);
        }
    }

    public static String getFileExtension(String filename) {
        String extension = filename;
        int lastDot = filename.lastIndexOf(46);
        if (lastDot != -1) {
            extension = filename.substring(lastDot + 1);
        }
        return extension;
    }

    public static String getPackageName(DSpaceObject dso, String fileExtension) {
        Object handle = dso.getHandle();
        handle = handle == null || ((String)handle).isEmpty() ? "internal-id-" + dso.getID() : ((String)handle).replace("/", "-");
        int typeID = dso.getType();
        String type = Constants.typeText[typeID];
        if (!((String)fileExtension).startsWith(".")) {
            fileExtension = "." + (String)fileExtension;
        }
        return type + "@" + (String)handle + (String)fileExtension;
    }

    public static boolean createFile(File file) throws IOException {
        boolean success = false;
        if (!file.exists()) {
            File parentFile = file.getCanonicalFile().getParentFile();
            if (null != parentFile && !parentFile.exists() && !parentFile.mkdirs()) {
                log.error("Unable to create parent directory");
            }
            success = file.createNewFile();
        }
        return success;
    }

    public static void removeAllBitstreams(Context context, DSpaceObject dso) throws SQLException, IOException, AuthorizeException {
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            Iterator<Bundle> bunds = item.getBundles().iterator();
            while (bunds.hasNext()) {
                Bundle bundle = bunds.next();
                bunds.remove();
                itemService.removeBundle(context, item, bundle);
            }
        } else if (dso.getType() == 3) {
            Collection collection = (Collection)dso;
            collectionService.setLogo(context, collection, null);
        } else if (dso.getType() == 4) {
            Community community = (Community)dso;
            communityService.setLogo(context, community, null);
        }
    }

    public static void clearAllMetadata(Context context, DSpaceObject dso) throws SQLException, IOException, AuthorizeException {
        block7: {
            block8: {
                block6: {
                    if (dso.getType() != 2) break block6;
                    Item item = (Item)dso;
                    itemService.clearMetadata(context, item, "*", "*", "*", "*");
                    break block7;
                }
                if (dso.getType() != 3) break block8;
                Collection collection = (Collection)dso;
                for (String dbField : ccMetadataToDC.keySet()) {
                    try {
                        String[] elements = MetadataFieldName.parse(dbField);
                        collectionService.clearMetadata(context, collection, elements[0], elements[1], elements[2], "*");
                    }
                    catch (IllegalArgumentException elements) {}
                }
                break block7;
            }
            if (dso.getType() != 4) break block7;
            Community community = (Community)dso;
            for (String dbField : ccMetadataToDC.keySet()) {
                try {
                    String[] elements = MetadataFieldName.parse(dbField);
                    communityService.clearMetadata(context, community, elements[0], elements[1], elements[2], "*");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public static String translateGroupNameForExport(Context context, String groupName) throws PackageException {
        Pattern defaultGroupNamePattern = Pattern.compile("^([^_]+)_([^_]+)_(.+)$");
        Matcher matcher = defaultGroupNamePattern.matcher(groupName);
        if (!matcher.matches()) {
            return groupName;
        }
        String objTypeText = matcher.group(1);
        String objID = matcher.group(2);
        String groupType = matcher.group(3);
        int objType = Constants.getTypeID(objTypeText);
        if (objID == null || objType == -1) {
            return groupName;
        }
        try {
            DSpaceObject dso = ContentServiceFactory.getInstance().getDSpaceLegacyObjectService(objType).findByIdOrLegacyId(context, objID);
            if (dso == null) {
                Object newName;
                if (orphanGroups.containsKey(groupName)) {
                    newName = orphanGroups.get(groupName);
                } else {
                    newName = "ORPHANED_" + objType + "_GROUP_" + objID + "_" + groupType;
                    orphanGroups.put(groupName, (String)newName);
                }
                log.warn("DSpace Object (ID='" + objID + "', type ='" + objType + "') no longer exists -- translating " + groupName + " to " + (String)newName + ".");
                return newName;
            }
            return objTypeText + "_hdl:" + dso.getHandle() + "_" + groupType;
        }
        catch (SQLException sqle) {
            throw new PackageException("Database error while attempting to translate group name ('" + groupName + "') for export.", sqle);
        }
    }

    public static String translateGroupNameForImport(Context context, String groupName) throws PackageException {
        if (!groupName.matches("^.+_.+_.+$")) {
            return groupName;
        }
        String objType = groupName.substring(0, groupName.indexOf(95));
        String tmpEndString = groupName.substring(groupName.indexOf(95) + 1);
        String objID = tmpEndString.substring(0, tmpEndString.indexOf(95));
        String groupType = tmpEndString.substring(tmpEndString.indexOf(95) + 1);
        try {
            if (objID.startsWith("hdl:")) {
                DSpaceObject dso = handleService.resolveToObject(context, objID.substring(4));
                if (dso == null) {
                    throw new PackageException("Unable to translate Handle to Internal ID in group named '" + groupName + "' as DSpace Object (Handle='" + objID + "') does not exist.");
                }
                if (Constants.getTypeID(objType) != dso.getType()) {
                    throw new PackageValidationException("DSpace Object referenced by handle '" + objID + "' does not correspond to the object type specified by Group named '" + groupName + "'.  This Group doesn't seem to correspond to this DSpace Object!");
                }
                return objType + "_" + dso.getID() + "_" + groupType;
            }
            return groupName;
        }
        catch (SQLException sqle) {
            throw new PackageException("Database error while attempting to translate group name ('" + groupName + "') for import.", sqle);
        }
    }

    static {
        for (int i = 0; i < ccMetadataMap.length; i += 2) {
            ccMetadataToDC.put(ccMetadataMap[i], ccMetadataMap[i + 1]);
            ccDCToMetadata.put(ccMetadataMap[i + 1], ccMetadataMap[i]);
        }
        orphanGroups = new HashMap<String, String>();
    }

    public static class UnclosableInputStream
    extends FilterInputStream {
        public UnclosableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

