/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.commons.codec.binary.StringUtils;

public enum FrequencyType {
    DAY("D"),
    WEEK("W"),
    MONTH("M");

    private String shortName;

    private FrequencyType(String shortName) {
        this.shortName = shortName;
    }

    public static String findLastFrequency(String frequency) {
        String startDate = "";
        String endDate = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat fullIsoStart = new SimpleDateFormat("yyyy-MM-dd'T'00:00:00'Z'");
        SimpleDateFormat fullIsoEnd = new SimpleDateFormat("yyyy-MM-dd'T'23:59:59'Z'");
        switch (frequency) {
            case "D": {
                cal.add(5, -1);
                endDate = fullIsoEnd.format(cal.getTime());
                startDate = fullIsoStart.format(cal.getTime());
                break;
            }
            case "M": {
                int dayOfMonth = cal.get(5);
                cal.add(5, -dayOfMonth);
                endDate = fullIsoEnd.format(cal.getTime());
                cal.add(2, -1);
                cal.add(5, 1);
                startDate = fullIsoStart.format(cal.getTime());
                break;
            }
            case "W": {
                cal.add(7, -1);
                int dayOfWeek = cal.get(7) - 1;
                cal.add(7, -dayOfWeek);
                endDate = fullIsoEnd.format(cal.getTime());
                cal.add(7, -6);
                startDate = fullIsoStart.format(cal.getTime());
                break;
            }
            default: {
                return null;
            }
        }
        return "[" + startDate + " TO " + endDate + "]";
    }

    public static boolean isSupportedFrequencyType(String value) {
        for (FrequencyType ft : Arrays.asList(FrequencyType.values())) {
            if (!StringUtils.equals((CharSequence)ft.getShortName(), (CharSequence)value)) continue;
            return true;
        }
        return false;
    }

    public String getShortName() {
        return this.shortName;
    }
}

