/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.sql.SQLException;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestScheduler;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.OAIHarvester;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;

public class HarvestThread
extends Thread {
    private static final Logger log = LogManager.getLogger(HarvestThread.class);
    protected UUID collectionId;
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected HarvestedCollectionService harvestedCollectionService = HarvestServiceFactory.getInstance().getHarvestedCollectionService();

    protected HarvestThread(UUID collectionId) throws SQLException {
        this.collectionId = collectionId;
    }

    @Override
    public void run() {
        log.info("Thread for collection " + this.collectionId + " starts.");
        this.runHarvest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHarvest() {
        HarvestedCollection hc = null;
        try {
            Context context = new Context();
            Collection dso = (Collection)this.collectionService.find(context, this.collectionId);
            hc = this.harvestedCollectionService.find(context, dso);
            try {
                dso = hc.getCollection();
                OAIHarvester harvester = new OAIHarvester(context, dso, hc);
                harvester.runHarvest();
            }
            catch (RuntimeException e) {
                log.error("Runtime exception in thread: " + this.toString());
                log.error(e.getMessage() + " " + e.getCause());
                hc.setHarvestMessage("Runtime error occured while generating an OAI response");
                hc.setHarvestStatus(-1);
            }
            catch (Exception ex) {
                log.error("General exception in thread: " + this.toString());
                log.error(ex.getMessage() + " " + ex.getCause());
                hc.setHarvestMessage("Error occured while generating an OAI response");
                hc.setHarvestStatus(-1);
            }
            finally {
                try {
                    this.harvestedCollectionService.update(context, hc);
                    context.restoreAuthSystemState();
                    context.complete();
                }
                catch (RuntimeException e) {
                    log.error("Unexpected exception while recovering from a harvesting error: " + e.getMessage(), (Throwable)e);
                    context.abort();
                }
                catch (Exception e) {
                    log.error("Unexpected exception while recovering from a harvesting error: " + e.getMessage(), (Throwable)e);
                    context.abort();
                }
                Class<HarvestScheduler> e = HarvestScheduler.class;
                synchronized (HarvestScheduler.class) {
                    Integer n = HarvestScheduler.activeThreads;
                    Integer n2 = HarvestScheduler.activeThreads = Integer.valueOf(HarvestScheduler.activeThreads - 1);
                    // ** MonitorExit[e] (shouldn't be in output)
                }
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("Thread for collection " + hc.getCollection().getID() + " completes.");
    }
}

