/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.ads;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.el.MethodNotFoundException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.springframework.beans.factory.annotation.Autowired;

public class ADSImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<String>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    private String url;
    private String resultFieldList;
    private String apiKey;
    private int timeout = 1000;
    @Autowired
    private LiveImportClient liveImportClient;

    @Override
    public String getImportSource() {
        return "ads";
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(id));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query, count, start));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(query));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        return this.retry(new FindMatchingRecordCallable(query));
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new MethodNotFoundException("This method is not implemented for CrossRef");
    }

    @Override
    public void init() throws Exception {
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private List<ImportRecord> search(String title, String author, int year, int start, int count, String token) {
        Object query = "";
        if (StringUtils.isNotBlank((CharSequence)title)) {
            query = (String)query + "title:" + title;
        }
        if (StringUtils.isNotBlank((CharSequence)author)) {
            String splitRegex = "(\\s*,\\s+|\\s*;\\s+|\\s*;+|\\s*,+|\\s+)";
            String[] authors = author.split(splitRegex);
            query = StringUtils.isNotBlank((CharSequence)query) ? "author:" : (String)query + "&fq=author:";
            int x = 0;
            for (String auth : authors) {
                query = (String)query + auth;
                if (++x >= authors.length) continue;
                query = (String)query + " AND ";
            }
        }
        if (year != -1) {
            query = StringUtils.isNotBlank((CharSequence)query) ? "year:" : (String)query + "&fq=year:";
            query = (String)query + year;
        }
        return this.search(((String)query).toString(), start, count, token);
    }

    public Integer count(String query, String token) {
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            HashMap<String, CallSite> headerParameters = new HashMap<String, CallSite>();
            headerParameters.put("Authorization", (CallSite)((Object)("Bearer " + token)));
            params.put("headerParameters", headerParameters);
            URIBuilder uriBuilder = new URIBuilder(this.url);
            uriBuilder.addParameter("q", query);
            uriBuilder.addParameter("rows", "1");
            uriBuilder.addParameter("start", "0");
            uriBuilder.addParameter("fl", this.resultFieldList);
            String resp = this.liveImportClient.executeHttpGetRequest(this.timeout, uriBuilder.toString(), params);
            JsonNode jsonNode = this.convertStringJsonToJsonNode(resp);
            return jsonNode.at("/response/numFound").asInt();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public List<ImportRecord> search(String query, Integer start, Integer count, String token) {
        ArrayList<ImportRecord> adsResults = new ArrayList<ImportRecord>();
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            HashMap<String, CallSite> headerParameters = new HashMap<String, CallSite>();
            headerParameters.put("Authorization", (CallSite)((Object)("Bearer " + token)));
            params.put("headerParameters", headerParameters);
            URIBuilder uriBuilder = new URIBuilder(this.url);
            uriBuilder.addParameter("q", query);
            uriBuilder.addParameter("rows", count.toString());
            uriBuilder.addParameter("start", start.toString());
            uriBuilder.addParameter("fl", this.resultFieldList);
            String resp = this.liveImportClient.executeHttpGetRequest(this.timeout, uriBuilder.toString(), params);
            JsonNode jsonNode = this.convertStringJsonToJsonNode(resp);
            JsonNode docs = jsonNode.at("/response/docs");
            if (docs.isArray()) {
                Iterator nodes = docs.elements();
                while (nodes.hasNext()) {
                    JsonNode node = (JsonNode)nodes.next();
                    adsResults.add(this.transformSourceRecords(node.toString()));
                }
            } else {
                adsResults.add(this.transformSourceRecords(docs.toString()));
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return adsResults;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        try {
            return new ObjectMapper().readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
            return null;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setResultFieldList(String resultFieldList) {
        this.resultFieldList = resultFieldList;
    }

    private class CountByQueryCallable
    implements Callable<Integer> {
        private Query query;

        private CountByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        private CountByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            return ADSImportMetadataSourceServiceImpl.this.count(this.query.getParameterAsClass("query", String.class), ADSImportMetadataSourceServiceImpl.this.getApiKey());
        }
    }

    private class FindMatchingRecordCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private FindMatchingRecordCallable(Query q) {
            this.query = q;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            String author = this.query.getParameterAsClass("author", String.class);
            String title = this.query.getParameterAsClass("title", String.class);
            Integer year = this.query.getParameterAsClass("year", Integer.class);
            return ADSImportMetadataSourceServiceImpl.this.search(title, author, year, start, count, ADSImportMetadataSourceServiceImpl.this.getApiKey());
        }
    }

    private class SearchByIdCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByIdCallable(Query query) {
            this.query = query;
        }

        private SearchByIdCallable(String id) {
            this.query = new Query();
            this.query.addParameter("id", id);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            String queryString = "bibcode:" + this.query.getParameterAsClass("id", String.class);
            return ADSImportMetadataSourceServiceImpl.this.search(queryString, 0, 1, ADSImportMetadataSourceServiceImpl.this.getApiKey());
        }
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString, Integer maxResult, Integer start) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("count", maxResult);
            this.query.addParameter("start", start);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            return ADSImportMetadataSourceServiceImpl.this.search(this.query.getParameterAsClass("query", String.class), this.query.getParameterAsClass("start", Integer.class), this.query.getParameterAsClass("count", Integer.class), ADSImportMetadataSourceServiceImpl.this.getApiKey());
        }
    }
}

