/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.SimpleXpathMetadatumContributor;
import org.jaxen.JaxenException;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AuthorMetadataContributor
extends SimpleXpathMetadatumContributor {
    private static final Namespace NAMESPACE = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
    private MetadataFieldConfig orcid;
    private MetadataFieldConfig scopusId;
    private MetadataFieldConfig authname;
    private MetadataFieldConfig affiliation;
    private Map<String, String> affId2affName = new HashMap<String, String>();

    @Override
    public Collection<MetadatumDTO> contributeMetadata(Element element) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        List<MetadatumDTO> metadatums = null;
        this.fillAffillation(element);
        try {
            List nodes = element.getChildren("author", NAMESPACE);
            for (Element el : nodes) {
                metadatums = this.getMetadataOfAuthors(el);
                if (!Objects.nonNull(metadatums)) continue;
                for (MetadatumDTO metadatum : metadatums) {
                    values.add(metadatum);
                }
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        return values;
    }

    private List<MetadatumDTO> getMetadataOfAuthors(Element element) throws JaxenException {
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        Element authname = element.getChild("authname", NAMESPACE);
        Element scopusId = element.getChild("authid", NAMESPACE);
        Element orcid = element.getChild("orcid", NAMESPACE);
        Element afid = element.getChild("afid", NAMESPACE);
        this.addMetadatum(metadatums, this.getMetadata(this.getElementValue(authname), this.authname));
        this.addMetadatum(metadatums, this.getMetadata(this.getElementValue(scopusId), this.scopusId));
        this.addMetadatum(metadatums, this.getMetadata(this.getElementValue(orcid), this.orcid));
        this.addMetadatum(metadatums, this.getMetadata(StringUtils.isNotBlank((String)afid.getValue()) ? this.affId2affName.get(afid.getValue()) : null, this.affiliation));
        return metadatums;
    }

    private void addMetadatum(List<MetadatumDTO> list, MetadatumDTO metadatum) {
        if (Objects.nonNull(metadatum)) {
            list.add(metadatum);
        }
    }

    private String getElementValue(Element element) {
        if (Objects.nonNull(element)) {
            return element.getValue();
        }
        return "";
    }

    private MetadatumDTO getMetadata(String value, MetadataFieldConfig metadaConfig) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        MetadatumDTO metadata = new MetadatumDTO();
        metadata.setElement(metadaConfig.getElement());
        metadata.setQualifier(metadaConfig.getQualifier());
        metadata.setSchema(metadaConfig.getSchema());
        metadata.setValue(value);
        return metadata;
    }

    private void fillAffillation(Element element) {
        try {
            List nodes = element.getChildren("affiliation", NAMESPACE);
            for (Element el : nodes) {
                this.fillAffiliation2Name(el);
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
    }

    private void fillAffiliation2Name(Element element) throws JaxenException {
        Element affilationName = element.getChild("affilname", NAMESPACE);
        Element affilationId = element.getChild("afid", NAMESPACE);
        if (Objects.nonNull(affilationId) && Objects.nonNull(affilationName)) {
            this.affId2affName.put(affilationId.getValue(), affilationName.getValue());
        }
    }

    public MetadataFieldConfig getAuthname() {
        return this.authname;
    }

    public void setAuthname(MetadataFieldConfig authname) {
        this.authname = authname;
    }

    public MetadataFieldConfig getOrcid() {
        return this.orcid;
    }

    public void setOrcid(MetadataFieldConfig orcid) {
        this.orcid = orcid;
    }

    public MetadataFieldConfig getScopusId() {
        return this.scopusId;
    }

    public void setScopusId(MetadataFieldConfig scopusId) {
        this.scopusId = scopusId;
    }

    public MetadataFieldConfig getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(MetadataFieldConfig affiliation) {
        this.affiliation = affiliation;
    }
}

