/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.SimpleMetadataContributor;
import org.dspace.importer.external.service.components.dto.PlainMetadataKeyValueItem;
import org.dspace.importer.external.service.components.dto.PlainMetadataSourceDto;

public class EnhancedSimpleMetadataContributor
extends SimpleMetadataContributor {
    private char delimiter = (char)44;
    private char quote = (char)34;
    private char escape = (char)92;

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public void setEscape(char escape) {
        this.escape = escape;
    }

    public char getEscape() {
        return this.escape;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(PlainMetadataSourceDto t) {
        LinkedList<MetadatumDTO> values = null;
        values = new LinkedList<MetadatumDTO>();
        for (PlainMetadataKeyValueItem metadatum : t.getMetadata()) {
            String[] splitted;
            if (!this.getKey().equals(metadatum.getKey())) continue;
            for (String value : splitted = this.splitToRecord(metadatum.getValue())) {
                MetadatumDTO dcValue = new MetadatumDTO();
                dcValue.setValue(value);
                dcValue.setElement(this.getField().getElement());
                dcValue.setQualifier(this.getField().getQualifier());
                dcValue.setSchema(this.getField().getSchema());
                values.add(dcValue);
            }
        }
        return values;
    }

    private String[] splitToRecord(String value) {
        List rows;
        CSVParser parser = new CSVParserBuilder().withSeparator(this.delimiter).withQuoteChar(this.quote).withEscapeChar(this.escape).build();
        try (StringReader inputReader = new StringReader(value);
             CSVReader csvReader = new CSVReaderBuilder((Reader)inputReader).withCSVParser((ICSVParser)parser).build();){
            rows = csvReader.readAll();
        }
        catch (CsvException | IOException e) {
            return new String[]{value};
        }
        return (String[])rows.get(0);
    }
}

