/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.File;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Get;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.SolrLoggerService;

public class StatisticsClient {
    private static final Logger log = LogManager.getLogger(StatisticsClient.class);

    private StatisticsClient() {
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("StatisticsClient\n", options);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("u", "update-spider-files", false, "Update Spider IP Files from internet into " + DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + "/config/spiders");
        options.addOption("m", "mark-spiders", false, "Update isBot Flag in Solr");
        options.addOption("f", "delete-spiders-by-flag", false, "Delete Spiders in Solr By isBot Flag");
        options.addOption("i", "delete-spiders-by-ip", false, "Delete Spiders in Solr By IP Address");
        options.addOption("o", "optimize", false, "Run maintenance on the SOLR index");
        options.addOption("b", "reindex-bitstreams", false, "Reindex the bitstreams to ensure we have the bundle name");
        options.addOption("e", "export", false, "Export SOLR view statistics data to usage-statistics-intermediate-format");
        options.addOption("r", "remove-deleted-bitstreams", false, "While indexing the bundle names remove the statistics about deleted bitstreams");
        options.addOption("s", "shard-solr-index", false, "Split the data from the main Solr core into separate Solr cores per year");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            StatisticsClient.printHelp(options, 0);
        }
        SolrLoggerService solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();
        if (line.hasOption("u")) {
            StatisticsClient.updateSpiderFiles();
        } else if (line.hasOption('m')) {
            solrLoggerService.markRobotsByIP();
        } else if (line.hasOption('f')) {
            solrLoggerService.deleteRobotsByIsBotFlag();
        } else if (line.hasOption('i')) {
            solrLoggerService.deleteRobotsByIP();
        } else if (line.hasOption('o')) {
            solrLoggerService.optimizeSOLR();
        } else if (line.hasOption('b')) {
            solrLoggerService.reindexBitstreamHits(line.hasOption('r'));
        } else if (line.hasOption('e')) {
            solrLoggerService.exportHits();
        } else if (line.hasOption('s')) {
            solrLoggerService.shardSolrIndex();
        } else {
            StatisticsClient.printHelp(options, 0);
        }
    }

    private static void updateSpiderFiles() {
        try {
            File spiders;
            System.out.println("Downloading latest spider IP addresses:");
            String[] urls = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("solr-statistics.spiderips.urls");
            if (urls == null || urls.length == 0) {
                System.err.println(" - Missing setting from dspace.cfg: solr.spiderips.urls");
                System.exit(0);
            }
            if (!(spiders = new File(DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir"), "config/spiders")).exists() && !spiders.mkdirs()) {
                log.error("Unable to create spiders directory");
            }
            for (String value : urls) {
                value = value.trim();
                System.out.println(" Downloading: " + value);
                URL url = new URL(value);
                Get get = new Get();
                get.setProject(new Project());
                get.setDest(new File(spiders, url.getHost() + url.getPath().replace("/", "-")));
                get.setSrc(url);
                get.setUseTimestamp(true);
                get.execute();
            }
        }
        catch (Exception e) {
            System.err.println(" - Error: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

