/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import org.dspace.app.mediafilter.ImageMagickThumbnailFilter;
import org.dspace.content.Item;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IM4JavaException;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;

public class ImageMagickVideoThumbnailFilter
extends ImageMagickThumbnailFilter {
    private static final int DEFAULT_WIDTH = 180;
    private static final int DEFAULT_HEIGHT = 120;
    private static final int FRAME_NUMBER = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        File f = this.inputStreamToTempFile(source, "imthumb", ".tmp");
        File f2 = null;
        try {
            f2 = this.getThumbnailFile(f, verbose);
            byte[] bytes = Files.readAllBytes(f2.toPath());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
        finally {
            f.delete();
            if (f2 != null) {
                f2.delete();
            }
        }
    }

    @Override
    public File getThumbnailFile(File f, boolean verbose) throws IOException, InterruptedException, IM4JavaException {
        File f2 = new File(f.getParentFile(), f.getName() + ".jpg");
        f2.deleteOnExit();
        ConvertCmd cmd = new ConvertCmd();
        IMOperation op = new IMOperation();
        op.autoOrient();
        op.addImage(new String[]{"VIDEO:" + f.getAbsolutePath() + "[100]"});
        op.thumbnail(Integer.valueOf(configurationService.getIntProperty("thumbnail.maxwidth", 180)), Integer.valueOf(configurationService.getIntProperty("thumbnail.maxheight", 120)));
        op.addImage(new String[]{f2.getAbsolutePath()});
        if (verbose) {
            System.out.println("IM Thumbnail Param: " + op);
        }
        cmd.run((Operation)op, new Object[0]);
        return f2;
    }
}

