/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class Email {
    private String contentName;
    private String subject = "";
    private final List<Object> arguments = new ArrayList<Object>(50);
    private final List<String> recipients = new ArrayList<String>(50);
    private String replyTo = null;
    private final List<FileAttachment> attachments = new ArrayList<FileAttachment>(10);
    private final List<InputStreamAttachment> moreAttachments = new ArrayList<InputStreamAttachment>(10);
    private String charset = null;
    private static final Logger LOG = LogManager.getLogger();
    private static final String RESOURCE_REPOSITORY_NAME = "Email";
    private static final Properties VELOCITY_PROPERTIES = new Properties();
    private Template template = null;
    private static final String DEFAULT_ATTACHMENT_TYPE = "application/octet-stream";

    public void addRecipient(String email) {
        this.recipients.add(email);
    }

    public void setContent(String name, String content) {
        this.contentName = name;
        this.arguments.clear();
        VelocityEngine templateEngine = new VelocityEngine();
        templateEngine.init(VELOCITY_PROPERTIES);
        StringResourceRepository repo = (StringResourceRepository)templateEngine.getApplicationAttribute((Object)RESOURCE_REPOSITORY_NAME);
        repo.putStringResource(this.contentName, content);
        this.template = templateEngine.getTemplate(this.contentName);
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setReplyTo(String email) {
        this.replyTo = email;
    }

    public void addArgument(Object arg) {
        this.arguments.add(arg);
    }

    public void addAttachment(File f, String name) {
        this.attachments.add(new FileAttachment(f, name));
    }

    public void addAttachment(InputStream is, String name, String mimetype) {
        if (null == mimetype) {
            LOG.error("Null MIME type replaced with 'application/octet-stream' for attachment '" + name + "'");
            mimetype = DEFAULT_ATTACHMENT_TYPE;
        } else {
            try {
                new ContentType(mimetype);
            }
            catch (ParseException ex) {
                LOG.error("Bad MIME type '" + mimetype + "' replaced with 'application/octet-stream' for attachment '" + name + "'", (Throwable)ex);
                mimetype = DEFAULT_ATTACHMENT_TYPE;
            }
        }
        this.moreAttachments.add(new InputStreamAttachment(is, name, mimetype));
    }

    public void setCharset(String cs) {
        this.charset = cs;
    }

    public void reset() {
        this.arguments.clear();
        this.recipients.clear();
        this.attachments.clear();
        this.moreAttachments.clear();
        this.replyTo = null;
        this.charset = null;
    }

    public void send() throws MessagingException, IOException {
        if (null == this.template) {
            throw new MessagingException("Email has no body");
        }
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        String from = config.getProperty("mail.from.address");
        boolean disabled = config.getBooleanProperty("mail.server.disabled", false);
        if (this.charset == null) {
            this.charset = config.getProperty("mail.charset");
        }
        Session session = DSpaceServicesFactory.getInstance().getEmailService().getSession();
        MimeMessage message = new MimeMessage(session);
        for (String recipient : this.recipients) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        }
        String[] templateHeaders = config.getArrayProperty("mail.message.headers");
        VelocityContext vctx = new VelocityContext();
        vctx.put("config", (Object)new UnmodifiableConfigurationService(config));
        vctx.put("params", Collections.unmodifiableList(this.arguments));
        StringWriter writer = new StringWriter();
        try {
            this.template.merge((Context)vctx, (Writer)writer);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            LOG.error("Template not merged:  {}", (Object)ex.getMessage());
            throw new MessagingException("Template not merged", (Exception)ex);
        }
        String fullMessage = writer.toString();
        Date date = new Date();
        message.setSentDate(date);
        message.setFrom((Address)new InternetAddress(from));
        for (String string : templateHeaders) {
            String headerValue = (String)vctx.get(string);
            if ("subject".equalsIgnoreCase(string)) {
                if (null == headerValue) continue;
                this.subject = headerValue;
                continue;
            }
            if ("charset".equalsIgnoreCase(string)) {
                this.charset = headerValue;
                continue;
            }
            message.setHeader(string, headerValue);
        }
        if (this.charset != null) {
            message.setSubject(this.subject, this.charset);
        } else {
            message.setSubject(this.subject);
        }
        if (this.attachments.isEmpty() && this.moreAttachments.isEmpty()) {
            if (this.charset != null) {
                message.setText(fullMessage, this.charset);
            } else {
                message.setText(fullMessage);
            }
        } else {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(fullMessage);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (FileAttachment fileAttachment : this.attachments) {
                messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(fileAttachment.file)));
                messageBodyPart.setFileName(fileAttachment.name);
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            for (InputStreamAttachment inputStreamAttachment : this.moreAttachments) {
                messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler((DataSource)new InputStreamDataSource(inputStreamAttachment.name, inputStreamAttachment.mimetype, inputStreamAttachment.is)));
                messageBodyPart.setFileName(inputStreamAttachment.name);
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            message.setContent((Multipart)multipart);
        }
        if (this.replyTo != null) {
            Address[] replyToAddr = new Address[]{new InternetAddress(this.replyTo)};
            message.setReplyTo(replyToAddr);
        }
        if (disabled) {
            StringBuilder text = new StringBuilder("Message not sent due to mail.server.disabled:\n");
            Enumeration headers = message.getAllHeaderLines();
            while (headers.hasMoreElements()) {
                text.append((String)headers.nextElement()).append('\n');
            }
            if (!this.attachments.isEmpty()) {
                text.append("\nAttachments:\n");
                for (FileAttachment fileAttachment : this.attachments) {
                    text.append(fileAttachment.name).append('\n');
                }
                text.append('\n');
            }
            text.append('\n').append(fullMessage);
            LOG.info(text.toString());
        } else {
            Transport.send((Message)message);
        }
    }

    public static Email getEmail(String emailFile) throws IOException {
        String charset = null;
        StringBuilder contentBuffer = new StringBuilder();
        try (FileInputStream is = new FileInputStream(emailFile);
             InputStreamReader ir = new InputStreamReader((InputStream)is, "UTF-8");
             BufferedReader reader = new BufferedReader(ir);){
            boolean more = true;
            while (more) {
                String line = reader.readLine();
                if (line == null) {
                    more = false;
                    continue;
                }
                contentBuffer.append(line);
                contentBuffer.append("\n");
            }
        }
        Email email = new Email();
        email.setContent(emailFile, contentBuffer.toString());
        if (charset != null) {
            email.setCharset(charset);
        }
        return email;
    }

    public static void main(String[] args) {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        String to = config.getProperty("mail.admin");
        String subject = "DSpace test email";
        String server = config.getProperty("mail.server");
        String url = config.getProperty("dspace.ui.url");
        try {
            Email message;
            if (args.length <= 0) {
                message = new Email();
                message.setContent("testing", "This is a test email sent from DSpace: " + url);
            } else {
                message = Email.getEmail(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    message.addArgument(args[i]);
                }
            }
            message.setSubject(subject);
            message.addRecipient(to);
            System.out.println("\nAbout to send test email:");
            System.out.println(" - To: " + to);
            System.out.println(" - Subject: " + subject);
            System.out.println(" - Server: " + server);
            boolean disabled = config.getBooleanProperty("mail.server.disabled", false);
            if (disabled) {
                System.err.println("\nError sending email:");
                System.err.println(" - Error: cannot test email because mail.server.disabled is set to true");
                System.err.println("\nPlease see the DSpace documentation for assistance.\n");
                System.err.println("\n");
                System.exit(1);
                return;
            }
            message.send();
        }
        catch (IOException | MessagingException ex) {
            System.err.println("\nError sending email:");
            System.err.format(" - Error: %s%n", ex);
            System.err.println("\nPlease see the DSpace documentation for assistance.\n");
            System.err.println("\n");
            System.exit(1);
        }
        System.out.println("\nEmail sent successfully!\n");
    }

    static {
        VELOCITY_PROPERTIES.put("resource.loaders", "string");
        VELOCITY_PROPERTIES.put("resource.loader.string.description", "Velocity StringResource loader");
        VELOCITY_PROPERTIES.put("resource.loader.string.class", StringResourceLoader.class.getName());
        VELOCITY_PROPERTIES.put("resource.loader.string.repository.name", RESOURCE_REPOSITORY_NAME);
        VELOCITY_PROPERTIES.put("resource.loader.string.repository.static", "false");
    }

    public static class UnmodifiableConfigurationService {
        private final ConfigurationService configurationService;

        public UnmodifiableConfigurationService(ConfigurationService cs) {
            this.configurationService = cs;
        }

        public String get(String key) {
            return this.configurationService.getProperty(key);
        }
    }

    public static class InputStreamDataSource
    implements DataSource {
        private final String name;
        private final String contentType;
        private final ByteArrayOutputStream baos;

        InputStreamDataSource(String name, String contentType, InputStream inputStream) throws IOException {
            int read;
            this.name = name;
            this.contentType = contentType;
            this.baos = new ByteArrayOutputStream();
            byte[] buff = new byte[256];
            while ((read = inputStream.read(buff)) != -1) {
                this.baos.write(buff, 0, read);
            }
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.baos.toByteArray());
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Cannot write to this read-only resource");
        }
    }

    private static class InputStreamAttachment {
        InputStream is;
        String mimetype;
        String name;

        public InputStreamAttachment(InputStream is, String name, String mimetype) {
            this.is = is;
            this.name = name;
            this.mimetype = mimetype;
        }
    }

    private static class FileAttachment {
        File file;
        String name;

        public FileAttachment(File f, String n) {
            this.file = f;
            this.name = n;
        }
    }
}

