/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.service.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.OrcidToken;
import org.dspace.orcid.dao.OrcidTokenDAO;
import org.dspace.orcid.service.OrcidTokenService;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidTokenServiceImpl
implements OrcidTokenService {
    @Autowired
    private OrcidTokenDAO orcidTokenDAO;

    @Override
    public OrcidToken create(Context context, EPerson ePerson, String accessToken) {
        return this.create(context, ePerson, null, accessToken);
    }

    @Override
    public OrcidToken create(Context context, EPerson ePerson, Item profileItem, String accessToken) {
        OrcidToken orcidToken = new OrcidToken();
        orcidToken.setAccessToken(accessToken);
        orcidToken.setEPerson(ePerson);
        orcidToken.setProfileItem(profileItem);
        try {
            return this.orcidTokenDAO.create(context, orcidToken);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OrcidToken findByEPerson(Context context, EPerson ePerson) {
        return this.orcidTokenDAO.findByEPerson(context, ePerson);
    }

    @Override
    public OrcidToken findByProfileItem(Context context, Item profileItem) {
        return this.orcidTokenDAO.findByProfileItem(context, profileItem);
    }

    @Override
    public void delete(Context context, OrcidToken orcidToken) {
        try {
            this.orcidTokenDAO.delete(context, orcidToken);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteAll(Context context) {
        try {
            List<OrcidToken> tokens = this.orcidTokenDAO.findAll(context, OrcidToken.class);
            for (OrcidToken token : tokens) {
                this.delete(context, token);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteByEPerson(Context context, EPerson ePerson) {
        OrcidToken orcidToken = this.findByEPerson(context, ePerson);
        if (orcidToken != null) {
            this.delete(context, orcidToken);
        }
    }

    @Override
    public void deleteByProfileItem(Context context, Item profileItem) {
        OrcidToken orcidToken = this.findByProfileItem(context, profileItem);
        if (orcidToken != null) {
            this.delete(context, orcidToken);
        }
    }
}

