/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.service.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.orcid.service.MetadataSignatureGenerator;

public class PlainMetadataSignatureGeneratorImpl
implements MetadataSignatureGenerator {
    private static final String SIGNATURE_SECTIONS_SEPARATOR = "\u00a7\u00a7";
    private static final String METADATA_SECTIONS_SEPARATOR = "::";

    @Override
    public String generate(Context context, List<MetadataValue> metadataValues) {
        return metadataValues.stream().sorted(Comparator.comparing(metadataValue -> metadataValue.getMetadataField().getID())).map(this::composeSignatureSection).collect(Collectors.joining(SIGNATURE_SECTIONS_SEPARATOR));
    }

    @Override
    public List<MetadataValue> findBySignature(Context context, Item item, String signature) {
        return this.getSignatureSections(signature).map(signatureSection -> this.findFirstBySignatureSection(context, item, (String)signatureSection)).flatMap(metadataValue -> metadataValue.stream()).collect(Collectors.toList());
    }

    private String composeSignatureSection(MetadataValue metadataValue) {
        String fieldId = this.getField(metadataValue);
        String metadataValueSignature = fieldId + METADATA_SECTIONS_SEPARATOR + this.getValue(metadataValue);
        if (StringUtils.isNotBlank((CharSequence)metadataValue.getAuthority())) {
            return metadataValueSignature + METADATA_SECTIONS_SEPARATOR + metadataValue.getAuthority();
        }
        return metadataValueSignature;
    }

    private Optional<MetadataValue> findFirstBySignatureSection(Context context, Item item, String signatureSection) {
        return item.getMetadata().stream().filter(metadataValue -> this.matchSignature(context, (MetadataValue)metadataValue, signatureSection)).findFirst();
    }

    private boolean matchSignature(Context context, MetadataValue metadataValue, String signatureSection) {
        return this.generate(context, List.of(metadataValue)).equals(signatureSection);
    }

    private Stream<String> getSignatureSections(String signature) {
        return Arrays.stream(StringUtils.split((String)signature, (String)SIGNATURE_SECTIONS_SEPARATOR));
    }

    private String getField(MetadataValue metadataValue) {
        return metadataValue.getMetadataField().toString('.');
    }

    private String getValue(MetadataValue metadataValue) {
        return metadataValue.getValue() != null ? metadataValue.getValue() : "";
    }
}

