/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionAdvancedInfo;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.state.actions.processingaction.SelectReviewerActionAdvancedInfo;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.WorkflowItemRoleService;
import org.springframework.beans.factory.annotation.Autowired;

public class SelectReviewerAction
extends ProcessingAction {
    private static final Logger log = LogManager.getLogger(SelectReviewerAction.class);
    private static final String SUBMIT_CANCEL = "submit_cancel";
    private static final String SUBMIT_SELECT_REVIEWER = "submit_select_reviewer";
    private static final String PARAM_REVIEWER = "eperson";
    private static final String CONFIG_REVIEWER_GROUP = "action.selectrevieweraction.group";
    private Role role;
    @Autowired(required=true)
    private EPersonService ePersonService;
    @Autowired(required=true)
    private WorkflowItemRoleService workflowItemRoleService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private GroupService groupService;
    private static Group selectFromReviewsGroup;
    private static boolean selectFromReviewsGroupInitialised;

    @Override
    public void activate(Context c, XmlWorkflowItem wf) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException {
        String submitButton = Util.getSubmitButton(request, SUBMIT_CANCEL);
        if (submitButton.equals(SUBMIT_CANCEL)) {
            return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
        }
        if (submitButton.startsWith(SUBMIT_SELECT_REVIEWER)) {
            return this.processSelectReviewers(c, wfi, request);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
    }

    private ActionResult processSelectReviewers(Context c, XmlWorkflowItem wfi, HttpServletRequest request) throws SQLException, AuthorizeException {
        Object[] reviewerIds = request.getParameterValues(PARAM_REVIEWER);
        if (ArrayUtils.isEmpty((Object[])reviewerIds)) {
            return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
        }
        ArrayList<EPerson> reviewers = new ArrayList<EPerson>();
        for (Object reviewerId : reviewerIds) {
            EPerson reviewer = (EPerson)this.ePersonService.find(c, UUID.fromString((String)reviewerId));
            if (reviewer == null) {
                log.warn("No EPerson found with uuid {}", reviewerId);
                continue;
            }
            reviewers.add(reviewer);
        }
        if (!this.checkReviewersValid(c, reviewers)) {
            return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
        }
        this.createWorkflowItemRole(c, wfi, reviewers);
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    private boolean checkReviewersValid(Context c, List<EPerson> reviewers) throws SQLException {
        if (reviewers.size() == 0) {
            return false;
        }
        Group group = this.getGroup(c);
        if (group != null) {
            for (EPerson reviewer : reviewers) {
                if (this.groupService.isMember(c, reviewer, group)) continue;
                log.error("Reviewers selected must be member of group {}", (Object)group.getID());
                return false;
            }
        }
        return true;
    }

    private WorkflowItemRole createWorkflowItemRole(Context c, XmlWorkflowItem wfi, List<EPerson> reviewers) throws SQLException, AuthorizeException {
        WorkflowItemRole workflowItemRole = (WorkflowItemRole)this.workflowItemRoleService.create(c);
        workflowItemRole.setRoleId(this.getRole().getId());
        workflowItemRole.setWorkflowItem(wfi);
        if (reviewers.size() == 1) {
            workflowItemRole.setEPerson(reviewers.get(0));
        } else {
            c.turnOffAuthorisationSystem();
            Group selectedReviewsGroup = this.groupService.create(c);
            this.groupService.setName(selectedReviewsGroup, "selectedReviewsGroup_" + wfi.getID());
            for (EPerson reviewer : reviewers) {
                this.groupService.addMember(c, selectedReviewsGroup, reviewer);
            }
            workflowItemRole.setGroup(selectedReviewsGroup);
            c.restoreAuthSystemState();
        }
        this.workflowItemRoleService.update(c, workflowItemRole);
        return workflowItemRole;
    }

    @Override
    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add(SUBMIT_SELECT_REVIEWER);
        options.add("return_to_pool");
        return options;
    }

    @Override
    protected List<String> getAdvancedOptions() {
        return Arrays.asList(SUBMIT_SELECT_REVIEWER);
    }

    @Override
    protected List<ActionAdvancedInfo> getAdvancedInfo() {
        ArrayList<ActionAdvancedInfo> advancedInfo = new ArrayList<ActionAdvancedInfo>();
        SelectReviewerActionAdvancedInfo selectReviewerActionAdvancedInfo = new SelectReviewerActionAdvancedInfo();
        if (this.getGroup(null) != null) {
            selectReviewerActionAdvancedInfo.setGroup(this.getGroup(null).getID().toString());
        }
        selectReviewerActionAdvancedInfo.setType(SUBMIT_SELECT_REVIEWER);
        selectReviewerActionAdvancedInfo.generateId(SUBMIT_SELECT_REVIEWER);
        advancedInfo.add(selectReviewerActionAdvancedInfo);
        return advancedInfo;
    }

    public Role getRole() {
        return this.role;
    }

    @Autowired(required=true)
    public void setRole(Role role) {
        this.role = role;
    }

    private Group getGroup(@Nullable Context context) {
        String groupIdOrName;
        if (selectFromReviewsGroupInitialised) {
            return selectFromReviewsGroup;
        }
        if (context == null) {
            context = new Context();
        }
        if (StringUtils.isNotBlank((CharSequence)(groupIdOrName = this.configurationService.getProperty(CONFIG_REVIEWER_GROUP)))) {
            Group group = null;
            try {
                group = this.groupService.findByName(context, groupIdOrName);
                if (group == null) {
                    group = (Group)this.groupService.find(context, UUID.fromString(groupIdOrName));
                }
            }
            catch (Exception e) {
                log.error("Issue with determining matching group for config {}={} for reviewer group of select reviewers workflow", (Object)CONFIG_REVIEWER_GROUP, (Object)groupIdOrName);
            }
            selectFromReviewsGroup = group;
        }
        selectFromReviewsGroupInitialised = true;
        return selectFromReviewsGroup;
    }

    public static void resetGroup() {
        selectFromReviewsGroup = null;
        selectFromReviewsGroupInitialised = false;
    }

    static {
        selectFromReviewsGroupInitialised = false;
    }
}

