/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.statistics.LogLine;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class LogAnalyser {
    private static Map<String, Integer> actionAggregator;
    private static Map<String, Integer> searchAggregator;
    private static Map<String, Integer> userAggregator;
    private static Map<String, Integer> itemAggregator;
    private static Map<String, Integer> archiveStats;
    private static int warnCount;
    private static int excCount;
    private static int lineCount;
    private static List<String> generalSummary;
    private static List<String> excludeWords;
    private static List<String> excludeTypes;
    private static List<String> excludeChars;
    private static List<String> itemTypes;
    private static int searchFloor;
    private static int itemFloor;
    private static int itemLookup;
    private static String userEmail;
    private static String url;
    private static String name;
    private static String hostName;
    private static long views;
    private static Pattern excludeCharRX;
    private static Pattern handleRX;
    private static Pattern itemRX;
    private static Pattern queryRX;
    private static Pattern collectionRX;
    private static Pattern communityRX;
    private static Pattern resultsRX;
    private static Pattern singleRX;
    private static Pattern valid13;
    private static Pattern validBase;
    private static Pattern valid14;
    private static Pattern logRegex;
    private static final Pattern COMMENT;
    private static final Pattern REAL;
    private static Pattern typeRX;
    private static Pattern wordRX;
    private static Calendar startTime;
    private static String logDir;
    private static String fileTemplate;
    private static String configFile;
    private static String outFile;
    private static Date startDate;
    private static Date endDate;
    private static Date logStartDate;
    private static Date logEndDate;

    private LogAnalyser() {
    }

    public static void main(String[] argv) throws Exception, SQLException {
        startTime = new GregorianCalendar();
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        String myLogDir = null;
        String myFileTemplate = null;
        String myConfigFile = null;
        String myOutFile = null;
        Date myStartDate = null;
        Date myEndDate = null;
        boolean myLookUp = false;
        Options options = new Options();
        Option option = Option.builder().longOpt("log").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("file").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("cfg").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("out").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("help").build();
        options.addOption(option);
        option = Option.builder().longOpt("start").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("end").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("lookup").build();
        options.addOption(option);
        DefaultParser cmdParser = new DefaultParser();
        CommandLine cmd = cmdParser.parse(options, argv);
        if (cmd.hasOption("help")) {
            LogAnalyser.usage();
            System.exit(0);
        }
        if (cmd.hasOption("log")) {
            myLogDir = cmd.getOptionValue("log");
        }
        if (cmd.hasOption("file")) {
            myFileTemplate = cmd.getOptionValue("file");
        }
        if (cmd.hasOption("cfg")) {
            myConfigFile = cmd.getOptionValue("cfg");
        }
        if (cmd.hasOption("out")) {
            myOutFile = cmd.getOptionValue("out");
        }
        if (cmd.hasOption("start")) {
            myStartDate = LogAnalyser.parseDate(cmd.getOptionValue("start"));
        }
        if (cmd.hasOption("end")) {
            myEndDate = LogAnalyser.parseDate(cmd.getOptionValue("end"));
        }
        myLookUp = cmd.hasOption("lookup");
        LogAnalyser.processLogs(context, myLogDir, myFileTemplate, myConfigFile, myOutFile, myStartDate, myEndDate, myLookUp);
    }

    public static String processLogs(Context context, String myLogDir, String myFileTemplate, String myConfigFile, String myOutFile, Date myStartDate, Date myEndDate, boolean myLookUp) throws IOException, SQLException, SearchServiceException {
        startTime = new GregorianCalendar();
        actionAggregator = new HashMap<String, Integer>();
        searchAggregator = new HashMap<String, Integer>();
        userAggregator = new HashMap<String, Integer>();
        itemAggregator = new HashMap<String, Integer>();
        archiveStats = new HashMap<String, Integer>();
        generalSummary = new ArrayList<String>();
        excludeWords = new ArrayList<String>();
        excludeTypes = new ArrayList<String>();
        excludeChars = new ArrayList<String>();
        itemTypes = new ArrayList<String>();
        LogAnalyser.setParameters(myLogDir, myFileTemplate, myConfigFile, myOutFile, myStartDate, myEndDate, myLookUp);
        FileReader fr = null;
        BufferedReader br = null;
        LogAnalyser.readConfig(configFile);
        LogAnalyser.setRegex(fileTemplate);
        File[] logFiles = LogAnalyser.getLogFiles(logDir);
        int i = 0;
        for (i = 0; i < logFiles.length; ++i) {
            Matcher matchRegex = logRegex.matcher(logFiles[i].getName());
            if (!matchRegex.matches()) continue;
            try {
                fr = new FileReader(logFiles[i].toString());
                br = new BufferedReader(fr);
            }
            catch (IOException e) {
                System.out.println("Failed to read log file " + logFiles[i].toString());
                System.exit(0);
            }
            String line = null;
            while ((line = br.readLine()) != null) {
                LogLine logLine = LogAnalyser.getLogLine(line);
                if (logLine == null || startDate != null && !logLine.afterDate(startDate)) continue;
                if (endDate != null && !logLine.beforeDate(endDate)) break;
                ++lineCount;
                if (startDate == null) {
                    if (logStartDate != null) {
                        if (logLine.beforeDate(logStartDate)) {
                            logStartDate = logLine.getDate();
                        }
                    } else {
                        logStartDate = logLine.getDate();
                    }
                }
                if (endDate == null) {
                    if (logEndDate != null) {
                        if (logLine.afterDate(logEndDate)) {
                            logEndDate = logLine.getDate();
                        }
                    } else {
                        logEndDate = logLine.getDate();
                    }
                }
                if (logLine.isLevel("WARN")) {
                    ++warnCount;
                }
                if (logLine.isLevel("ERROR")) {
                    ++excCount;
                }
                if (null == logLine.getAction()) continue;
                if (logLine.isAction("search")) {
                    String[] words;
                    for (String word : words = LogAnalyser.analyseQuery(logLine.getParams())) {
                        searchAggregator.put(word, LogAnalyser.increment(searchAggregator, word));
                    }
                }
                if (logLine.isAction("login") && !userEmail.equals("off")) {
                    userAggregator.put(logLine.getUser(), LogAnalyser.increment(userAggregator, logLine.getUser()));
                }
                if (logLine.isAction("view_item")) {
                    String handle = logLine.getParams();
                    Matcher matchHandle = handleRX.matcher(handle);
                    handle = matchHandle.replaceAll("");
                    Matcher matchItem = itemRX.matcher(handle);
                    handle = matchItem.replaceAll("").trim();
                    itemAggregator.put(handle, LogAnalyser.increment(itemAggregator, handle));
                }
                actionAggregator.put(logLine.getAction(), LogAnalyser.increment(actionAggregator, logLine.getAction()));
            }
            br.close();
            fr.close();
        }
        archiveStats.put("All Items", LogAnalyser.getNumItems(context));
        for (i = 0; i < itemTypes.size(); ++i) {
            archiveStats.put(itemTypes.get(i), LogAnalyser.getNumItems(context, itemTypes.get(i)));
        }
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        hostName = Utils.getHostName(configurationService.getProperty("dspace.ui.url"));
        name = configurationService.getProperty("dspace.name").trim();
        url = configurationService.getProperty("dspace.ui.url").trim();
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        if (archiveStats.get("All Items") != 0) {
            double avg = Math.ceil(actionAggregator.get("view_item").doubleValue() / archiveStats.get("All Items").doubleValue());
            views = Math.round(avg);
        }
        return LogAnalyser.createOutput();
    }

    public static void setParameters(String myLogDir, String myFileTemplate, String myConfigFile, String myOutFile, Date myStartDate, Date myEndDate, boolean myLookUp) {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        logDir = myLogDir != null ? myLogDir : configurationService.getProperty("log.report.dir");
        if (myFileTemplate != null) {
            fileTemplate = myFileTemplate;
        }
        configFile = myConfigFile != null ? myConfigFile : configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "dstat.cfg";
        if (myStartDate != null) {
            startDate = new Date(myStartDate.getTime());
        }
        if (myEndDate != null) {
            endDate = new Date(myEndDate.getTime());
        }
        outFile = myOutFile != null ? myOutFile : configurationService.getProperty("log.report.dir") + File.separator + "dstat.dat";
    }

    public static String createOutput() {
        StringBuilder summary = new StringBuilder();
        Iterator<String> keys = null;
        summary.append("log_lines=").append(Integer.toString(lineCount)).append("\n");
        summary.append("warnings=").append(Integer.toString(warnCount)).append("\n");
        summary.append("exceptions=").append(Integer.toString(excCount)).append("\n");
        for (int i = 0; i < generalSummary.size(); ++i) {
            summary.append("general_summary=").append(generalSummary.get(i)).append("\n");
        }
        summary.append("server_name=").append(hostName).append("\n");
        summary.append("service_name=").append(name).append("\n");
        SimpleDateFormat sdf = new SimpleDateFormat("dd'/'MM'/'yyyy");
        if (startDate != null) {
            summary.append("start_date=").append(sdf.format(startDate)).append("\n");
        } else if (logStartDate != null) {
            summary.append("start_date=").append(sdf.format(logStartDate)).append("\n");
        }
        if (endDate != null) {
            summary.append("end_date=").append(sdf.format(endDate)).append("\n");
        } else if (logEndDate != null) {
            summary.append("end_date=").append(sdf.format(logEndDate)).append("\n");
        }
        for (String key : archiveStats.keySet()) {
            summary.append("archive.").append(key).append("=").append(archiveStats.get(key)).append("\n");
        }
        for (String key : actionAggregator.keySet()) {
            summary.append("action.").append(key).append("=").append(actionAggregator.get(key)).append("\n");
        }
        summary.append("user_email=").append(userEmail).append("\n");
        int address = 1;
        for (String key : userAggregator.keySet()) {
            summary.append("user.");
            if (userEmail.equals("on")) {
                summary.append(key).append("=").append(userAggregator.get(key)).append("\n");
                continue;
            }
            if (!userEmail.equals("alias")) continue;
            summary.append("Address ").append(Integer.toString(address++)).append("=").append(userAggregator.get(key)).append("\n");
        }
        summary.append("search_floor=").append(searchFloor).append("\n");
        for (String key : searchAggregator.keySet()) {
            if (searchAggregator.get(key) < searchFloor) continue;
            summary.append("search.").append(key).append("=").append(searchAggregator.get(key)).append("\n");
        }
        summary.append("item_floor=").append(itemFloor).append("\n");
        summary.append("host_url=").append(url).append("\n");
        summary.append("item_lookup=").append(itemLookup).append("\n");
        for (String key : itemAggregator.keySet()) {
            if (itemAggregator.get(key) < itemFloor) continue;
            summary.append("item.").append(key).append("=").append(itemAggregator.get(key)).append("\n");
        }
        if (views > 0L) {
            summary.append("avg_item_views=").append(views).append("\n");
        }
        GregorianCalendar endTime = new GregorianCalendar();
        long timeInMillis = endTime.getTimeInMillis() - startTime.getTimeInMillis();
        summary.append("analysis_process_time=").append(Long.toString(timeInMillis / 1000L)).append("\n");
        try (BufferedWriter out = new BufferedWriter(new FileWriter(outFile));){
            out.write(summary.toString());
            out.flush();
        }
        catch (IOException e) {
            System.out.println("Unable to write to output file " + outFile);
            System.exit(0);
        }
        return summary.toString();
    }

    public static File[] getLogFiles(String logDir) {
        File logs = new File(logDir);
        if (!logs.isDirectory()) {
            System.out.println("Passed log directory is not a directory");
            System.exit(0);
        }
        return logs.listFiles();
    }

    public static void setRegex(String fileTemplate) {
        StringBuilder charRegEx = new StringBuilder();
        charRegEx.append("[");
        for (int i = 0; i < excludeChars.size(); ++i) {
            charRegEx.append("\\").append(excludeChars.get(i));
        }
        charRegEx.append("]");
        excludeCharRX = Pattern.compile(charRegEx.toString());
        handleRX = Pattern.compile("handle=");
        itemRX = Pattern.compile(",item_id=.*$");
        queryRX = Pattern.compile("query=");
        collectionRX = Pattern.compile("collection_id=[0-9]*,");
        communityRX = Pattern.compile("community_id=[0-9]*,");
        resultsRX = Pattern.compile(",results=(.*)");
        singleRX = Pattern.compile("( . |^. | .$)");
        String logLineBase = "^(\\d\\d\\d\\d-\\d\\d\\-\\d\\d) \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d (\\w+)\\s+\\S+ @ (.*)";
        String logLine13 = "^(\\d\\d\\d\\d-\\d\\d\\-\\d\\d) \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d (\\w+)\\s+\\S+ @ ([^:]+):[^:]+:([^:]+):(.*)";
        String logLine14 = "^(\\d\\d\\d\\d-\\d\\d\\-\\d\\d) \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d (\\w+)\\s+\\S+ @ ([^:]+):[^:]+:[^:]+:([^:]+):(.*)";
        valid13 = Pattern.compile(logLine13);
        valid14 = Pattern.compile(logLine14);
        validBase = Pattern.compile(logLineBase);
        logRegex = Pattern.compile(fileTemplate);
        StringBuilder typeRXString = new StringBuilder();
        typeRXString.append("(");
        for (int i = 0; i < excludeTypes.size(); ++i) {
            if (i > 0) {
                typeRXString.append("|");
            }
            typeRXString.append(excludeTypes.get(i));
        }
        typeRXString.append(")");
        typeRX = Pattern.compile(typeRXString.toString());
        StringBuilder wordRXString = new StringBuilder();
        wordRXString.append("(");
        for (int i = 0; i < excludeWords.size(); ++i) {
            if (i > 0) {
                wordRXString.append("|");
            }
            wordRXString.append(" ").append(excludeWords.get(i)).append(" ");
            wordRXString.append("|");
            wordRXString.append("^").append(excludeWords.get(i)).append(" ");
            wordRXString.append("|");
            wordRXString.append(" ").append(excludeWords.get(i)).append("$");
        }
        wordRXString.append(")");
        wordRX = Pattern.compile(wordRXString.toString());
    }

    public static String getConfigFile() {
        return configFile;
    }

    public static void readConfig() throws IOException {
        LogAnalyser.readConfig(configFile);
    }

    public static void readConfig(String configFile) throws IOException {
        actionAggregator = new HashMap<String, Integer>();
        searchAggregator = new HashMap<String, Integer>();
        userAggregator = new HashMap<String, Integer>();
        itemAggregator = new HashMap<String, Integer>();
        archiveStats = new HashMap<String, Integer>();
        generalSummary = new ArrayList<String>();
        excludeWords = new ArrayList<String>();
        excludeTypes = new ArrayList<String>();
        excludeChars = new ArrayList<String>();
        itemTypes = new ArrayList<String>();
        FileReader fr = null;
        BufferedReader br = null;
        String record = null;
        try {
            fr = new FileReader(configFile);
            br = new BufferedReader(fr);
        }
        catch (IOException e) {
            System.out.println("Failed to read config file: " + configFile);
            System.exit(0);
        }
        while ((record = br.readLine()) != null) {
            Matcher matchComment = COMMENT.matcher(record);
            Matcher matchReal = REAL.matcher(record);
            if (matchComment.matches() || !matchReal.matches()) continue;
            String key = matchReal.group(1).trim();
            String value = matchReal.group(2).trim();
            if (key.equals("general.summary")) {
                actionAggregator.put(value, 0);
                generalSummary.add(value);
            }
            if (key.equals("exclude.word")) {
                excludeWords.add(value);
            }
            if (key.equals("exclude.type")) {
                excludeTypes.add(value);
            }
            if (key.equals("exclude.character")) {
                excludeChars.add(value);
            }
            if (key.equals("item.type")) {
                itemTypes.add(value);
            }
            if (key.equals("item.floor")) {
                itemFloor = Integer.parseInt(value);
            }
            if (key.equals("search.floor")) {
                searchFloor = Integer.parseInt(value);
            }
            if (key.equals("item.lookup")) {
                itemLookup = Integer.parseInt(value);
            }
            if (!key.equals("user.email")) continue;
            userEmail = value;
        }
        br.close();
        fr.close();
    }

    public static Integer increment(Map<String, Integer> map, String key) {
        Integer newValue = null;
        newValue = map.containsKey(key) ? Integer.valueOf(map.get(key) + 1) : Integer.valueOf(1);
        return newValue;
    }

    public static Date parseDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd");
        Date parsedDate = null;
        try {
            parsedDate = sdf.parse(date);
        }
        catch (ParseException e) {
            System.out.println("The date is not in the correct format");
            System.exit(0);
        }
        return parsedDate;
    }

    public static String unParseDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'hh:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static String[] analyseQuery(String query) {
        int i = 0;
        query = query.toLowerCase();
        Matcher matchQuery = queryRX.matcher(query);
        query = matchQuery.replaceAll(" ");
        Matcher matchCollection = collectionRX.matcher(query);
        query = matchCollection.replaceAll(" ");
        Matcher matchCommunity = communityRX.matcher(query);
        query = matchCommunity.replaceAll(" ");
        Matcher matchResults = resultsRX.matcher(query);
        query = matchResults.replaceAll(" ");
        Matcher matchTypes = typeRX.matcher(query);
        query = matchTypes.replaceAll(" ");
        Matcher matchChars = excludeCharRX.matcher(query);
        query = matchChars.replaceAll(" ");
        Matcher matchWords = wordRX.matcher(query);
        query = matchWords.replaceAll(" ");
        Matcher single = singleRX.matcher(query);
        query = single.replaceAll(" ");
        StringTokenizer st = new StringTokenizer(query);
        String[] words = new String[st.countTokens()];
        for (i = 0; i < words.length; ++i) {
            words[i] = st.nextToken().trim();
        }
        return words;
    }

    public static LogLine getLogLine(String line) {
        Matcher match = line.indexOf(":ip_addr") > 0 ? valid14.matcher(line) : valid13.matcher(line);
        if (match.matches()) {
            LogLine logLine = new LogLine(LogAnalyser.parseDate(match.group(1).trim()), LogHelper.unescapeLogField(match.group(2)).trim(), LogHelper.unescapeLogField(match.group(3)).trim(), LogHelper.unescapeLogField(match.group(4)).trim(), LogHelper.unescapeLogField(match.group(5)).trim());
            return logLine;
        }
        match = validBase.matcher(line);
        if (match.matches()) {
            LogLine logLine = new LogLine(LogAnalyser.parseDate(match.group(1).trim()), LogHelper.unescapeLogField(match.group(2)).trim(), null, null, null);
            return logLine;
        }
        return null;
    }

    public static Integer getNumItems(Context context, String type) throws SQLException, SearchServiceException {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            discoverQuery.addFilterQueries("dc.type=" + type + "*");
        }
        StringBuilder accessionedQuery = new StringBuilder();
        accessionedQuery.append("dc.date.accessioned_dt:[");
        if (startDate != null) {
            accessionedQuery.append(LogAnalyser.unParseDate(startDate));
        } else {
            accessionedQuery.append("*");
        }
        accessionedQuery.append(" TO ");
        if (endDate != null) {
            accessionedQuery.append(LogAnalyser.unParseDate(endDate));
        } else {
            accessionedQuery.append("*");
        }
        accessionedQuery.append("]");
        discoverQuery.addFilterQueries(accessionedQuery.toString());
        discoverQuery.addFilterQueries("withdrawn: false");
        discoverQuery.addFilterQueries("archived: true");
        return (int)SearchUtils.getSearchService().search(context, discoverQuery).getTotalSearchResults();
    }

    public static Integer getNumItems(Context context) throws SQLException, SearchServiceException {
        return LogAnalyser.getNumItems(context, null);
    }

    public static void usage() {
        String usage = "Usage Information:\nLogAnalyser [options [parameters]]\n-log [log directory]\n\tOptional\n\tSpecify a directory containing log files\n\tDefault uses [dspace.dir]/log from dspace.cfg\n-file [file name regex]\n\tOptional\n\tSpecify a regular expression as the file name template.\n\tCurrently this needs to be correctly escaped for Java string handling (FIXME)\n\tDefault uses dspace.log*\n-cfg [config file path]\n\tOptional\n\tSpecify a config file to be used\n\tDefault uses dstat.cfg in dspace config directory\n-out [output file path]\n\tOptional\n\tSpecify an output file to write results into\n\tDefault uses dstat.dat in dspace log directory\n-start [YYYY-MM-DD]\n\tOptional\n\tSpecify the start date of the analysis\n\tIf a start date is specified then no attempt to gather \n\tcurrent database statistics will be made unless -lookup is\n\talso passed\n\tDefault is to start from the earliest date records exist for\n-end [YYYY-MM-DD]\n\tOptional\n\tSpecify the end date of the analysis\n\tIf an end date is specified then no attempt to gather \n\tcurrent database statistics will be made unless -lookup is\n\talso passed\n\tDefault is to work up to the last date records exist for\n-lookup\n\tOptional\n\tForce a lookup of the current database statistics\n\tOnly needs to be used if date constraints are also in place\n-help\n\tdisplay this usage information\n";
        System.out.println(usage);
    }

    static {
        warnCount = 0;
        excCount = 0;
        lineCount = 0;
        views = 0L;
        excludeCharRX = null;
        handleRX = null;
        itemRX = null;
        queryRX = null;
        collectionRX = null;
        communityRX = null;
        resultsRX = null;
        singleRX = null;
        valid13 = null;
        validBase = null;
        valid14 = null;
        logRegex = null;
        COMMENT = Pattern.compile("^#");
        REAL = Pattern.compile("^(.+)=(.+)");
        typeRX = null;
        wordRX = null;
        startTime = null;
        fileTemplate = "dspace\\.log.*";
        startDate = null;
        endDate = null;
        logStartDate = null;
        logEndDate = null;
    }
}

