/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.crossref;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.el.MethodNotFoundException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.DoiCheck;
import org.dspace.importer.external.service.components.QuerySource;
import org.springframework.beans.factory.annotation.Autowired;

public class CrossRefImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<String>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    private String url;
    @Autowired
    private LiveImportClient liveImportClient;

    @Override
    public String getImportSource() {
        return "crossref";
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public ImportRecord getRecord(String recordId) throws MetadataSourceException {
        String id = this.getID(recordId);
        List<ImportRecord> records = StringUtils.isNotBlank((CharSequence)id) ? this.retry(new SearchByIdCallable(id)) : this.retry(new SearchByIdCallable(recordId));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        String id = this.getID(query);
        return StringUtils.isNotBlank((CharSequence)id) ? this.retry(new DoiCheckCallable(id)).intValue() : this.retry(new CountByQueryCallable(query)).intValue();
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        String id = this.getID(query.toString());
        return StringUtils.isNotBlank((CharSequence)id) ? this.retry(new DoiCheckCallable(id)).intValue() : this.retry(new CountByQueryCallable(query)).intValue();
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        String id = this.getID(query.toString());
        return StringUtils.isNotBlank((CharSequence)id) ? (Collection)this.retry(new SearchByIdCallable(id)) : (Collection)this.retry(new SearchByQueryCallable(query, count, start));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        String id = this.getID(query.toString());
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return this.retry(new SearchByIdCallable(id));
        }
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        String id = this.getID(query.toString());
        List<ImportRecord> records = StringUtils.isNotBlank((CharSequence)id) ? this.retry(new SearchByIdCallable(id)) : this.retry(new SearchByIdCallable(query));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        String id = this.getID(query.toString());
        return StringUtils.isNotBlank((CharSequence)id) ? (Collection)this.retry(new SearchByIdCallable(id)) : (Collection)this.retry(new FindMatchingRecordCallable(query));
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new MethodNotFoundException("This method is not implemented for CrossRef");
    }

    public String getID(String id) {
        return DoiCheck.isDoi(id) ? "filter=doi:" + id : "";
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        try {
            return new ObjectMapper().readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
            return null;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private class DoiCheckCallable
    implements Callable<Integer> {
        private final Query query;

        private DoiCheckCallable(String id) {
            Query query = new Query();
            query.addParameter("id", StringUtils.trim((String)id));
            this.query = query;
        }

        private DoiCheckCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            URIBuilder uriBuilder = new URIBuilder(CrossRefImportMetadataSourceServiceImpl.this.url);
            uriBuilder.setPath(uriBuilder.getPath() + "/" + this.query.getParameterAsClass("id", String.class));
            String responseString = CrossRefImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            JsonNode jsonNode = CrossRefImportMetadataSourceServiceImpl.this.convertStringJsonToJsonNode(responseString);
            return StringUtils.equals((CharSequence)jsonNode.at("/status").toString(), (CharSequence)"ok") ? 1 : 0;
        }
    }

    private class CountByQueryCallable
    implements Callable<Integer> {
        private Query query;

        private CountByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", StringUtils.trim((String)queryString));
        }

        private CountByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            URIBuilder uriBuilder = new URIBuilder(CrossRefImportMetadataSourceServiceImpl.this.url);
            uriBuilder.addParameter("query", this.query.getParameterAsClass("query", String.class));
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String responseString = CrossRefImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            JsonNode jsonNode = CrossRefImportMetadataSourceServiceImpl.this.convertStringJsonToJsonNode(responseString);
            return jsonNode.at("/message/total-results").asInt();
        }
    }

    private class FindMatchingRecordCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private FindMatchingRecordCallable(Query q) {
            this.query = q;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            String queryValue = this.query.getParameterAsClass("query", String.class);
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            String author = this.query.getParameterAsClass("author", String.class);
            String title = this.query.getParameterAsClass("title", String.class);
            String bibliographics = this.query.getParameterAsClass("bibliographics", String.class);
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            URIBuilder uriBuilder = new URIBuilder(CrossRefImportMetadataSourceServiceImpl.this.url);
            if (Objects.nonNull(queryValue)) {
                uriBuilder.addParameter("query", queryValue);
            }
            if (Objects.nonNull(count)) {
                uriBuilder.addParameter("rows", count.toString());
            }
            if (Objects.nonNull(start)) {
                uriBuilder.addParameter("offset", start.toString());
            }
            if (Objects.nonNull(author)) {
                uriBuilder.addParameter("query.author", author);
            }
            if (Objects.nonNull(title)) {
                uriBuilder.addParameter("query.container-title", title);
            }
            if (Objects.nonNull(bibliographics)) {
                uriBuilder.addParameter("query.bibliographic", bibliographics);
            }
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String resp = CrossRefImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            JsonNode jsonNode = CrossRefImportMetadataSourceServiceImpl.this.convertStringJsonToJsonNode(resp);
            for (JsonNode node : jsonNode.at("/message/items")) {
                if (node.isMissingNode()) continue;
                results.add(CrossRefImportMetadataSourceServiceImpl.this.transformSourceRecords(node.toString()));
            }
            return results;
        }
    }

    private class SearchByIdCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByIdCallable(Query query) {
            this.query = query;
        }

        private SearchByIdCallable(String id) {
            this.query = new Query();
            this.query.addParameter("id", StringUtils.trim((String)id));
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            URIBuilder uriBuilder = new URIBuilder(CrossRefImportMetadataSourceServiceImpl.this.url);
            String ID = URLDecoder.decode(this.query.getParameterAsClass("id", String.class), "UTF-8");
            uriBuilder.setPath(uriBuilder.getPath() + "/" + ID);
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String responseString = CrossRefImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            JsonNode jsonNode = CrossRefImportMetadataSourceServiceImpl.this.convertStringJsonToJsonNode(responseString);
            JsonNode messageNode = jsonNode.at("/message");
            if (!messageNode.isMissingNode()) {
                results.add(CrossRefImportMetadataSourceServiceImpl.this.transformSourceRecords(messageNode.toString()));
            }
            return results;
        }
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString, Integer maxResult, Integer start) {
            this.query = new Query();
            this.query.addParameter("query", StringUtils.trim((String)queryString));
            this.query.addParameter("count", maxResult);
            this.query.addParameter("start", start);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            URIBuilder uriBuilder = new URIBuilder(CrossRefImportMetadataSourceServiceImpl.this.url);
            uriBuilder.addParameter("query", this.query.getParameterAsClass("query", String.class));
            if (Objects.nonNull(count)) {
                uriBuilder.addParameter("rows", count.toString());
            }
            if (Objects.nonNull(start)) {
                uriBuilder.addParameter("offset", start.toString());
            }
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = CrossRefImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            JsonNode jsonNode = CrossRefImportMetadataSourceServiceImpl.this.convertStringJsonToJsonNode(response);
            for (JsonNode node : jsonNode.at("/message/items")) {
                if (node.isMissingNode()) continue;
                results.add(CrossRefImportMetadataSourceServiceImpl.this.transformSourceRecords(node.toString()));
            }
            return results;
        }
    }
}

