/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import javax.inject.Named;
import org.apache.http.client.HttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.dspace.service.impl.HttpConnectionPoolService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrStatisticsCore {
    private static final Logger log = LogManager.getLogger();
    protected SolrClient solr = null;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    @Named(value="solrHttpConnectionPoolService")
    private HttpConnectionPoolService httpConnectionPoolService;

    public SolrClient getSolr() {
        if (this.solr == null) {
            this.initSolr();
        }
        return this.solr;
    }

    protected void initSolr() {
        String solrService = this.configurationService.getProperty("solr-statistics.server");
        log.info("solr-statistics.server:  {}", (Object)solrService);
        log.info("usage-statistics.dbfile:  {}", (Object)this.configurationService.getProperty("usage-statistics.dbfile"));
        try {
            this.solr = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(solrService).withHttpClient((HttpClient)this.httpConnectionPoolService.getClient())).build();
        }
        catch (Exception e) {
            log.error("Error accessing Solr server configured in 'solr-statistics.server'", (Throwable)e);
        }
    }
}

