/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.checker.service.ChecksumHistoryService;
import org.dspace.content.Bitstream;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.storage.bitstore.BitStoreService;
import org.dspace.storage.bitstore.service.BitstreamStorageService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class BitstreamStorageServiceImpl
implements BitstreamStorageService,
InitializingBean {
    private static final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ChecksumHistoryService checksumHistoryService;
    private Map<Integer, BitStoreService> stores = new HashMap<Integer, BitStoreService>();
    private int incoming;
    protected final String REGISTERED_FLAG = "-R";

    protected BitstreamStorageServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        for (Map.Entry<Integer, BitStoreService> storeEntry : this.stores.entrySet()) {
            if (!storeEntry.getValue().isEnabled() || storeEntry.getValue().isInitialized()) continue;
            storeEntry.getValue().init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID store(Context context, Bitstream bitstream, InputStream is) throws SQLException, IOException {
        String id = Utils.generateKey();
        bitstream.setStoreNumber(this.incoming);
        bitstream.setDeleted(true);
        bitstream.setInternalId(id);
        BitStoreService store = this.getStore(this.incoming);
        store.put(bitstream, is);
        bitstream.setDeleted(false);
        try {
            context.turnOffAuthorisationSystem();
            this.bitstreamService.update(context, bitstream);
        }
        catch (AuthorizeException e) {
            log.error((Object)e);
        }
        finally {
            context.restoreAuthSystemState();
        }
        UUID bitstreamId = bitstream.getID();
        if (log.isDebugEnabled()) {
            log.debug("Stored bitstreamID " + bitstreamId);
        }
        return bitstreamId;
    }

    @Override
    public UUID register(Context context, Bitstream bitstream, int assetstore, String bitstreamPath) throws SQLException, IOException, AuthorizeException {
        String sInternalId = "-R" + bitstreamPath;
        bitstream.setDeleted(true);
        bitstream.setInternalId(sInternalId);
        bitstream.setStoreNumber(assetstore);
        this.bitstreamService.update(context, bitstream);
        List<String> wantedMetadata = List.of("size_bytes", "checksum", "checksum_algorithm");
        Map<String, Object> receivedMetadata = this.getStore(assetstore).about(bitstream, wantedMetadata);
        if (MapUtils.isEmpty(receivedMetadata)) {
            String message = "Not able to register bitstream:" + bitstream.getID() + " at path: " + bitstreamPath;
            log.error(message);
            throw new IOException(message);
        }
        if (receivedMetadata.containsKey("checksum_algorithm")) {
            bitstream.setChecksumAlgorithm(receivedMetadata.get("checksum_algorithm").toString());
        }
        if (receivedMetadata.containsKey("checksum")) {
            bitstream.setChecksum(receivedMetadata.get("checksum").toString());
        }
        if (receivedMetadata.containsKey("size_bytes")) {
            bitstream.setSizeBytes(Long.valueOf(receivedMetadata.get("size_bytes").toString()));
        }
        bitstream.setDeleted(false);
        this.bitstreamService.update(context, bitstream);
        UUID bitstreamId = bitstream.getID();
        if (log.isDebugEnabled()) {
            log.debug("Registered bitstream " + bitstreamId + " at location " + bitstreamPath);
        }
        return bitstreamId;
    }

    @Override
    public Map<String, Object> computeChecksum(Context context, Bitstream bitstream) throws IOException {
        return this.getStore(bitstream.getStoreNumber()).about(bitstream, List.of("checksum", "checksum_algorithm"));
    }

    @Override
    public boolean isRegisteredBitstream(String internalId) {
        return internalId.startsWith("-R");
    }

    @Override
    public InputStream retrieve(Context context, Bitstream bitstream) throws SQLException, IOException {
        Integer storeNumber = bitstream.getStoreNumber();
        return this.getStore(storeNumber).get(bitstream);
    }

    @Override
    public void cleanup(boolean deleteDbRecords, boolean verbose) throws SQLException, IOException, AuthorizeException {
        Context context = new Context(Context.Mode.BATCH_EDIT);
        int offset = 0;
        int limit = 100;
        int cleanedBitstreamCount = 0;
        int deletedBitstreamCount = this.bitstreamService.countDeletedBitstreams(context);
        System.out.println("Found " + deletedBitstreamCount + " deleted bistream to cleanup");
        try {
            List<Bitstream> storage;
            context.turnOffAuthorisationSystem();
            while (cleanedBitstreamCount < deletedBitstreamCount && !CollectionUtils.isEmpty(storage = this.bitstreamService.findDeletedBitstreams(context, limit, offset))) {
                for (Bitstream bitstream : storage) {
                    UUID bid = bitstream.getID();
                    List<String> wantedMetadata = List.of("size_bytes", "modified");
                    Map<String, Object> receivedMetadata = this.getStore(bitstream.getStoreNumber()).about(bitstream, wantedMetadata);
                    if (MapUtils.isEmpty(receivedMetadata)) {
                        log.debug("bitstore.about is empty, so file is not present");
                        if (deleteDbRecords) {
                            log.debug("deleting record");
                            if (verbose) {
                                System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
                            }
                            this.checksumHistoryService.deleteByBitstream(context, bitstream);
                            if (verbose) {
                                System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
                            }
                            this.bitstreamService.expunge(context, bitstream);
                        }
                        context.uncacheEntity(bitstream);
                        continue;
                    }
                    if (this.isRecent(Long.valueOf(receivedMetadata.get("modified").toString()))) {
                        log.debug("file is recent");
                        context.uncacheEntity(bitstream);
                        continue;
                    }
                    if (deleteDbRecords) {
                        log.debug("deleting db record");
                        if (verbose) {
                            System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
                        }
                        this.checksumHistoryService.deleteByBitstream(context, bitstream);
                        if (verbose) {
                            System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
                        }
                        this.bitstreamService.expunge(context, bitstream);
                    }
                    if (this.isRegisteredBitstream(bitstream.getInternalId())) {
                        context.uncacheEntity(bitstream);
                        continue;
                    }
                    if (this.bitstreamService.findDuplicateInternalIdentifier(context, bitstream).isEmpty()) {
                        this.getStore(bitstream.getStoreNumber()).remove(bitstream);
                        String message = "Deleted bitstreamID " + bid + ", internalID " + bitstream.getInternalId();
                        if (log.isDebugEnabled()) {
                            log.debug(message);
                        }
                        if (verbose) {
                            System.out.println(message);
                        }
                    }
                    context.uncacheEntity(bitstream);
                }
                System.out.print("Performing incremental commit to the database...");
                context.commit();
                System.out.println(" Incremental commit done!");
                cleanedBitstreamCount += storage.size();
                if (deleteDbRecords) continue;
                offset += limit;
            }
            System.out.print("Committing changes to the database...");
            context.complete();
            System.out.println(" Done!");
        }
        catch (IOException | SQLException sqle) {
            if (verbose) {
                System.err.println("Error: " + sqle.getMessage());
            }
            context.abort();
            throw sqle;
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    @Override
    @Nullable
    public Long getLastModified(Bitstream bitstream) throws IOException {
        Map<String, Object> metadata = this.getStore(bitstream.getStoreNumber()).about(bitstream, List.of("modified"));
        if (metadata == null || !metadata.containsKey("modified")) {
            return null;
        }
        return Long.valueOf(metadata.get("modified").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitstream clone(Context context, Bitstream bitstream) throws SQLException, IOException, AuthorizeException {
        Bitstream clonedBitstream = null;
        try {
            context.turnOffAuthorisationSystem();
            clonedBitstream = this.bitstreamService.clone(context, bitstream);
            clonedBitstream.setStoreNumber(bitstream.getStoreNumber());
            List<MetadataValue> metadataValues = this.bitstreamService.getMetadata(bitstream, "*", "*", "*", "*");
            for (MetadataValue metadataValue : metadataValues) {
                this.bitstreamService.addMetadata(context, clonedBitstream, metadataValue.getMetadataField(), metadataValue.getLanguage(), metadataValue.getValue(), metadataValue.getAuthority(), metadataValue.getConfidence());
            }
            this.bitstreamService.update(context, clonedBitstream);
        }
        catch (AuthorizeException e) {
            log.error((Object)e);
        }
        finally {
            context.restoreAuthSystemState();
        }
        return clonedBitstream;
    }

    @Override
    public void migrate(Context context, Integer assetstoreSource, Integer assetstoreDestination, boolean deleteOld, Integer batchCommitSize) throws IOException, SQLException, AuthorizeException {
        Iterator<Bitstream> allBitstreamsInSource = this.bitstreamService.findByStoreNumber(context, assetstoreSource);
        int processedCounter = 0;
        while (allBitstreamsInSource.hasNext()) {
            Bitstream bitstream = allBitstreamsInSource.next();
            log.info("Copying bitstream:" + bitstream.getID() + " from assetstore[" + assetstoreSource + "] to assetstore[" + assetstoreDestination + "] Name:" + bitstream.getName() + ", SizeBytes:" + bitstream.getSizeBytes());
            InputStream inputStream = this.retrieve(context, bitstream);
            this.getStore(assetstoreDestination).put(bitstream, inputStream);
            bitstream.setStoreNumber(assetstoreDestination);
            this.bitstreamService.update(context, bitstream);
            if (deleteOld) {
                log.info("Removing bitstream:" + bitstream.getID() + " from assetstore[" + assetstoreSource + "]");
                this.getStore(assetstoreSource).remove(bitstream);
            }
            context.uncacheEntity(bitstream);
            if (++processedCounter % batchCommitSize != 0) continue;
            log.info("Migration Commit Checkpoint: " + processedCounter);
            context.dispatchEvents();
        }
        log.info("Assetstore Migration from assetstore[" + assetstoreSource + "] to assetstore[" + assetstoreDestination + "] completed. " + processedCounter + " objects were transferred.");
    }

    @Override
    public void printStores(Context context) {
        try {
            for (Integer storeNumber : this.stores.keySet()) {
                long countBitstreams = this.bitstreamService.countByStoreNumber(context, storeNumber);
                BitStoreService store = this.stores.get(storeNumber);
                System.out.println("store[" + storeNumber + "] == " + store.getClass().getSimpleName() + ", which has initialized-status: " + store.isInitialized() + ", and has: " + countBitstreams + " bitstreams.");
            }
            System.out.println("Incoming assetstore is store[" + this.incoming + "]");
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
    }

    public int getIncoming() {
        return this.incoming;
    }

    public void setIncoming(int incoming) {
        this.incoming = incoming;
    }

    public void setStores(Map<Integer, BitStoreService> stores) {
        this.stores = stores;
    }

    public Map<Integer, BitStoreService> getStores() {
        return this.stores;
    }

    protected boolean isRecent(Long lastModified) {
        long now = new Date().getTime();
        if (lastModified >= now) {
            return true;
        }
        return now - lastModified < 60000L;
    }

    protected BitStoreService getStore(int position) throws IOException {
        BitStoreService bitStoreService = this.stores.get(position);
        if (!bitStoreService.isInitialized()) {
            bitStoreService.init();
        }
        return bitStoreService;
    }
}

