/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class SingleUserReviewAction
extends ProcessingAction {
    private static final Logger log = LogManager.getLogger(SingleUserReviewAction.class);
    public static final int OUTCOME_REJECT = 1;
    protected static final String SUBMIT_DECLINE_TASK = "submit_decline_task";

    @Override
    public void activate(Context c, XmlWorkflowItem wfItem) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException, WorkflowException {
        if (!super.isOptionInParam(request)) {
            return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
        }
        switch (Util.getSubmitButton(request, "submit_cancel")) {
            case "submit_approve": {
                return this.processAccept(c, wfi);
            }
            case "submit_reject": {
                return this.processReject(c, wfi, request);
            }
            case "submit_decline_task": {
                return this.processDecline(c, wfi);
            }
        }
        return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
    }

    private ActionResult processReject(Context c, XmlWorkflowItem wfi, HttpServletRequest request) throws SQLException, IOException, AuthorizeException {
        if (wfi.getSubmitter() == null) {
            return this.processDelete(c, wfi);
        }
        return super.processRejectPage(c, wfi, request);
    }

    public ActionResult processAccept(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException {
        super.addApprovedProvenance(c, wfi);
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    @Override
    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("submit_approve");
        options.add("submit_reject");
        options.add(SUBMIT_DECLINE_TASK);
        return options;
    }

    private ActionResult processDelete(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException, IOException {
        EPerson user = c.getCurrentUser();
        c.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().abort(c, wfi, user);
        ContentServiceFactory.getInstance().getWorkspaceItemService().deleteAll(c, workspaceItem);
        c.restoreAuthSystemState();
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }

    private ActionResult processDecline(Context c, XmlWorkflowItem wfi) throws SQLException, IOException, AuthorizeException, WorkflowException {
        c.turnOffAuthorisationSystem();
        this.xmlWorkflowService.restartWorkflow(c, wfi, c.getCurrentUser(), this.getProvenanceStartId());
        c.restoreAuthSystemState();
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }
}

