/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.solrdatabaseresync;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.app.solrdatabaseresync.SolrDatabaseResyncCliScriptConfiguration;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SolrSearchCore;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.factory.IndexObjectFactoryFactory;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.SolrUtils;
import org.dspace.utils.DSpace;

public class SolrDatabaseResyncCli
extends DSpaceRunnable<SolrDatabaseResyncCliScriptConfiguration> {
    private static final Logger log = LogManager.getLogger(SolrDatabaseResyncCli.class);
    public static final String TIME_UNTIL_REINDEX_PROPERTY = "solr-database-resync.time-until-reindex";
    private IndexingService indexingService;
    private SolrSearchCore solrSearchCore;
    private IndexObjectFactoryFactory indexObjectServiceFactory;
    private ConfigurationService configurationService;
    private int timeUntilReindex = 0;
    private String maxTime;

    @Override
    public SolrDatabaseResyncCliScriptConfiguration getScriptConfiguration() {
        return (SolrDatabaseResyncCliScriptConfiguration)new DSpace().getServiceManager().getServiceByName("solr-database-resync", SolrDatabaseResyncCliScriptConfiguration.class);
    }

    public static void runScheduled() throws Exception {
        SolrDatabaseResyncCli script = new SolrDatabaseResyncCli();
        script.setup();
        script.internalRun();
    }

    @Override
    public void setup() throws ParseException {
        this.indexingService = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
        this.solrSearchCore = (SolrSearchCore)DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrSearchCore.class).get(0);
        this.indexObjectServiceFactory = IndexObjectFactoryFactory.getInstance();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    @Override
    public void internalRun() throws Exception {
        this.logInfoAndOut("Starting Item resync of Solr and Database...");
        this.timeUntilReindex = this.getTimeUntilReindex();
        this.maxTime = this.getMaxTime();
        Context context = new Context();
        try {
            context.turnOffAuthorisationSystem();
            this.performStatusUpdate(context);
        }
        finally {
            context.restoreAuthSystemState();
            context.complete();
        }
    }

    private void performStatusUpdate(Context context) throws SearchServiceException, SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery("database_status:predb");
        solrQuery.addFilterQuery(new String[]{"search.resourcetype:" + IndexableItem.TYPE});
        String dateRangeFilter = "SolrIndexer.lastIndexed:[* TO " + this.maxTime + "]";
        this.logDebugAndOut("Date range filter used; " + dateRangeFilter);
        solrQuery.addFilterQuery(new String[]{dateRangeFilter});
        solrQuery.addField("search.resourceid");
        solrQuery.addField("search.uniqueid");
        QueryResponse response = this.solrSearchCore.getSolr().query((SolrParams)solrQuery, this.solrSearchCore.REQUEST_METHOD);
        if (response != null) {
            this.logInfoAndOut(response.getResults().size() + " items found to process");
            for (SolrDocument doc : response.getResults()) {
                String uuid = (String)doc.getFirstValue("search.resourceid");
                String uniqueId = (String)doc.getFirstValue("search.uniqueid");
                this.logDebugAndOut("Processing item with UUID: " + uuid);
                Optional indexableObject = Optional.empty();
                try {
                    indexableObject = this.indexObjectServiceFactory.getIndexableObjectFactory(uniqueId).findIndexableObject(context, uuid);
                }
                catch (SQLException e) {
                    log.warn("An exception occurred when attempting to retrieve item with UUID \"" + uuid + "\" from the database, removing related solr document", (Throwable)e);
                }
                try {
                    if (indexableObject.isPresent()) {
                        this.logDebugAndOut("Item exists in DB, updating solr document");
                        this.updateItem(context, (IndexableObject)indexableObject.get());
                        continue;
                    }
                    this.logDebugAndOut("Item doesn't exist in DB, removing solr document");
                    this.removeItem(context, uniqueId);
                }
                catch (IOException | SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.indexingService.commit();
    }

    private void updateItem(Context context, IndexableObject indexableObject) throws SolrServerException, IOException {
        HashMap<String, Object> fieldModifier = new HashMap<String, Object>(1);
        fieldModifier.put("remove", "predb");
        this.indexingService.atomicUpdate(context, indexableObject.getUniqueIndexID(), "database_status", fieldModifier);
    }

    private void removeItem(Context context, String uniqueId) throws IOException, SQLException {
        this.indexingService.unIndexContent(context, uniqueId);
    }

    private String getMaxTime() {
        Calendar cal = Calendar.getInstance();
        if (this.timeUntilReindex > 0) {
            cal.add(14, -this.timeUntilReindex);
        }
        return SolrUtils.getDateFormatter().format(cal.getTime());
    }

    private int getTimeUntilReindex() {
        return this.configurationService.getIntProperty(TIME_UNTIL_REINDEX_PROPERTY, 0);
    }

    private void logInfoAndOut(String message) {
        log.info(message);
        System.out.println(message);
    }

    private void logDebugAndOut(String message) {
        log.debug(message);
        System.out.println(message);
    }
}

