/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.EntityType;
import org.dspace.content.RelationshipType;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InitializeEntities {
    private static final Logger log = LogManager.getLogger();
    private final RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
    private final EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();

    private InitializeEntities() {
    }

    public static void main(String[] argv) throws SQLException, AuthorizeException, ParseException {
        InitializeEntities initializeEntities = new InitializeEntities();
        DefaultParser parser = new DefaultParser();
        Options options = InitializeEntities.createCommandLineOptions();
        CommandLine line = parser.parse(options, argv);
        String fileLocation = InitializeEntities.getFileLocationFromCommandLine(line);
        InitializeEntities.checkHelpEntered(options, line);
        initializeEntities.run(fileLocation);
    }

    private static void checkHelpEntered(Options options, CommandLine line) {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Intialize Entities", options);
            System.exit(0);
        }
    }

    private static String getFileLocationFromCommandLine(CommandLine line) {
        String query = line.getOptionValue("f");
        if (StringUtils.isEmpty((CharSequence)query)) {
            System.out.println("No file location was entered");
            log.info("No file location was entered");
            System.exit(1);
        }
        return query;
    }

    protected static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption("f", "file", true, "the location for the file containing the xml data");
        return options;
    }

    private void run(String fileLocation) throws SQLException, AuthorizeException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        this.parseXMLToRelations(context, fileLocation);
        context.complete();
    }

    private void parseXMLToRelations(Context context, String fileLocation) throws AuthorizeException {
        try {
            File fXmlFile = new File(fileLocation);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("type");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node;
                int j;
                Node nNode = nList.item(i);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                String leftType = eElement.getElementsByTagName("leftType").item(0).getTextContent();
                String rightType = eElement.getElementsByTagName("rightType").item(0).getTextContent();
                String leftwardType = eElement.getElementsByTagName("leftwardType").item(0).getTextContent();
                String rightwardType = eElement.getElementsByTagName("rightwardType").item(0).getTextContent();
                Node copyToLeftNode = eElement.getElementsByTagName("copyToLeft").item(0);
                Boolean copyToLeft = copyToLeftNode == null ? Boolean.valueOf(false) : Boolean.valueOf(copyToLeftNode.getTextContent());
                Node copyToRightNode = eElement.getElementsByTagName("copyToRight").item(0);
                Boolean copyToRight = copyToRightNode == null ? Boolean.valueOf(false) : Boolean.valueOf(copyToRightNode.getTextContent());
                Node tiltedNode = eElement.getElementsByTagName("tilted").item(0);
                RelationshipType.Tilted tilted = tiltedNode == null ? RelationshipType.Tilted.NONE : RelationshipType.Tilted.valueOf(tiltedNode.getTextContent().toUpperCase());
                NodeList leftCardinalityList = eElement.getElementsByTagName("leftCardinality");
                NodeList rightCardinalityList = eElement.getElementsByTagName("rightCardinality");
                String leftCardinalityMin = "";
                String leftCardinalityMax = "";
                String rightCardinalityMin = "";
                String rightCardinalityMax = "";
                for (j = 0; j < leftCardinalityList.getLength(); ++j) {
                    node = leftCardinalityList.item(j);
                    leftCardinalityMin = this.getString(leftCardinalityMin, (Element)node, "min");
                    leftCardinalityMax = this.getString(leftCardinalityMax, (Element)node, "max");
                }
                for (j = 0; j < rightCardinalityList.getLength(); ++j) {
                    node = rightCardinalityList.item(j);
                    rightCardinalityMin = this.getString(rightCardinalityMin, (Element)node, "min");
                    rightCardinalityMax = this.getString(rightCardinalityMax, (Element)node, "max");
                }
                this.populateRelationshipType(context, leftType, rightType, leftwardType, rightwardType, leftCardinalityMin, leftCardinalityMax, rightCardinalityMin, rightCardinalityMax, copyToLeft, copyToRight, tilted);
            }
        }
        catch (IOException | SQLException | ParserConfigurationException | SAXException e) {
            log.error("An error occurred while parsing the XML file to relations", (Throwable)e);
        }
    }

    private String getString(String leftCardinalityMin, Element node, String minOrMax) {
        if (node.getElementsByTagName(minOrMax).getLength() > 0) {
            leftCardinalityMin = node.getElementsByTagName(minOrMax).item(0).getTextContent();
        }
        return leftCardinalityMin;
    }

    private void populateRelationshipType(Context context, String leftType, String rightType, String leftwardType, String rightwardType, String leftCardinalityMin, String leftCardinalityMax, String rightCardinalityMin, String rightCardinalityMax, Boolean copyToLeft, Boolean copyToRight, RelationshipType.Tilted tilted) throws SQLException, AuthorizeException {
        EntityType rightEntityType;
        EntityType leftEntityType = this.entityTypeService.findByEntityType(context, leftType);
        if (leftEntityType == null) {
            leftEntityType = this.entityTypeService.create(context, leftType);
        }
        if ((rightEntityType = this.entityTypeService.findByEntityType(context, rightType)) == null) {
            rightEntityType = this.entityTypeService.create(context, rightType);
        }
        Integer leftCardinalityMinInteger = StringUtils.isNotBlank((CharSequence)leftCardinalityMin) ? Integer.valueOf(Integer.parseInt(leftCardinalityMin)) : null;
        Integer leftCardinalityMaxInteger = StringUtils.isNotBlank((CharSequence)leftCardinalityMax) ? Integer.valueOf(Integer.parseInt(leftCardinalityMax)) : null;
        Integer rightCardinalityMinInteger = StringUtils.isNotBlank((CharSequence)rightCardinalityMin) ? Integer.valueOf(Integer.parseInt(rightCardinalityMin)) : null;
        Integer rightCardinalityMaxInteger = StringUtils.isNotBlank((CharSequence)rightCardinalityMax) ? Integer.valueOf(Integer.parseInt(rightCardinalityMax)) : null;
        RelationshipType relationshipType = this.relationshipTypeService.findbyTypesAndTypeName(context, leftEntityType, rightEntityType, leftwardType, rightwardType);
        if (relationshipType == null) {
            this.relationshipTypeService.create(context, leftEntityType, rightEntityType, leftwardType, rightwardType, leftCardinalityMinInteger, leftCardinalityMaxInteger, rightCardinalityMinInteger, rightCardinalityMaxInteger, copyToLeft, copyToRight, tilted);
        } else {
            relationshipType.setCopyToLeft(copyToLeft);
            relationshipType.setCopyToRight(copyToRight);
            relationshipType.setTilted(tilted);
            relationshipType.setLeftMinCardinality(leftCardinalityMinInteger);
            relationshipType.setLeftMaxCardinality(leftCardinalityMaxInteger);
            relationshipType.setRightMinCardinality(rightCardinalityMinInteger);
            relationshipType.setRightMaxCardinality(rightCardinalityMaxInteger);
            this.relationshipTypeService.update(context, relationshipType);
        }
    }
}

