/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.FilterUtils;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.embargo.service.EmbargoService;
import org.dspace.event.Event;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.supervision.SupervisionOrder;
import org.dspace.supervision.service.SupervisionOrderService;
import org.springframework.beans.factory.annotation.Autowired;

public class InstallItemServiceImpl
implements InstallItemService {
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected EmbargoService embargoService;
    @Autowired(required=true)
    protected IdentifierService identifierService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected SupervisionOrderService supervisionOrderService;
    @Autowired(required=false)
    Logger log = LogManager.getLogger(InstallItemServiceImpl.class);

    protected InstallItemServiceImpl() {
    }

    @Override
    public Item installItem(Context c, InProgressSubmission is) throws SQLException, AuthorizeException {
        return this.installItem(c, is, null);
    }

    @Override
    public Item installItem(Context c, InProgressSubmission is, String suppliedHandle) throws SQLException, AuthorizeException {
        Item item = is.getItem();
        Collection collection = is.getCollection();
        Map<Class<? extends Identifier>, Filter> filters = FilterUtils.getIdentifierFilters(false);
        try {
            if (suppliedHandle == null) {
                this.identifierService.register(c, (DSpaceObject)item, filters);
            } else {
                this.identifierService.register(c, (DSpaceObject)item, suppliedHandle);
            }
        }
        catch (IdentifierException e) {
            throw new RuntimeException("Can't create an Identifier!", e);
        }
        this.populateMetadata(c, item);
        item = this.finishItem(c, item, is);
        this.itemService.inheritCollectionDefaultPolicies(c, item, collection);
        return item;
    }

    @Override
    public Item restoreItem(Context c, InProgressSubmission is, String suppliedHandle) throws SQLException, IOException, AuthorizeException {
        Item item = is.getItem();
        try {
            if (suppliedHandle == null) {
                this.identifierService.register(c, item);
            } else {
                this.identifierService.register(c, (DSpaceObject)item, suppliedHandle);
            }
        }
        catch (IdentifierException e) {
            throw new RuntimeException("Can't create an Identifier!");
        }
        DCDate now = DCDate.getCurrent();
        List<MetadataValue> dateAccessioned = this.itemService.getMetadata(item, MetadataSchemaEnum.DC.getName(), "date", "accessioned", "*");
        if (dateAccessioned.isEmpty()) {
            this.itemService.addMetadata(c, item, MetadataSchemaEnum.DC.getName(), "date", "accessioned", null, now.toString());
        }
        List<MetadataValue> currentDateIssued = this.itemService.getMetadata(item, MetadataSchemaEnum.DC.getName(), "date", "issued", "*");
        this.itemService.clearMetadata(c, item, MetadataSchemaEnum.DC.getName(), "date", "issued", "*");
        for (MetadataValue dcv : currentDateIssued) {
            if (dcv.getValue() != null && dcv.getValue().equalsIgnoreCase("today")) {
                DCDate issued = new DCDate(now.getYear(), now.getMonth(), now.getDay(), -1, -1, -1);
                this.itemService.addMetadata(c, item, dcv.getMetadataField(), dcv.getLanguage(), issued.toString());
                continue;
            }
            if (dcv.getValue() == null) continue;
            this.itemService.addMetadata(c, item, dcv.getMetadataField(), dcv.getLanguage(), dcv.getValue());
        }
        String provDescription = "Restored into DSpace on " + now + " (GMT).";
        this.itemService.addMetadata(c, item, MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription);
        return this.finishItem(c, item, is);
    }

    protected void populateMetadata(Context c, Item item) throws SQLException, AuthorizeException {
        String previousDateIssued;
        DCDate now = DCDate.getCurrent();
        this.itemService.addMetadata(c, item, MetadataSchemaEnum.DC.getName(), "date", "accessioned", null, now.toString());
        if (this.embargoService.getEmbargoTermsAsDate(c, item) == null) {
            this.itemService.addMetadata(c, item, MetadataSchemaEnum.DC.getName(), "date", "available", null, now.toString());
        }
        List<MetadataValue> currentDateIssued = this.itemService.getMetadata(item, MetadataSchemaEnum.DC.getName(), "date", "issued", "*");
        this.itemService.clearMetadata(c, item, MetadataSchemaEnum.DC.getName(), "date", "issued", "*");
        for (MetadataValue dcv : currentDateIssued) {
            if (dcv.getValue() != null && dcv.getValue().equalsIgnoreCase("today")) {
                DCDate issued = new DCDate(now.getYear(), now.getMonth(), now.getDay(), -1, -1, -1);
                this.itemService.addMetadata(c, item, dcv.getMetadataField(), dcv.getLanguage(), issued.toString());
                continue;
            }
            if (dcv.getValue() == null) continue;
            this.itemService.addMetadata(c, item, dcv.getMetadataField(), dcv.getLanguage(), dcv.getValue());
        }
        String provDescription = "Made available in DSpace on " + now + " (GMT). " + this.getBitstreamProvenanceMessage(c, item);
        if (!currentDateIssued.isEmpty() && (previousDateIssued = currentDateIssued.get(0).getValue()) != null && !previousDateIssued.equalsIgnoreCase("today")) {
            DCDate d = new DCDate(previousDateIssued);
            provDescription = provDescription + "  Previous issue date: " + d.toString();
        }
        this.itemService.addMetadata(c, item, MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription);
    }

    protected Item finishItem(Context c, Item item, InProgressSubmission is) throws SQLException, AuthorizeException {
        this.collectionService.addItem(c, is.getCollection(), item);
        item.setOwningCollection(is.getCollection());
        item.setArchived(true);
        this.itemService.update(c, item);
        c.addEvent(new Event(64, 2, item.getID(), item.getHandle(), this.itemService.getIdentifiers(c, item)));
        this.contentServiceFactory.getInProgressSubmissionService(is).deleteWrapper(c, is);
        this.embargoService.setEmbargo(c, item);
        this.deleteSupervisionOrders(c, item);
        return item;
    }

    private void deleteSupervisionOrders(Context c, Item item) throws SQLException, AuthorizeException {
        List<SupervisionOrder> supervisionOrders = this.supervisionOrderService.findByItem(c, item);
        for (SupervisionOrder supervisionOrder : supervisionOrders) {
            this.supervisionOrderService.delete(c, supervisionOrder);
        }
    }

    @Override
    public String getBitstreamProvenanceMessage(Context context, Item myitem) throws SQLException {
        List<Bitstream> bitstreams = this.itemService.getNonInternalBitstreams(context, myitem);
        StringBuilder myMessage = new StringBuilder();
        myMessage.append("No. of bitstreams: ").append(bitstreams.size()).append("\n");
        for (Bitstream bitstream : bitstreams) {
            myMessage.append(bitstream.getName()).append(": ").append(bitstream.getSizeBytes()).append(" bytes, checksum: ").append(bitstream.getChecksum()).append(" (").append(bitstream.getChecksumAlgorithm()).append(")\n");
        }
        return myMessage.toString();
    }
}

